package id.unum.crossPlatformInterfaces

import org.bouncycastle.util.io.pem.PemObject
import org.bouncycastle.util.io.pem.PemReader
import org.bouncycastle.util.io.pem.PemWriter
import java.io.StringReader
import java.io.StringWriter
import java.util.*

object PemUtil {

    internal fun toPem(description: String, byteArray: ByteArray): String {
        val pemObject = PemObject(description, byteArray)
        pemObject.generate()
        val stringWriter = StringWriter()
        val writer = PemWriter(stringWriter)
        writer.writeObject(pemObject)
        writer.flush()
        writer.close()
        return stringWriter.toString()
    }

    internal fun getPublicKeyFromPem(originalKey: String): ByteArray? {

        val stringReader = StringReader(originalKey)
        val pemReader = PemReader(stringReader);
        val pemObject = pemReader.readPemObject()

        return pemObject.content

    }

    fun getPrivateKeyFromPem(originalKey: String): ByteArray? {
        val stringReader = StringReader(originalKey)
        val pemReader = PemReader(stringReader);
        val pemObject = pemReader.readPemObject()

        return pemObject.content
    }
}