/*
 * Decompiled with CFR 0.152.
 */
package icu.funkye.redis.cache.starter.aspect;

import icu.funkye.redis.cache.starter.config.annotation.RedisCache;
import icu.funkye.redis.cache.starter.service.IRedisCacheService;
import java.time.Duration;
import java.util.Set;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.CodeSignature;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@DependsOn(value={"redisCacheService"})
@Aspect
@Component
public class RedisClusterCacheAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisClusterCacheAspect.class);
    @Autowired
    private IRedisCacheService<String, Object> redisCacheService;

    @Pointcut(value="@annotation(icu.funkye.redis.cache.starter.config.annotation.RedisCache)")
    public void annotationPoinCut() {
    }

    @Around(value="annotationPoinCut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        RedisCache annotation = signature.getMethod().getAnnotation(RedisCache.class);
        String key = annotation.key();
        Object o = null;
        if (annotation.type() == 0) {
            StringBuffer buffer = new StringBuffer();
            o = this.redisCacheService.get(key = buffer.append(key).append(joinPoint.getTarget().getClass().getName()).append(signature.getName()).append(RedisClusterCacheAspect.getNameAndValue(joinPoint)).toString());
            if (o != null) {
                LOGGER.debug("########## \u547d\u4e2d\u7f13\u5b58:{} ##########", (Object)key);
                return o;
            }
            LOGGER.debug("########## \u7f13\u5b58\u4e0d\u5b58\u5728:{} ##########", (Object)key);
        }
        try {
            o = joinPoint.proceed();
        }
        catch (Throwable e) {
            LOGGER.error("\u51fa\u73b0\u5f02\u5e38:{}", (Object)e.getMessage());
            throw e;
        }
        if (annotation.type() == 1) {
            String[] removeKey = annotation.remove();
            Long keys = 0L;
            for (String s : removeKey) {
                Set<String> deletes = this.redisCacheService.keys(s + "*");
                keys = keys + this.redisCacheService.delete(deletes);
            }
            if (keys > 0L) {
                LOGGER.debug("########## \u6e05\u9664\u7f13\u5b58\u6210\u529f:{} ##########", (Object)keys);
            }
        } else {
            LOGGER.debug("########## \u6dfb\u52a0\u7f13\u5b58\u6210\u529f:{} ##########", (Object)key);
            this.redisCacheService.setIfAbsent(key, o, Duration.ofMillis(annotation.timeoutMills()));
        }
        return o;
    }

    static String getNameAndValue(ProceedingJoinPoint joinPoint) {
        StringBuffer strings = new StringBuffer();
        Object[] paramValues = joinPoint.getArgs();
        String[] paramNames = ((CodeSignature)joinPoint.getSignature()).getParameterNames();
        for (int i = 0; i < paramNames.length; ++i) {
            strings.append(paramNames[i] + paramValues[i]);
        }
        return strings.toString();
    }
}

