/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.util.svg.primitives;

import hudson.plugins.project_inheritance.util.svg.primitives.SVGPrimitive;
import hudson.plugins.project_inheritance.util.svg.properties.ColorProperty;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGRectangle
implements SVGPrimitive {
    protected final Rectangle2D.Double box;
    protected final ColorProperty stroke;
    protected final ColorProperty fill;
    protected final AttachPoints attach;

    public SVGRectangle(Rectangle2D.Double box, ColorProperty stroke, ColorProperty fill) {
        this.box = box;
        this.stroke = stroke;
        this.fill = fill;
        this.attach = AttachPoints.MIDPOINTS;
    }

    public SVGRectangle(Rectangle2D.Double box, ColorProperty stroke, ColorProperty fill, AttachPoints pts) {
        this.box = box;
        this.stroke = stroke;
        this.fill = fill;
        this.attach = pts != null ? pts : AttachPoints.MIDPOINTS;
    }

    public String toString() {
        return String.format("box[%.2f, %.2f, %.2f, %.2f]", this.box.x, this.box.y, this.box.x + this.box.width, this.box.y + this.box.height);
    }

    @Override
    public Element render(Document doc) {
        Element e = doc.createElement("rect");
        String style = "";
        style = this.fill != null ? style + String.format("fill:#%06x;fill-opacity:%f;", this.fill.getRGB24(), this.fill.opacity) : style + String.format("fill:#%06x;fill-opacity:%f;", 0, 0.0);
        style = this.stroke != null ? style + String.format("stroke:#%06x;stroke-opacity:%f;stroke-width=%f;", this.stroke.getRGB24(), this.stroke.opacity, this.stroke.width) : style + String.format("stroke:#%06x;stroke-opacity:%f;", 0, 0.0);
        if (!style.isEmpty()) {
            e.setAttribute("style", style);
        }
        e.setAttribute("x", Double.toString(this.box.x));
        e.setAttribute("y", Double.toString(this.box.y));
        e.setAttribute("width", Double.toString(this.box.width));
        e.setAttribute("height", Double.toString(this.box.height));
        return e;
    }

    @Override
    public void translate(Point2D.Double offset) {
        if (offset == null) {
            return;
        }
        this.box.x += offset.x;
        this.box.y += offset.y;
    }

    @Override
    public void moveTo(Point2D.Double pos) {
        if (pos == null) {
            return;
        }
        this.box.x = pos.x;
        this.box.y = pos.y;
    }

    @Override
    public void rescale(double factor, boolean applyToStyles) {
        this.box.width *= factor;
        this.box.height *= factor;
    }

    @Override
    public Rectangle2D.Double getBounds() {
        return this.box;
    }

    @Override
    public List<Point2D.Double> getAttachmentPoints() {
        LinkedList<Point2D.Double> lst = new LinkedList<Point2D.Double>();
        if (this.attach.contains(AttachPoints.TOP_MID)) {
            lst.add(new Point2D.Double(this.box.getCenterX(), this.box.getMinY()));
        }
        if (this.attach.contains(AttachPoints.BTM_MID)) {
            lst.add(new Point2D.Double(this.box.getCenterX(), this.box.getMaxY()));
        }
        if (this.attach.contains(AttachPoints.MID_LEFT)) {
            lst.add(new Point2D.Double(this.box.getMinX(), this.box.getCenterY()));
        }
        if (this.attach.contains(AttachPoints.MID_RIGHT)) {
            lst.add(new Point2D.Double(this.box.getMaxX(), this.box.getCenterY()));
        }
        if (this.attach.contains(AttachPoints.TOP_LEFT)) {
            lst.add(new Point2D.Double(this.box.getMinX(), this.box.getMinY()));
        }
        if (this.attach.contains(AttachPoints.BTM_LEFT)) {
            lst.add(new Point2D.Double(this.box.getMinX(), this.box.getMaxY()));
        }
        if (this.attach.contains(AttachPoints.TOP_RIGHT)) {
            lst.add(new Point2D.Double(this.box.getMaxX(), this.box.getMinY()));
        }
        if (this.attach.contains(AttachPoints.BTM_RIGHT)) {
            lst.add(new Point2D.Double(this.box.getMaxX(), this.box.getMaxY()));
        }
        return lst;
    }

    public static enum AttachPoints {
        TOP_LEFT(1),
        TOP_MID(2),
        TOP_RIGHT(4),
        MID_LEFT(8),
        MID_RIGHT(16),
        BTM_LEFT(32),
        BTM_MID(64),
        BTM_RIGHT(128),
        TOP(TOP_LEFT, TOP_MID, TOP_RIGHT),
        BTM(BTM_LEFT, BTM_MID, BTM_RIGHT),
        LEFT(TOP_LEFT, MID_LEFT, BTM_LEFT),
        RIGHT(TOP_RIGHT, MID_RIGHT, BTM_RIGHT),
        HORIZ(TOP, BTM),
        VERT(LEFT, RIGHT),
        CORNERS(TOP_LEFT, TOP_RIGHT, BTM_LEFT, BTM_RIGHT),
        MIDPOINTS(TOP_MID, MID_LEFT, MID_RIGHT, BTM_MID),
        ALL(CORNERS, MIDPOINTS);

        public final int modulo;

        private AttachPoints(AttachPoints ... others) {
            int mod = 0;
            for (int i = 0; i < others.length; ++i) {
                mod += others[i].modulo;
            }
            this.modulo = mod;
        }

        private AttachPoints(int i) {
            this.modulo = i;
        }

        public boolean contains(AttachPoints other) {
            return (this.modulo & other.modulo) > 0;
        }
    }
}

