/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.util.svg.primitives;

import hudson.plugins.project_inheritance.util.svg.primitives.SVGPrimitive;
import hudson.plugins.project_inheritance.util.svg.properties.ColorProperty;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGLine
implements SVGPrimitive {
    protected final Point2D.Double start;
    protected final Point2D.Double end;
    protected final ColorProperty stroke;
    private volatile transient Rectangle2D.Double bounds = null;

    public SVGLine(Point2D.Double start, Point2D.Double end, ColorProperty stroke) {
        this.start = start;
        this.end = end;
        this.stroke = stroke;
    }

    public String toString() {
        return String.format("lin[%.2f, %.2f, %.2f, %.2f]", this.start.x, this.start.y, this.end.x, this.end.y);
    }

    @Override
    public Element render(Document doc) {
        Element e = doc.createElement("line");
        if (this.stroke != null) {
            String style = String.format("stroke:#%06x;stroke-opacity:%f;stroke-width:%f", this.stroke.getRGB24(), this.stroke.opacity, this.stroke.width);
            e.setAttribute("style", style);
        }
        e.setAttribute("x1", Double.toString(this.start.x));
        e.setAttribute("y1", Double.toString(this.start.y));
        e.setAttribute("x2", Double.toString(this.end.x));
        e.setAttribute("y2", Double.toString(this.end.y));
        return e;
    }

    @Override
    public void translate(Point2D.Double offset) {
        if (offset == null) {
            return;
        }
        this.start.setLocation(this.start.x + offset.x, this.start.y + offset.y);
        this.end.setLocation(this.end.x + offset.x, this.end.y + offset.y);
        this.bounds = null;
    }

    @Override
    public void moveTo(Point2D.Double pos) {
        if (pos == null) {
            return;
        }
        double xDiff = this.end.x - this.start.x;
        double yDiff = this.end.y - this.start.y;
        this.start.setLocation(pos.x, pos.y);
        this.start.setLocation(pos.x + xDiff, pos.y + yDiff);
        this.bounds = null;
    }

    @Override
    public void rescale(double factor, boolean applyToStyles) {
        double[] newDist = new double[]{(this.end.x - this.start.x) * factor, (this.end.y - this.start.y) * factor};
        this.end.x = this.start.x + newDist[0];
        this.end.y = this.start.y + newDist[1];
        if (applyToStyles) {
            this.stroke.width *= factor;
        }
        this.bounds = null;
    }

    @Override
    public Rectangle2D.Double getBounds() {
        if (this.bounds == null) {
            this.bounds = new Rectangle2D.Double(Math.min(this.start.x, this.end.x), Math.min(this.start.y, this.end.y), Math.abs(this.start.x - this.end.x), Math.abs(this.start.y - this.end.y));
        }
        return this.bounds;
    }

    @Override
    public List<Point2D.Double> getAttachmentPoints() {
        LinkedList<Point2D.Double> lst = new LinkedList<Point2D.Double>();
        lst.add(this.start);
        lst.add(this.end);
        return lst;
    }

    public static SVGLine createConnection(SVGPrimitive start, SVGPrimitive end, ColorProperty stroke) {
        List<Point2D.Double> startPts = start.getAttachmentPoints();
        List<Point2D.Double> endPts = end.getAttachmentPoints();
        if (startPts == null || startPts.isEmpty() || endPts == null || endPts.isEmpty()) {
            return null;
        }
        Point2D.Double minS = null;
        Point2D.Double minE = null;
        double minDist = Double.POSITIVE_INFINITY;
        for (Point2D.Double s : startPts) {
            for (Point2D.Double e : endPts) {
                double dist = Point2D.Double.distance(s.x, s.y, e.x, e.y);
                if (!(dist < minDist)) continue;
                minDist = dist;
                minS = s;
                minE = e;
            }
        }
        return new SVGLine(minS, minE, stroke);
    }
}

