/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.util;

import com.google.common.collect.Sets;
import com.thoughtworks.xstream.XStreamException;
import hudson.plugins.project_inheritance.util.VersionsNotification;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jenkins.model.Jenkins;

public class VersionedObjectStore
implements Serializable {
    private static final long serialVersionUID = 4783406234088486875L;
    private static final int currentFormatVersion = 1;
    private static final String formatVersionTag = "INTERNAL_FORMAT_VERSION";
    private static final Logger log = Logger.getLogger(VersionedObjectStore.class.toString());
    private final TreeMap<Version, HashMap<String, Object>> store = new TreeMap();

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(super.toString());
        b.append(" [");
        Iterator<Version> iter = this.store.keySet().iterator();
        while (iter.hasNext()) {
            Version v = iter.next();
            b.append(v.id);
            if (!iter.hasNext()) continue;
            b.append(", ");
        }
        b.append(" ]");
        return b.toString();
    }

    public String toXML() {
        return Jenkins.XSTREAM2.toXML((Object)this);
    }

    public int size() {
        return this.store.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save(File file) throws IOException {
        if (file == null) {
            return;
        }
        File tmpFile = File.createTempFile("atomic", null, file.getParentFile());
        if (tmpFile == null) {
            throw new IOException("Could not create atomic file for saving versions");
        }
        DeflaterOutputStream gzos = null;
        try {
            gzos = new GZIPOutputStream(new FileOutputStream(tmpFile));
            Jenkins.XSTREAM2.toXMLUTF8((Object)this, (OutputStream)gzos);
            gzos.close();
            if (file.exists() && !file.delete()) {
                tmpFile.delete();
                throw new IOException("Unable to delete " + file);
            }
            tmpFile.renameTo(file);
        }
        catch (Exception ex) {
            log.warning("Saving versioned object store failed due to exception: " + ex.toString());
        }
        finally {
            if (gzos != null) {
                gzos.close();
            }
            tmpFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersionedObjectStore load(File file) throws IllegalArgumentException, IOException, XStreamException {
        if (!file.exists()) {
            throw new IOException("No such file: " + file.toString());
        }
        boolean isGZ = false;
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            if (raf.length() <= 2L) {
                throw new IOException("File too short: " + file.toString());
            }
            int magic = 35615;
            byte[] bArr = new byte[2];
            raf.read(bArr);
            byte m1 = (byte)(magic >> 8);
            byte m0 = (byte)magic;
            isGZ = bArr[0] == m0 && bArr[1] == m1;
        }
        try (InputStream is = new FileInputStream(file);){
            Object obj;
            if (isGZ) {
                is = new GZIPInputStream(is);
            }
            if ((obj = Jenkins.XSTREAM2.fromXML(is)) instanceof VersionedObjectStore) {
                VersionedObjectStore versionedObjectStore = (VersionedObjectStore)obj;
                return versionedObjectStore;
            }
            throw new IllegalArgumentException("File does not describe a VersionedObjectStore");
        }
    }

    public boolean areIdentical(Version v1, Version v2) {
        Map<String, Object> map1 = this.getValueMapFor(v1.id);
        Map<String, Object> map2 = this.getValueMapFor(v2.id);
        try {
            if (map1.size() != map2.size()) {
                return false;
            }
            Sets.SetView union = Sets.union(map1.keySet(), map2.keySet());
            if (union.size() != map1.size()) {
                return false;
            }
            for (String key : union) {
                ByteArrayOutputStream os1 = new ByteArrayOutputStream();
                ByteArrayOutputStream os2 = new ByteArrayOutputStream();
                Object o1 = map1.get(key);
                Object o2 = map2.get(key);
                if (o1 == null && o2 == null) continue;
                if (o1 == null && o2 != null) {
                    return false;
                }
                if (o2 == null && o1 != null) {
                    return false;
                }
                try {
                    Jenkins.XSTREAM2.toXMLUTF8(o1, (OutputStream)os1);
                    Jenkins.XSTREAM2.toXMLUTF8(o2, (OutputStream)os2);
                }
                catch (IOException ex) {
                    return false;
                }
                if (os1.toString().equals(os2.toString())) continue;
                return false;
            }
        }
        catch (XStreamException ex) {
            return false;
        }
        return true;
    }

    public Version getLatestVersion() {
        if (this.store.isEmpty()) {
            return null;
        }
        return this.store.lastKey();
    }

    public Version getVersion(Long id) {
        if (id == null) {
            return null;
        }
        Version v = this.store.ceilingKey(new Version(id));
        if (v != null && v.id.equals(id)) {
            return v;
        }
        return null;
    }

    public Version getLatestStable() {
        if (this.store == null || this.store.isEmpty()) {
            return null;
        }
        NavigableSet<Version> descSet = this.store.descendingKeySet();
        for (Version v : descSet) {
            if (!v.stable) continue;
            return v;
        }
        return this.store.lastKey();
    }

    public LinkedList<Version> getAllVersionsSince(Long sinceVersionId) {
        LinkedList<Version> allVersionsSince = new LinkedList<Version>();
        if (this.store == null || this.store.isEmpty()) {
            return null;
        }
        NavigableSet<Version> descSet = this.store.descendingKeySet();
        for (Version v : descSet) {
            if (v.id <= sinceVersionId) break;
            allVersionsSince.add(v);
        }
        return allVersionsSince;
    }

    public Version getNearestTo(Long timestamp) {
        Version best = null;
        for (Version v : this.store.keySet()) {
            long diff = timestamp - v.timestamp;
            if (diff < 0L) break;
            best = v;
        }
        return best;
    }

    public SortedSet<Version> getAllVersions() {
        if (this.store.isEmpty()) {
            return new TreeSet<Version>();
        }
        return new TreeSet<Version>(this.store.keySet());
    }

    public Collection<HashMap<String, Object>> getAllValueMaps() {
        return this.store.values();
    }

    public Version createNextVersion() {
        if (this.store.isEmpty()) {
            return this.createNextVersionAsEmpty();
        }
        Version oldVer = this.getLatestVersion();
        HashMap<String, Object> oldMap = this.store.get(oldVer);
        Version newVer = new Version(oldVer.id + 1L);
        HashMap<String, Object> newMap = new HashMap<String, Object>(oldMap);
        this.store.put(newVer, newMap);
        this.setObjectFor(newVer, formatVersionTag, 1);
        return newVer;
    }

    public void undoVersion(Version v) {
        Version latest = this.getLatestVersion();
        if (latest == null || v == null) {
            return;
        }
        if (v.id == latest.id) {
            this.store.remove(latest);
        }
    }

    public Version createNextVersionAsEmpty() {
        Version v = this.getLatestVersion();
        v = v == null ? new Version(1L) : new Version(v.id + 1L);
        this.store.put(v, new HashMap());
        this.setObjectFor(v, formatVersionTag, 1);
        return v;
    }

    public Version createNextVersionWithMapping(Map<String, Object> map) {
        Version v = this.getLatestVersion();
        v = v == null ? new Version(1L) : new Version(v.id + 1L);
        this.store.put(v, new HashMap<String, Object>(map));
        this.setObjectFor(v, formatVersionTag, 1);
        return v;
    }

    public Object getObject(Long id, String key) {
        if (id == null || key == null) {
            return null;
        }
        Version v = new Version(id);
        HashMap<String, Object> map = this.store.get(v);
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public Object getObject(Version version, String key) {
        if (version == null || key == null) {
            return null;
        }
        return this.getObject(version.id, key);
    }

    public Map<String, Object> getValueMapFor(Long id) {
        if (id == null) {
            return null;
        }
        Version v = this.getVersion(id);
        if (v == null) {
            return null;
        }
        Map map = this.store.get(v);
        if (map == null) {
            return null;
        }
        return Collections.unmodifiableMap(map);
    }

    public boolean setObjectFor(Version v, String key, Object value) {
        if (key == null || v == null) {
            return false;
        }
        HashMap<String, Object> map = this.store.get(v);
        if (map == null) {
            throw new IllegalStateException("Found a version that is not associated with a map");
        }
        map.put(key, value);
        return true;
    }

    public VersionsNotification getUserNotificationFor(Long version) {
        if (version == null || this.getAllVersions().isEmpty()) {
            return new VersionsNotification(true, false, false, false, null);
        }
        Version selected = this.getVersion(version);
        Version latest = this.getLatestVersion();
        Version latestStable = this.getLatestStable();
        boolean isNewest = selected != null && selected == latest;
        boolean isStable = selected != null && selected.getStability();
        boolean stablesAfter = false;
        boolean stablesBefore = false;
        NavigableSet<Version> descSet = this.store.navigableKeySet();
        boolean hasPassedCurrent = false;
        for (Version v : descSet) {
            if (v == selected) {
                hasPassedCurrent = true;
                continue;
            }
            if (!v.getStability()) continue;
            if (hasPassedCurrent) {
                stablesAfter = true;
                break;
            }
            stablesBefore = true;
        }
        VersionsNotification versionsNotification = new VersionsNotification(isNewest, isStable, stablesBefore, stablesAfter, latestStable != null ? latestStable : latest);
        return versionsNotification;
    }

    public static class Version
    implements Serializable,
    Comparable<Object> {
        private static final long serialVersionUID = -5953602045057843995L;
        public final Long id;
        private boolean stable;
        private String description;
        public final long timestamp;
        private String username;

        public Version(Long id) {
            if (id == null || id < 0L) {
                throw new IllegalArgumentException("You may not assign null or negative version ids");
            }
            this.id = id;
            this.stable = false;
            this.timestamp = new Date().getTime();
        }

        public String toString() {
            return this.toString(80);
        }

        public String toString(int truncateDescription) {
            String shortDesc = truncateDescription > 3 ? (this.description == null || this.description.isEmpty() ? null : (this.description.length() < truncateDescription ? this.description : this.description.substring(0, truncateDescription - 3) + "...")) : null;
            if (shortDesc == null) {
                return String.format("%d %s", this.id, this.stable ? "(stable)" : "");
            }
            return String.format("%d %s - %s", this.id, this.stable ? "(stable)" : "", shortDesc);
        }

        public boolean getStability() {
            return this.stable;
        }

        public void setStability(boolean stable) {
            this.stable = stable;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getLocalTimestamp() {
            Date d = new Date(this.timestamp);
            return DateFormat.getInstance().format(d);
        }

        public String getStabilityString() {
            return Boolean.valueOf(this.stable).toString();
        }

        public String getUsername() {
            if (this.username == null) {
                return "";
            }
            return this.username;
        }

        public void setUsername(String user) {
            this.username = user;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Version) {
                return this.id.equals(((Version)obj).id);
            }
            if (obj instanceof Long) {
                return this.id.equals((Long)obj);
            }
            return false;
        }

        @Override
        public int compareTo(Object obj) {
            if (obj instanceof Version) {
                return this.id.compareTo(((Version)obj).id);
            }
            if (obj instanceof Long) {
                return this.id.compareTo((Long)obj);
            }
            return 0;
        }
    }
}

