/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.util;

import java.io.File;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public class PathMapping {
    private static final Pattern absPathPattern = Pattern.compile("^(/|[a-zA-Z]:|\\\\\\\\)");
    public final TreeMap<String, String> map = new TreeMap();

    public PathMapping(String srcDir, Set<String> srcFiles, String target) {
        String srcSep = PathMapping.isUnixPath(srcDir) ? "/" : "\\";
        String dstSep = PathMapping.isUnixPath(target) ? "/" : "\\";
        for (String src : srcFiles) {
            String fullSrc = String.format("%s%s%s", srcDir, srcSep, src);
            String fullDst = String.format("%s%s%s", target, dstSep, src);
            this.map.put(fullSrc, fullDst);
        }
    }

    public static boolean isUnixPath(String path) {
        if (path.contains("/")) {
            return true;
        }
        return !path.contains("\\");
    }

    public static boolean isPathSingleton(String path) {
        return !path.contains("/") && !path.contains("\\");
    }

    public static boolean isAbsolute(String path) {
        if (path == null) {
            return false;
        }
        Matcher m = absPathPattern.matcher(path);
        return m.find();
    }

    public static Map.Entry<String, String> splitPath(String path) {
        File f = new File(path);
        String base = f.getName();
        String dir = path.substring(0, path.length() - base.length() - 1);
        return new AbstractMap.SimpleEntry<String, String>(dir, base);
    }

    public static String join(String front, String end) {
        if (front == null || end == null) {
            throw new NullPointerException("May not pass null values for path parts");
        }
        if (PathMapping.isAbsolute(end)) {
            return end;
        }
        boolean isUnix = !PathMapping.isPathSingleton(front) ? PathMapping.isUnixPath(front) : (!PathMapping.isPathSingleton(end) ? PathMapping.isUnixPath(end) : true);
        if (isUnix) {
            return front + "/" + end;
        }
        return front + "\\" + end;
    }

    public static String getRelativePath(String targetPath, String basePath, String pathSeparator) {
        int commonIndex;
        String normalizedTargetPath = FilenameUtils.normalizeNoEndSeparator((String)targetPath);
        String normalizedBasePath = FilenameUtils.normalizeNoEndSeparator((String)basePath);
        if (pathSeparator.equals("/")) {
            normalizedTargetPath = FilenameUtils.separatorsToUnix((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToUnix((String)normalizedBasePath);
        } else if (pathSeparator.equals("\\")) {
            normalizedTargetPath = FilenameUtils.separatorsToWindows((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToWindows((String)normalizedBasePath);
        } else {
            throw new IllegalArgumentException("Unrecognised dir separator '" + pathSeparator + "'");
        }
        String[] base = normalizedBasePath.split(Pattern.quote(pathSeparator));
        String[] target = normalizedTargetPath.split(Pattern.quote(pathSeparator));
        StringBuilder common = new StringBuilder();
        for (commonIndex = 0; commonIndex < target.length && commonIndex < base.length && target[commonIndex].equals(base[commonIndex]); ++commonIndex) {
            common.append(target[commonIndex] + pathSeparator);
        }
        if (commonIndex == 0) {
            throw new PathResolutionException("No common path element found for '" + normalizedTargetPath + "' and '" + normalizedBasePath + "'");
        }
        boolean baseIsFile = true;
        File baseResource = new File(normalizedBasePath);
        if (baseResource.exists()) {
            baseIsFile = baseResource.isFile();
        } else if (basePath.endsWith(pathSeparator)) {
            baseIsFile = false;
        }
        StringBuilder relative = new StringBuilder();
        if (base.length != commonIndex) {
            int numDirsUp = baseIsFile ? base.length - commonIndex - 1 : base.length - commonIndex;
            for (int i = 0; i < numDirsUp; ++i) {
                relative.append(".." + pathSeparator);
            }
        }
        relative.append(normalizedTargetPath.substring(common.length()));
        return relative.toString();
    }

    static class PathResolutionException
    extends RuntimeException {
        private static final long serialVersionUID = -1260762639510818413L;

        PathResolutionException(String msg) {
            super(msg);
        }
    }
}

