/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Slave;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;

public class NodeFileSeparator {
    public static final NodeFileSeparator instance = new NodeFileSeparator();
    private Cache<Node, String> nodeLookup = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).weakKeys().build();

    private NodeFileSeparator() {
    }

    public String ensurePathCorrect(Node n, String path) {
        if (n == null) {
            return path;
        }
        String sep = this.getSepFor(n);
        String winSep = Matcher.quoteReplacement("\\");
        switch (sep) {
            case "/": {
                return path.replaceAll(winSep, "/");
            }
            case "\\": {
                return path.replaceAll("/", winSep);
            }
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSepFor(Node n) {
        if (n == null) {
            return null;
        }
        String c = (String)this.nodeLookup.getIfPresent((Object)n);
        if (c != null) {
            return c;
        }
        try {
            c = this.getRawSepFor(n.toComputer());
            if (c != null) {
                String string = c;
                return string;
            }
            if (n instanceof Slave && (c = this.getRawSepFor((Slave)n)) != null) {
                String string = c;
                return string;
            }
            c = this.getRawSepFor(n.getRootPath());
            if (c != null) {
                String string = c;
                return string;
            }
        }
        finally {
            if (c != null) {
                this.nodeLookup.put((Object)n, (Object)c);
            }
        }
        return null;
    }

    private String getRawSepFor(Computer c) {
        if (c == null) {
            return null;
        }
        String sep = null;
        try {
            Object o;
            Map map = c.getSystemProperties();
            if (map != null && map.containsKey("file.separator") && (o = map.get("file.separator")) instanceof String && ((sep = (String)o).equals("\\") || sep.equals("/"))) {
                return sep;
            }
        }
        catch (IOException | InterruptedException e) {
            return null;
        }
        return sep;
    }

    private String getRawSepFor(Slave sl) {
        if (sl == null) {
            return null;
        }
        return this.getRawSepFor(sl.getRemoteFS());
    }

    private String getRawSepFor(FilePath f) {
        if (f == null) {
            return null;
        }
        return this.getRawSepFor(f.getRemote());
    }

    private String getRawSepFor(String s) {
        if (s == null) {
            return null;
        }
        if (s.contains("/")) {
            return "/";
        }
        if (s.contains("\\")) {
            return "\\";
        }
        return null;
    }
}

