/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.view;

import com.google.common.io.Files;
import hudson.Extension;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.StringParameterValue;
import hudson.plugins.project_inheritance.projects.InheritanceBuild;
import hudson.plugins.project_inheritance.projects.InheritanceProject;
import hudson.plugins.project_inheritance.projects.versioning.VersionHandler;
import hudson.plugins.project_inheritance.projects.view.ReadOnlyConfigurationArchive;
import hudson.plugins.project_inheritance.util.PathMapping;
import hudson.tasks.BatchFile;
import hudson.tasks.Builder;
import hudson.tasks.CommandInterpreter;
import hudson.util.ListBoxModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import jenkins.model.Jenkins;
import org.apache.commons.io.FileUtils;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class InheritanceViewAction
implements Action,
Describable<InheritanceViewAction> {
    private static final String LABEL_DISPLAY_NAME = "Full Build Flow";
    private transient InheritanceBuild build;

    public InheritanceProject getProject() {
        return (InheritanceProject)this.getBuild().getParent();
    }

    public InheritanceProject getProject(StaplerRequest request) {
        return InheritanceProject.DESCRIPTOR.getConfiguredProject(request);
    }

    public InheritanceBuild getBuild() {
        if (this.build == null) {
            StaplerRequest req = Stapler.getCurrentRequest();
            return this.getBuild(req);
        }
        return this.build;
    }

    public InheritanceBuild getBuild(StaplerRequest req) {
        if (this.build == null && req != null) {
            this.build = (InheritanceBuild)((Object)req.findAncestorObject(InheritanceBuild.class));
        }
        return this.build;
    }

    private boolean isApplicableFor(InheritanceProject ip) {
        return ip != null && ip.isBuildable() && !ip.isDisabled();
    }

    public String getIconFileName() {
        InheritanceProject ip = this.getProject();
        if (this.isApplicableFor(ip)) {
            return "notepad.png";
        }
        return null;
    }

    public String getDisplayName() {
        InheritanceProject ip = this.getProject();
        if (this.isApplicableFor(ip)) {
            return LABEL_DISPLAY_NAME;
        }
        return null;
    }

    public String getUrlName() {
        InheritanceProject ip = this.getProject();
        if (this.isApplicableFor(ip)) {
            return "view";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadOnlyConfigurationArchive doDownload() {
        Map<String, Long> versions;
        Map<String, Long> map = versions = this.build != null ? this.build.getProjectVersions() : null;
        if (versions != null) {
            VersionHandler.initVersions(versions);
        }
        try {
            List builders = this.getProject().getBuildersList(InheritanceProject.IMode.INHERIT_FORCED).toList();
            try {
                File archive = this.generateExecutableCompoundScript(builders, this.getProject().getFullName(), this.getBuild().getBuildVariables());
                ReadOnlyConfigurationArchive readOnlyConfigurationArchive = new ReadOnlyConfigurationArchive(archive);
                return readOnlyConfigurationArchive;
            }
            catch (IOException ex) {
                ReadOnlyConfigurationArchive readOnlyConfigurationArchive = null;
                VersionHandler.clearVersions();
                return readOnlyConfigurationArchive;
            }
        }
        finally {
            VersionHandler.clearVersions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File generateExecutableCompoundScript(List<Builder> builders, String archiveName, Map<String, String> params) throws IOException {
        ArrayList<File> generatedScripts = new ArrayList<File>();
        File srcDir = Files.createTempDir();
        boolean isLinux = this.dumpBuildSteps(builders, generatedScripts, srcDir);
        this.dumpMasterScript(isLinux, generatedScripts, srcDir);
        File dstFile = File.createTempFile(archiveName + "_", ".tgz");
        if (dstFile.getParentFile() != null) {
            dstFile.getParentFile().mkdirs();
        }
        try {
            this.createTgzArchive(dstFile, srcDir.getAbsolutePath(), generatedScripts);
        }
        catch (IOException e) {
            File file = null;
            return file;
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)srcDir);
            }
            catch (IOException iOException) {}
        }
        return dstFile;
    }

    private void dumpMasterScript(boolean isLinux, List<File> generatedScripts, File srcDir) throws IOException {
        Map<String, String> parameters = InheritanceViewAction.getResolvedBuildParameters(this.getBuild());
        String scrFile = isLinux ? "build.sh" : "build.bat";
        String scrPreamble = isLinux ? "#!/bin/bash" : "@echo off";
        String scrSetCmd = isLinux ? "export" : "set";
        String scrInvoke = isLinux ? "./" : "CALL ";
        String lineEnd = isLinux ? "\n" : "\r\n";
        File mainScript = new File(srcDir, scrFile);
        BufferedWriter out = new BufferedWriter(new FileWriter(mainScript, true));
        out.write(scrPreamble);
        out.write(lineEnd);
        if (parameters.size() > 0) {
            for (String parameter : parameters.keySet()) {
                out.write(String.format("%s %s=\"%s\"%s", scrSetCmd, parameter, parameters.get(parameter), lineEnd));
            }
        }
        for (File script : generatedScripts) {
            if (isLinux) {
                out.write(String.format("echo 'Will run %s now ...'%s", script.getName(), lineEnd));
            } else {
                out.write(String.format("echo Will run %s now ...%s", script.getName(), lineEnd));
            }
            out.write(String.format("%s%s%s", scrInvoke, script.getName(), lineEnd));
        }
        if (isLinux) {
            mainScript.setExecutable(true, false);
            mainScript.setWritable(true, false);
            mainScript.setReadable(true, false);
        }
        out.close();
        generatedScripts.add(mainScript);
    }

    private boolean dumpBuildSteps(List<Builder> builders, List<File> generatedScripts, File srcDir) throws IOException {
        boolean isLinux = true;
        int i = 0;
        for (Builder builder : builders) {
            File builderScript;
            if (!(builder instanceof CommandInterpreter)) continue;
            CommandInterpreter ci = (CommandInterpreter)builder;
            if (builder instanceof BatchFile) {
                isLinux = false;
                builderScript = new File(srcDir, String.format("step_%d.bat", i++));
            } else {
                builderScript = new File(srcDir, String.format("step_%d.sh", i++));
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(builderScript, true));
            String cmd = ci.getCommand();
            if (!isLinux) {
                cmd = cmd.replaceAll("\r\n", "\n").replaceAll("\n", "\r\n");
            }
            out.write(cmd);
            builderScript.setExecutable(true, false);
            builderScript.setReadable(true, false);
            builderScript.setWritable(true, false);
            out.close();
            generatedScripts.add(builderScript);
        }
        return isLinux;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTgzArchive(File dstFile, String srcDir, List<File> srcFiles) throws IOException {
        FileOutputStream fos = new FileOutputStream(dstFile);
        GZIPOutputStream gzos = new GZIPOutputStream(fos);
        try (TarOutputStream tos = new TarOutputStream((OutputStream)gzos);){
            byte[] buffer = new byte[8192];
            for (File srcFile : srcFiles) {
                if (!srcFile.exists()) {
                    throw new IOException("No such file " + srcFile.getPath());
                }
                String relPath = PathMapping.getRelativePath(srcFile.getPath(), srcDir, File.separator);
                TarEntry entry = new TarEntry(relPath);
                entry.setMode(511);
                entry.setSize(srcFile.length());
                tos.putNextEntry(entry);
                try (FileInputStream fis = new FileInputStream(srcFile);){
                    int read;
                    while ((read = fis.read(buffer)) > 0) {
                        tos.write(buffer, 0, read);
                    }
                }
                tos.closeEntry();
            }
        }
    }

    public static Map<String, String> getResolvedBuildParameters(InheritanceBuild build) {
        HashMap<String, String> result = new HashMap<String, String>();
        Map buildVariables = build.getBuildVariables();
        for (String pName : buildVariables.keySet()) {
            String resolved = Util.replaceMacro((String)((String)buildVariables.get(pName)), (Map)buildVariables);
            result.put(pName, resolved);
        }
        return result;
    }

    public static Map<String, String> getResolvedBuildParameters(InheritanceProject project) {
        HashMap<String, String> result = new HashMap<String, String>();
        List<ParameterDefinition> parameters = project.getParameters(InheritanceProject.IMode.INHERIT_FORCED);
        for (ParameterDefinition pDef : parameters) {
            ParameterValue pVal = pDef.getDefaultParameterValue();
            if (!(pVal instanceof StringParameterValue)) continue;
            result.put(pDef.getName(), ((StringParameterValue)pVal).value);
        }
        return result;
    }

    public InheritanceViewActionDescriptor getDescriptor() {
        return (InheritanceViewActionDescriptor)Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    public static InheritanceViewActionDescriptor getDescriptorStatic() {
        return (InheritanceViewActionDescriptor)Jenkins.getInstance().getDescriptorOrDie(InheritanceViewAction.class);
    }

    @Extension(ordinal=1000.0)
    public static final class InheritanceViewActionDescriptor
    extends Descriptor<InheritanceViewAction> {
        public String getDisplayName() {
            return "Inheritance View";
        }

        public ListBoxModel doFillProjectClassItems() {
            return InheritanceProject.DESCRIPTOR.doFillCreationClassItems();
        }
    }
}

