/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.parameters;

import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.model.JobPropertyDescriptor;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.RunParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.plugins.project_inheritance.projects.InheritanceProject;
import hudson.plugins.project_inheritance.projects.actions.VersioningAction;
import hudson.plugins.project_inheritance.projects.parameters.InheritableStringParameterDefinition;
import hudson.plugins.project_inheritance.projects.references.AbstractProjectReference;
import hudson.plugins.project_inheritance.projects.references.ProjectReference;
import hudson.plugins.project_inheritance.projects.versioning.VersionHandler;
import hudson.plugins.project_inheritance.projects.view.BuildViewExtension;
import hudson.plugins.project_inheritance.util.Reflection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.Jenkins;
import jenkins.util.TimeDuration;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Flavor;

public class InheritanceParametersDefinitionProperty
extends ParametersDefinitionProperty {
    public static final String VERSION_PARAM_NAME = "JENKINS_JOB_VERSIONS";
    private transient List<ScopeEntry> scopeCache = null;

    public InheritanceParametersDefinitionProperty(AbstractProject<?, ?> owner, List<ParameterDefinition> parameterDefinitions) {
        super(InheritanceParametersDefinitionProperty.copyAndSortParametersByName(parameterDefinitions));
        this.owner = owner;
        this.applyOwnerToDefinitions();
    }

    public InheritanceParametersDefinitionProperty(AbstractProject<?, ?> owner, ParameterDefinition ... parameterDefinitions) {
        this(owner, Arrays.asList(parameterDefinitions));
    }

    public InheritanceParametersDefinitionProperty(AbstractProject<?, ?> owner, ParametersDefinitionProperty other) {
        this(owner, other.getParameterDefinitions());
    }

    public static final List<ParameterDefinition> copyAndSortParametersByName(List<ParameterDefinition> in) {
        TreeSet<ParameterDefinition> tree = new TreeSet<ParameterDefinition>(new Comparator<ParameterDefinition>(){

            @Override
            public int compare(ParameterDefinition o1, ParameterDefinition o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (ParameterDefinition pd : in) {
            if (pd instanceof RunParameterDefinition) {
                Job job = ((RunParameterDefinition)pd).getProject();
                if (job == null) continue;
                tree.add(pd);
                continue;
            }
            tree.add(pd.copyWithDefaultValue(pd.getDefaultParameterValue()));
        }
        return new LinkedList<ParameterDefinition>(tree);
    }

    public static InheritanceParametersDefinitionProperty createMerged(ParametersDefinitionProperty prior, ParametersDefinitionProperty latter) {
        ParametersDefinitionProperty[] pdps;
        InheritanceProject newOwner = null;
        for (ParametersDefinitionProperty pdp : pdps = new ParametersDefinitionProperty[]{latter, prior}) {
            if (pdp.getOwner() == null || !(pdp.getOwner() instanceof InheritanceProject)) continue;
            newOwner = (InheritanceProject)pdp.getOwner();
            break;
        }
        HashMap<String, ParameterDefinition> unifyMap = new HashMap<String, ParameterDefinition>();
        for (int i = pdps.length - 1; i >= 0; --i) {
            ParametersDefinitionProperty pdp = pdps[i];
            for (ParameterDefinition pd : pdp.getParameterDefinitions()) {
                unifyMap.put(pd.getName(), pd);
            }
        }
        LinkedList<ParameterDefinition> unifyList = new LinkedList<ParameterDefinition>(unifyMap.values());
        InheritanceParametersDefinitionProperty out = new InheritanceParametersDefinitionProperty((AbstractProject<?, ?>)newOwner, (List<ParameterDefinition>)unifyList);
        return out;
    }

    private void applyOwnerToDefinitions() {
        for (ParameterDefinition pd : this.getParameterDefinitions()) {
            if (!(pd instanceof InheritableStringParameterDefinition)) continue;
            InheritableStringParameterDefinition ispd = (InheritableStringParameterDefinition)pd;
            ispd.setRootProperty(this);
        }
    }

    @Deprecated
    public void _doBuild(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this._doBuild(req, rsp, this.getDelayFromRequest(req));
    }

    public void _doBuild(StaplerRequest req, StaplerResponse rsp, @QueryParameter TimeDuration delay) throws IOException, ServletException {
        if (!req.getMethod().equals("POST")) {
            req.getView((Object)this, "index.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
            return;
        }
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
        JSONObject formData = req.getSubmittedForm();
        JSONArray a = JSONArray.fromObject((Object)formData.get("parameter"));
        for (Object o : a) {
            ParameterValue parameterValue;
            if (!(o instanceof JSONObject)) continue;
            JSONObject jo = (JSONObject)o;
            String name = jo.getString("name");
            ParameterDefinition d = this.getParameterDefinition(name);
            if (d != null) {
                parameterValue = d.createValue(req, jo);
            } else if (jo.has("value")) {
                parameterValue = new StringParameterValue(name, jo.getString("value"));
            } else {
                throw new IllegalArgumentException("No such parameter definition and also not a string parameter: " + name);
            }
            if (parameterValue == null) continue;
            values.add(parameterValue);
        }
        if (delay == null) {
            delay = new TimeDuration((long)this.getJob().getQuietPeriod());
        }
        CauseAction ca = this.owner instanceof InheritanceProject ? ((InheritanceProject)this.owner).getBuildCauseOverride(req) : new CauseAction((Cause)new Cause.UserIdCause());
        req.getAncestors();
        List<Object> actions = this.owner instanceof AbstractProject ? BuildViewExtension.callAll((AbstractProject)this.owner, req) : Collections.emptyList();
        actions.add(new VersioningAction(VersionHandler.getVersions()));
        actions.add(ca);
        actions.add(new ParametersAction(values));
        BuildViewExtension.mergeParameters(actions);
        Jenkins.getInstance().getQueue().schedule2((Queue.Task)this.owner, delay.getTime(), actions);
        if (req.getAttribute("rebuildNoRedirect") == null) {
            rsp.sendRedirect(".");
        }
    }

    @Deprecated
    public void buildWithParameters(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.buildWithParameters(req, rsp, this.getDelayFromRequest(req));
    }

    public void buildWithParameters(StaplerRequest req, StaplerResponse rsp, @CheckForNull TimeDuration delay) throws IOException, ServletException {
        LinkedList<Object> actions = new LinkedList<Object>();
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
        for (ParameterDefinition d : this.getParameterDefinitions()) {
            ParameterValue value = d.createValue(req);
            if (value == null) continue;
            values.add(value);
        }
        actions.add(new ParametersAction(values));
        CauseAction buildCause = null;
        buildCause = this.owner instanceof InheritanceProject ? ((InheritanceProject)this.owner).getBuildCauseOverride(req) : new CauseAction((Cause)new Cause.UserIdCause());
        actions.add(buildCause);
        if (this.owner instanceof AbstractProject) {
            VersioningAction va = new VersioningAction((AbstractProject)this.owner);
            actions.add(va);
        }
        if (delay == null) {
            delay = new TimeDuration((long)this.getJob().getQuietPeriod());
        }
        Jenkins.getInstance().getQueue().schedule2((Queue.Task)this.owner, delay.getTime(), actions);
        if (this.requestWantsJson(req)) {
            rsp.setContentType("application/json");
            rsp.serveExposedBean(req, (Object)this.owner, Flavor.JSON);
        } else {
            rsp.sendRedirect(".");
        }
    }

    private boolean requestWantsJson(StaplerRequest req) {
        String a = req.getHeader("Accept");
        if (a == null) {
            return false;
        }
        return !a.contains("text/html") && a.contains("application/json");
    }

    private TimeDuration getDelayFromRequest(StaplerRequest req) {
        return req.hasParameter("delay") ? TimeDuration.fromString((String)req.getParameter("delay")) : new TimeDuration(0L);
    }

    public List<ParameterDefinition> getParameterDefinitionSubset(boolean showHidden) {
        LinkedList<ParameterDefinition> out = new LinkedList<ParameterDefinition>();
        for (ParameterDefinition pd : this.getParameterDefinitions()) {
            Object o = Reflection.invokeIfPossible(pd, "getIsHidden", new Object[0]);
            if (o == null || !(o instanceof Boolean)) {
                if (showHidden) continue;
                out.add(pd);
                continue;
            }
            Boolean isHidden = (Boolean)o;
            if (isHidden.booleanValue() && showHidden) {
                out.add(pd);
                continue;
            }
            if (isHidden.booleanValue() || showHidden) continue;
            out.add(pd);
        }
        return out;
    }

    public List<ParameterDefinition> getParameterDefinitions() {
        return super.getParameterDefinitions();
    }

    public ParameterDefinition getParameterDefinition(String name) {
        return super.getParameterDefinition(name);
    }

    public List<String> getParameterDefinitionNames() {
        return super.getParameterDefinitionNames();
    }

    public List<ScopeEntry> getAllScopedParameterDefinitions() {
        if (this.scopeCache != null) {
            return this.scopeCache;
        }
        LinkedList<ScopeEntry> lst = new LinkedList<ScopeEntry>();
        AbstractProject p = this.getOwner();
        if (p == null || !(p instanceof InheritanceProject)) {
            return lst;
        }
        InheritanceProject ip = (InheritanceProject)p;
        for (AbstractProjectReference ref : ip.getAllParentReferences(ProjectReference.PrioComparator.SELECTOR.PARAMETER, true)) {
            ParametersDefinitionProperty parPDP;
            InheritanceProject par = ref.getProject();
            if (par == null || (parPDP = par.getProperty(ParametersDefinitionProperty.class, InheritanceProject.IMode.LOCAL_ONLY)) == null) continue;
            for (ParameterDefinition pd : parPDP.getParameterDefinitions()) {
                lst.add(new ScopeEntry(par.getFullName(), pd));
            }
        }
        InheritanceParametersDefinitionProperty variance = ip.getVarianceParameters();
        if (variance != null) {
            for (ParameterDefinition pd : variance.getParameterDefinitions()) {
                lst.add(new ScopeEntry(ip.getFullName(), pd));
            }
        }
        this.scopeCache = Collections.unmodifiableList(lst);
        return this.scopeCache;
    }

    public List<ScopeEntry> getScopedParameterDefinition(String name) {
        List<ScopeEntry> all = this.getAllScopedParameterDefinitions();
        LinkedList<ScopeEntry> out = new LinkedList<ScopeEntry>();
        for (ScopeEntry se : all) {
            String sName = se.param.getName();
            if (!StringUtils.equals((String)sName, (String)name)) continue;
            out.add(se);
        }
        return out;
    }

    public JobPropertyDescriptor getDescriptor() {
        return (JobPropertyDescriptor)Jenkins.getInstance().getDescriptorOrDie(ParametersDefinitionProperty.class);
    }

    public static class DescriptorImpl
    extends ParametersDefinitionProperty.DescriptorImpl {
    }

    public static class ScopeEntry {
        public final String owner;
        public final ParameterDefinition param;

        public ScopeEntry(String owner, ParameterDefinition param) {
            this.owner = owner;
            this.param = param;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append('[');
            b.append(this.owner);
            b.append(", ");
            b.append(this.param.toString());
            b.append(']');
            return b.toString();
        }
    }
}

