/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.parameters;

import com.thoughtworks.xstream.converters.Converter;
import hudson.Extension;
import hudson.RelativePath;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Items;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.Run;
import hudson.model.StringParameterValue;
import hudson.model.TopLevelItem;
import hudson.plugins.project_inheritance.projects.InheritanceProject;
import hudson.plugins.project_inheritance.projects.parameters.InheritableParameterReferenceConverter;
import hudson.plugins.project_inheritance.projects.parameters.InheritableStringParameterDefinition;
import hudson.plugins.project_inheritance.projects.parameters.InheritanceParametersDefinitionProperty;
import hudson.plugins.project_inheritance.projects.parameters.Messages;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.XStream2;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class InheritableStringParameterReferenceDefinition
extends InheritableStringParameterDefinition {
    private static final long serialVersionUID = 6758820021906716839L;

    @DataBoundConstructor
    public InheritableStringParameterReferenceDefinition(String name, String defaultValue) {
        super(name, defaultValue);
    }

    public InheritableStringParameterReferenceDefinition(InheritableStringParameterDefinition other) {
        super(other);
    }

    @Initializer(before=InitMilestone.PLUGINS_STARTED)
    public static void initializeXStream() {
        XStream2[] xs;
        InheritableParameterReferenceConverter conv = new InheritableParameterReferenceConverter();
        for (XStream2 x : xs = new XStream2[]{Jenkins.XSTREAM2, Run.XSTREAM2, Items.XSTREAM2}) {
            x.registerConverter((Converter)conv);
        }
    }

    public InheritableStringParameterDefinition getParent() {
        InheritanceParametersDefinitionProperty ipdp = this.getRootProperty();
        if (ipdp == null) {
            return null;
        }
        String selfOwner = ipdp.getOwner().getFullName();
        List<InheritanceParametersDefinitionProperty.ScopeEntry> scope = ipdp.getAllScopedParameterDefinitions();
        ListIterator<InheritanceParametersDefinitionProperty.ScopeEntry> iter = scope.listIterator(scope.size());
        while (iter.hasPrevious()) {
            InheritanceParametersDefinitionProperty.ScopeEntry entry = iter.previous();
            if (entry.param == null || entry.owner == selfOwner || entry.param == this || !(entry.param instanceof InheritableStringParameterDefinition) || entry.param instanceof InheritableStringParameterReferenceDefinition || !entry.param.getName().equals(this.getName())) continue;
            return (InheritableStringParameterDefinition)entry.param;
        }
        return null;
    }

    @Override
    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValue) {
        if (!(defaultValue instanceof StringParameterValue)) {
            return super.copyWithDefaultValue(defaultValue);
        }
        StringParameterValue spv = (StringParameterValue)defaultValue;
        String value = spv.value;
        InheritableStringParameterReferenceDefinition isprd = new InheritableStringParameterReferenceDefinition(this.getName(), value);
        isprd.setRootProperty(this.getRootProperty());
        return isprd;
    }

    @Override
    public boolean getMustHaveDefaultValue() {
        InheritableStringParameterDefinition parent = this.getParent();
        if (parent == null) {
            return super.getMustHaveDefaultValue();
        }
        return parent.getMustHaveDefaultValue();
    }

    @Override
    public boolean getMustBeAssigned() {
        InheritableStringParameterDefinition parent = this.getParent();
        if (parent == null) {
            return super.getMustBeAssigned();
        }
        return parent.getMustBeAssigned();
    }

    @Override
    public InheritableStringParameterDefinition.IModes getInheritanceModeAsVar() {
        InheritableStringParameterDefinition parent = this.getParent();
        if (parent == null) {
            return super.getInheritanceModeAsVar();
        }
        return parent.getInheritanceModeAsVar();
    }

    public String getDescription() {
        InheritableStringParameterDefinition parent = this.getParent();
        if (parent == null) {
            return super.getDescription();
        }
        return parent.getDescription();
    }

    @Override
    public boolean getIsHidden() {
        InheritableStringParameterDefinition parent = this.getParent();
        if (parent == null) {
            return super.getIsHidden();
        }
        return parent.getIsHidden();
    }

    @Override
    public InheritableStringParameterDefinition.WhitespaceMode getWhitespaceModeAsVar() {
        InheritableStringParameterDefinition parent = this.getParent();
        if (parent == null) {
            return InheritableStringParameterDefinition.WhitespaceMode.KEEP;
        }
        return parent.getWhitespaceModeAsVar();
    }

    @Extension
    public static class DescriptorImpl
    extends InheritableStringParameterDefinition.DescriptorImpl {
        @Override
        public String getDisplayName() {
            return Messages.InheritableStringParameterReferencesDefinition_DisplayName();
        }

        @Override
        public String getHelpFile() {
            return "/plugin/project-inheritance/help/parameter/inheritableString.html";
        }

        @Override
        public FormValidation doCheckDefaultValue(@QueryParameter String name) {
            return FormValidation.ok();
        }

        public ListBoxModel doFillNameItems(@QueryParameter String name, @AncestorInPath InheritanceProject project, @RelativePath(value="..") @QueryParameter String targetJob, @QueryParameter String parents) {
            TopLevelItem item;
            ListBoxModel m = new ListBoxModel();
            HashSet<InheritanceProject> references = new HashSet<InheritanceProject>();
            if (project != null) {
                references.add(project);
            }
            if (targetJob != null && (item = Jenkins.getInstance().getItem(targetJob)) instanceof InheritanceProject) {
                references.add((InheritanceProject)item);
            }
            if (StringUtils.isNotBlank((String)parents)) {
                String[] jobs = parents.split(",");
                for (String job : jobs) {
                    TopLevelItem item2;
                    if (StringUtils.isBlank((String)job) || !((item2 = Jenkins.getInstance().getItem(job.trim())) instanceof InheritanceProject)) continue;
                    references.add((InheritanceProject)item2);
                }
            }
            TreeSet<String> nameSet = new TreeSet<String>();
            for (InheritanceProject proj : references) {
                InheritanceProject.IMode mode = proj == project ? InheritanceProject.IMode.LOCAL_ONLY : InheritanceProject.IMode.INHERIT_FORCED;
                List<ParameterDefinition> pDefs = proj.getParameters(mode);
                for (ParameterDefinition pd : pDefs) {
                    String paramName;
                    if (pd == null || (paramName = pd.getName()) == null) continue;
                    nameSet.add(paramName);
                }
            }
            if (StringUtils.isNotBlank((String)name)) {
                nameSet.add(name);
            }
            for (String n : nameSet) {
                m.add(n, n);
            }
            return m;
        }
    }
}

