/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.actions;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.TransientProjectActionFactory;
import hudson.plugins.project_inheritance.projects.InheritanceProject;
import hudson.plugins.project_inheritance.projects.actions.InheritanceListAction;
import hudson.plugins.project_inheritance.projects.actions.service.CachingInheritanceListService;
import hudson.plugins.project_inheritance.projects.actions.service.InheritanceListService;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;

@Extension
public final class InheritanceListActionFactory
extends TransientProjectActionFactory {
    private static final Logger log = Logger.getLogger(InheritanceListActionFactory.class.toString());
    private final InheritanceListService service = new CachingInheritanceListService();

    public InheritanceListActionFactory() {
        log.info(String.format("Extension %s instantiated", ((Object)((Object)this)).getClass().getSimpleName()));
    }

    public Collection<? extends Action> createFor(AbstractProject target) {
        Collection<Object> result;
        if (target instanceof InheritanceProject) {
            InheritanceProject job = (InheritanceProject)target;
            InheritanceListService service = this.getService();
            InheritanceListAction action = new InheritanceListAction(job, service);
            result = Collections.singleton(action);
            log.fine(String.format("Added %s to job '%s'", InheritanceListAction.class.getSimpleName(), job.getFullName()));
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    private InheritanceListService getService() {
        return this.service;
    }
}

