/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.util.svg.renderers;

import hudson.plugins.project_inheritance.util.svg.Graph;
import hudson.plugins.project_inheritance.util.svg.SVGNode;
import hudson.plugins.project_inheritance.util.svg.primitives.SVGPrimitive;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SVGGraphRenderer {
    protected final Graph<SVGNode> graph;
    protected final int width;
    protected final int height;

    public SVGGraphRenderer(Graph<SVGNode> graph, int width, int height) {
        this.graph = graph;
        this.width = width;
        this.height = height;
    }

    public Document render() {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        if (doc == null) {
            return null;
        }
        Element root = doc.createElement("svg");
        root.setAttribute("xmlns", "http://www.w3.org/2000/svg");
        root.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        root.setAttribute("xmlns:ev", "http://www.w3.org/2001/xml-events");
        root.setAttribute("version", "1.1");
        root.setAttribute("baseProfile", "full");
        doc.appendChild(root);
        Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
        Collection<SVGPrimitive> children = this.getElements();
        if (children != null) {
            for (SVGPrimitive e : children) {
                root.appendChild(e.render(doc));
                Rectangle2D.Double.union(e.getBounds(), bounds, bounds);
            }
        }
        root.setAttribute("width", String.format("%dpx", this.width > 0 ? this.width : (int)bounds.width + 3));
        root.setAttribute("height", String.format("%dpx", this.height > 0 ? this.height : (int)bounds.height + 3));
        return doc;
    }

    public abstract Collection<SVGPrimitive> getElements();
}

