/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.util.svg.properties;

import hudson.plugins.project_inheritance.util.svg.properties.ColorProperty;

public class TextProperty {
    public String[] text;
    public int fontSzPx;
    public int horizLineDist;
    public String fontName;
    public ColorProperty color;
    public STYLE style;

    public TextProperty(String text, ColorProperty color, STYLE style, String fontName, int fontSizePx, int horizLineDist) {
        if (text == null || text.length() == 0) {
            this.text = new String[1];
            this.text[0] = "";
        } else {
            this.text = text.replace("&", "&amp;").replace("<", "&gt;").split("\n");
        }
        this.color = color;
        this.fontName = fontName == null ? "" : fontName;
        this.fontSzPx = fontSizePx <= 0 ? 1 : fontSizePx;
        this.horizLineDist = horizLineDist;
        this.style = style == null ? STYLE.PLAIN : style;
    }

    public int getAwtFontStyle() {
        switch (this.style) {
            default: {
                return 0;
            }
            case ITALIC: {
                return 2;
            }
            case BOLD: {
                return 1;
            }
            case BOLDITALIC: 
        }
        return 3;
    }

    public int getSizeAsPx() {
        return this.fontSzPx;
    }

    public int getSizeAsPts() {
        return TextProperty.sizePxToPts(this.fontSzPx);
    }

    public String getText() {
        if (this.text == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.text.length; ++i) {
            b.append(this.text[0]);
            if (i + 1 >= this.text.length) continue;
            b.append('\n');
        }
        return b.toString();
    }

    public static int sizePxToPts(int px) {
        return (int)Math.ceil((double)px * 0.75);
    }

    public static int sizePtsToPx(int pts) {
        return (int)Math.round((double)pts * 1.3333333333333333);
    }

    public static enum STYLE {
        PLAIN,
        BOLD,
        ITALIC,
        BOLDITALIC;

    }
}

