/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.util;

import hudson.plugins.project_inheritance.util.Messages;
import hudson.plugins.project_inheritance.util.VersionedObjectStore;

public class VersionsNotification {
    private final boolean isNewest;
    private final boolean isStable;
    private final boolean stablesBefore;
    private final boolean stablesAfter;
    private final boolean isWarning;
    private final String notificationMessage;
    private final VersionedObjectStore.Version latestStable;
    private boolean highlightWarning = false;

    public VersionsNotification(boolean isNewest, boolean isStable, boolean stablesBefore, boolean stablesAfter, VersionedObjectStore.Version latestStableVersion) {
        this.isNewest = isNewest;
        this.isStable = isStable;
        this.stablesBefore = stablesBefore;
        this.stablesAfter = stablesAfter;
        this.latestStable = latestStableVersion;
        StringBuffer msg = new StringBuffer();
        boolean bl = this.isWarning = !isStable && stablesAfter || !isNewest && !isStable && !stablesBefore && !stablesAfter;
        if (this.isWarning) {
            msg.append(Messages.VersionsNotification_WARNING());
            msg.append(' ');
        }
        if (isNewest) {
            msg.append(Messages.VersionsNotification_VERSION_NEWEST());
        } else {
            msg.append(Messages.VersionsNotification_VERSION_OLDER());
        }
        if (isStable) {
            msg.append(Messages.VersionsNotification_VERSION_SELF_STABLE());
        } else {
            msg.append(Messages.VersionsNotification_VERSION_SELF_UNSTABLE());
        }
        msg.append(' ');
        if (stablesAfter) {
            msg.append(Messages.VersionsNotification_VERSION_STABLE_FUTURE());
        } else if (stablesBefore) {
            msg.append(Messages.VersionsNotification_VERSION_STABLE_PAST());
        } else {
            msg.append(Messages.VersionsNotification_VERSION_STABLE_NONE());
            msg.append(' ');
            msg.append(Messages.VersionsNotification_VERSION_IMPLICIT());
        }
        msg.append(' ');
        msg.append(Messages.VersionsNotification_LATEST());
        msg.append(' ');
        if (latestStableVersion != null) {
            msg.append(latestStableVersion.id);
        } else {
            msg.append("N/A");
        }
        this.notificationMessage = msg.toString();
    }

    public boolean isNewest() {
        return this.isNewest;
    }

    public boolean isStable() {
        return this.isStable;
    }

    public boolean hasStablesBefore() {
        return this.stablesBefore;
    }

    public boolean hasStablesAfter() {
        return this.stablesAfter;
    }

    public boolean isWarning() {
        return this.isWarning;
    }

    public String getNotificationMessage() {
        return this.notificationMessage;
    }

    public boolean isHighlightWarning() {
        return this.highlightWarning;
    }

    public boolean areAllVersionsUnstable() {
        return !this.isStable && !this.stablesAfter && !this.stablesBefore;
    }
}

