/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.creation;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.plugins.project_inheritance.projects.creation.Messages;
import hudson.plugins.project_inheritance.projects.creation.ProjectCreationEngine;
import hudson.plugins.project_inheritance.projects.creation.ProjectTemplate;
import hudson.plugins.project_inheritance.util.MockItemGroup;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class ProjectWizard
extends MockItemGroup<Job<?, ?>> {
    @Extension
    public static final ProjectWizardDescriptor DESCRIPTOR = new ProjectWizardDescriptor();

    @Override
    public ProjectWizardDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public static class ProjectWizardDescriptor
    extends TopLevelItemDescriptor {
        public boolean isApplicableIn(ItemGroup parent) {
            return !ProjectCreationEngine.instance.getTemplates().isEmpty();
        }

        public TopLevelItem newInstance(ItemGroup parent, String name) {
            String templateName;
            StaplerRequest req = Stapler.getCurrentRequest();
            if (req == null) {
                return null;
            }
            try {
                JSONObject form = req.getSubmittedForm();
                if (form == null || !form.has("templateName")) {
                    return null;
                }
                templateName = form.getString("templateName");
            }
            catch (ServletException ex) {
                return null;
            }
            AbstractProject<?, ?> project = null;
            List<ProjectTemplate> templates = ProjectCreationEngine.instance.getTemplates();
            for (ProjectTemplate template : templates) {
                if (!template.getName().equals(templateName)) continue;
                AbstractProject<?, ?> p = template.getProject();
                if (p == null) {
                    return null;
                }
                project = p;
                break;
            }
            try {
                return (TopLevelItem)Jenkins.get().copy(project, name);
            }
            catch (IOException e) {
                return null;
            }
        }

        public String getDisplayName() {
            return Messages.ProjectWizard_DisplayName();
        }

        public String getDescription() {
            return super.getDescription();
        }

        public String getCategoryId() {
            return "inheritable-projects";
        }

        public String getIconClassName() {
            return "icon-wizard-project";
        }

        public ListBoxModel doFillNameItems() {
            ListBoxModel lbm = new ListBoxModel();
            ProjectCreationEngine pce = ProjectCreationEngine.instance;
            for (ProjectTemplate t : pce.getTemplates()) {
                if (t.getProject() == null) continue;
                lbm.add(t.toString(), t.getName());
            }
            if (!lbm.isEmpty()) {
                ((ListBoxModel.Option)lbm.get((int)0)).selected = true;
            }
            return lbm;
        }

        static {
            IconSet.icons.addIcon(new Icon("icon-wizard-project icon-sm", "plugin/project-inheritance/images/16x16/tools-wizard.png", "width: 16px; height: 16px;"));
            IconSet.icons.addIcon(new Icon("icon-wizard-project icon-md", "plugin/project-inheritance/images/24x24/tools-wizard.png", "width: 24px; height: 24px;"));
            IconSet.icons.addIcon(new Icon("icon-wizard-project icon-lg", "plugin/project-inheritance/images/32x32/tools-wizard.png", "width: 32px; height: 32px;"));
            IconSet.icons.addIcon(new Icon("icon-wizard-project icon-xlg", "plugin/project-inheritance/images/48x48/tools-wizard.png", "width: 48px; height: 48px;"));
        }
    }
}

