/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.views;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModifiableItemGroup;
import hudson.model.Saveable;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewDescriptor;
import hudson.model.ViewGroup;
import hudson.plugins.project_inheritance.projects.InheritanceProject;
import hudson.plugins.project_inheritance.projects.creation.ProjectCreationEngine;
import hudson.plugins.project_inheritance.projects.references.AbstractProjectReference;
import hudson.plugins.project_inheritance.views.Messages;
import hudson.util.DescribableList;
import hudson.util.ListBoxModel;
import hudson.views.ListViewColumn;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class RelatedProjectView
extends View {
    private transient Collection<TopLevelItem> lastItems;
    private ProjectTypes typeFilter = ProjectTypes.ALL;
    private String creationClassFilter = null;
    private Set<Relationships> selectedRelations = new HashSet<Relationships>();
    private DescribableList<AbstractProjectReference, Descriptor<AbstractProjectReference>> references;
    private DescribableList<ListViewColumn, Descriptor<ListViewColumn>> columns;

    @DataBoundConstructor
    public RelatedProjectView(String name) {
        super(name);
        this.initColumns();
    }

    public RelatedProjectView(String name, ViewGroup owner) {
        super(name, owner);
        this.initColumns();
    }

    public ProjectTypes getTypeFilter() {
        return this.typeFilter;
    }

    public Set<Relationships> getSelectedRelations() {
        return this.selectedRelations;
    }

    public List<Relationships> getAllRelations() {
        return Arrays.asList(Relationships.values());
    }

    public DescribableList<AbstractProjectReference, Descriptor<AbstractProjectReference>> getProjectReferences() {
        if (this.references == null) {
            this.references = new DescribableList((Saveable)this);
        }
        return this.references;
    }

    public String getCreationClassFilter() {
        return this.creationClassFilter;
    }

    protected void initColumns() {
        if (this.columns == null) {
            this.columns = new DescribableList((Saveable)this, (Collection)ListViewColumn.createDefaultInitialColumnList());
        }
    }

    protected boolean filterApplies(InheritanceProject ip) {
        boolean isAllSel;
        boolean isTransient = ip.getIsTransient();
        if (this.typeFilter == ProjectTypes.REGULARS && isTransient) {
            return false;
        }
        if (this.typeFilter == ProjectTypes.TRANSIENTS && !isTransient) {
            return false;
        }
        String ipClass = ip.getCreationClass();
        return this.creationClassFilter == null || this.creationClassFilter.isEmpty() || (isAllSel = this.creationClassFilter.equals(Messages.RelatedProjectView_AllClassesSelector())) || ipClass != null && ipClass.equals(this.creationClassFilter);
    }

    public Collection<TopLevelItem> getItems() {
        LinkedList<TopLevelItem> items = new LinkedList<TopLevelItem>();
        if (this.getProjectReferences().isEmpty()) {
            for (TopLevelItem item : this.getOwnerItemGroup().getItems()) {
                InheritanceProject ip;
                if (!(item instanceof InheritanceProject) || !this.filterApplies(ip = (InheritanceProject)item)) continue;
                items.add(item);
            }
            this.lastItems = items;
            return items;
        }
        boolean filterForChildren = this.selectedRelations.contains((Object)Relationships.CHILDREN);
        boolean filterForMates = this.selectedRelations.contains((Object)Relationships.PARENTS);
        boolean filterForParents = this.selectedRelations.contains((Object)Relationships.COMPATIBLES);
        TreeSet<InheritanceProject> projs = new TreeSet<InheritanceProject>();
        Iterator iter = this.getProjectReferences().iterator();
        while (iter != null && iter.hasNext()) {
            AbstractProjectReference apr = (AbstractProjectReference)iter.next();
            InheritanceProject ip = apr.getProject();
            if (ip == null) continue;
            Map<InheritanceProject, InheritanceProject.Relationship> map = ip.getRelationships();
            if (this.filterApplies(ip)) {
                projs.add(ip);
            }
            for (Map.Entry<InheritanceProject, InheritanceProject.Relationship> entry : map.entrySet()) {
                boolean suitable = filterForParents && entry.getValue().type == InheritanceProject.Relationship.Type.PARENT || filterForMates && entry.getValue().type == InheritanceProject.Relationship.Type.MATE || filterForChildren && entry.getValue().type == InheritanceProject.Relationship.Type.CHILD;
                if (!suitable) continue;
                projs.add(entry.getKey());
            }
        }
        for (InheritanceProject p : projs) {
            if (!this.filterApplies(p)) continue;
            items.add(p);
        }
        this.lastItems = items;
        return items;
    }

    public DescribableList<ListViewColumn, Descriptor<ListViewColumn>> getColumns() {
        return this.columns;
    }

    public boolean contains(TopLevelItem item) {
        if (this.lastItems == null) {
            return this.getItems().contains(item);
        }
        return this.lastItems.contains(item);
    }

    public void onJobRenamed(Item item, String oldName, String newName) {
        if (oldName == null) {
            return;
        }
        if (newName == null) {
            if (item == null) {
                return;
            }
            newName = item.getFullName();
        }
        for (AbstractProjectReference apr : this.getProjectReferences()) {
            String aName;
            if (apr == null || (aName = apr.getName()) == null || !aName.equals(oldName)) continue;
            apr.switchProject(newName);
        }
    }

    protected void submit(StaplerRequest req) throws IOException, ServletException, Descriptor.FormException {
        String type;
        ProjectTypes pt;
        if (this.references == null) {
            this.references = new DescribableList((Saveable)this);
        }
        this.references.rebuildHetero(req, req.getSubmittedForm(), AbstractProjectReference.all(), "projects");
        if (req.hasParameter("creationClassFilter")) {
            String filter = req.getParameter("creationClassFilter");
            this.creationClassFilter = filter == null || filter.isEmpty() ? null : filter;
        }
        this.typeFilter = req.hasParameter("typeFilter") ? ((pt = ProjectTypes.valueOf(type = req.getParameter("typeFilter"))) != null ? pt : ProjectTypes.ALL) : ProjectTypes.ALL;
        if (this.selectedRelations == null) {
            this.selectedRelations = new HashSet<Relationships>();
        } else {
            this.selectedRelations.clear();
        }
        for (Relationships rel : Relationships.values()) {
            if (!req.hasParameter("relation_" + rel.name())) continue;
            this.selectedRelations.add(rel);
        }
        if (this.columns == null) {
            this.columns = new DescribableList((Saveable)this);
        }
        this.columns.rebuildHetero(req, req.getSubmittedForm(), (Collection)ListViewColumn.all(), "columns");
    }

    public Item doCreateItem(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Item item = null;
        ItemGroup ig = this.getOwnerItemGroup();
        if (ig instanceof ModifiableItemGroup) {
            item = ((ModifiableItemGroup)ig).doCreateItem(req, rsp);
        }
        if (item == null || !(item instanceof InheritanceProject)) {
            return item;
        }
        InheritanceProject ip = (InheritanceProject)item;
        if (!this.creationClassFilter.isEmpty()) {
            ip.setCreationClass(this.creationClassFilter);
        }
        return item;
    }

    @Extension
    public static final class DescriptorImpl
    extends ViewDescriptor {
        public String getDisplayName() {
            return Messages.RelatedProjectView_DisplayName();
        }

        public ListBoxModel doFillProjectNameItems() {
            ListBoxModel pNames = new ListBoxModel();
            for (InheritanceProject ip : InheritanceProject.getProjectsMap().values()) {
                pNames.add(ip.getFullName());
            }
            return pNames;
        }

        public ListBoxModel doFillCreationClassFilterItems() {
            ListBoxModel names = new ListBoxModel();
            names.add(Messages.RelatedProjectView_AllClassesSelector());
            for (ProjectCreationEngine.CreationClass cl : ProjectCreationEngine.instance.getCreationClasses()) {
                names.add(cl.name);
            }
            return names;
        }
    }

    public static enum Relationships {
        PARENTS,
        CHILDREN,
        COMPATIBLES;


        public boolean matches(String str) {
            return this.name().equals(str);
        }

        public String toString() {
            switch (this) {
                case CHILDREN: {
                    return "Children of project";
                }
                case COMPATIBLES: {
                    return "Projects marked as compatible";
                }
                case PARENTS: {
                    return "Parents of project";
                }
            }
            return "N/A";
        }
    }

    public static enum ProjectTypes {
        ALL,
        TRANSIENTS,
        REGULARS;


        public boolean matches(String str) {
            return this.name().equals(str);
        }
    }
}

