/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.util.svg.properties;

import hudson.plugins.project_inheritance.util.svg.properties.ColorProperty;
import java.awt.geom.Point2D;

public class ArrowProperty {
    public ColorProperty stroke;
    public boolean fillHead;
    public double headLen;
    public double headAngle;

    public ArrowProperty(ColorProperty stroke, boolean fillHead, double headLen, double headAngle) {
        this.stroke = stroke;
        this.fillHead = fillHead;
        this.headLen = headLen;
        this.headAngle = Math.toRadians(headAngle);
    }

    public Point2D.Double[] calcArrowPoints(Point2D.Double start, Point2D.Double end) {
        int ys;
        double bodyLen = start.distance(end);
        Point2D.Double diff = new Point2D.Double(start.x - end.x, start.y - end.y);
        int xs = (int)Math.signum(diff.x);
        int s = xs == (ys = (int)Math.signum(diff.y)) ? 1 : -1;
        double c = xs < 0 || xs == 0 && ys > 0 ? Math.PI * 2 : Math.PI;
        double bodyAngle = c + (double)s * Math.asin(Math.abs(diff.y) / bodyLen);
        double sumAngle = bodyAngle + this.headAngle;
        Point2D.Double a = new Point2D.Double(end.x - Math.cos(sumAngle) * this.headLen, end.y - Math.sin(sumAngle) * this.headLen);
        sumAngle = bodyAngle - this.headAngle;
        Point2D.Double b = new Point2D.Double(end.x - Math.cos(sumAngle) * this.headLen, end.y - Math.sin(sumAngle) * this.headLen);
        Point2D.Double[] arr = new Point2D.Double[]{a, b};
        return arr;
    }
}

