/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.view.scripts;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.plugins.project_inheritance.projects.view.BuildFlowScriptExtension;
import hudson.plugins.project_inheritance.projects.view.scripts.MetaScript;
import hudson.plugins.project_inheritance.util.Resolver;
import hudson.tasks.BatchFile;
import hudson.tasks.Builder;
import hudson.tasks.CommandInterpreter;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;

@Extension
public class ShellBuildFlow
extends BuildFlowScriptExtension {
    @Override
    public void init() {
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public void filterEnvironment(Map<String, String> env) {
        env.remove("WORKSPACE");
    }

    @Override
    public List<MetaScript> getScriptsFor(File prefix, AbstractProject<?, ?> project, AbstractBuild<?, ?> build, Builder step, Map<String, String> env, AtomicInteger cnt) {
        String newShebang;
        String shebang;
        if (!(step instanceof CommandInterpreter)) {
            return Collections.emptyList();
        }
        CommandInterpreter ci = (CommandInterpreter)step;
        boolean isWindowsCmd = ci instanceof BatchFile;
        String cmd = ci.getCommand();
        if (isWindowsCmd) {
            cmd = cmd.replaceAll("\r\n", "\n").replaceAll("\n", "\r\n");
        }
        if (!StringUtils.isEmpty((String)(shebang = this.getShebang(cmd))) && !StringUtils.equals((String)shebang, (String)(newShebang = Resolver.resolveSingle(env, shebang)))) {
            cmd = newShebang + cmd.substring(shebang.length());
            shebang = newShebang;
        }
        if (shebang.startsWith("#!")) {
            shebang = shebang.substring(2);
        }
        String stepFile = String.format("step_%d%s", cnt.getAndIncrement(), isWindowsCmd ? ".bat" : this.getExtensionFor(shebang));
        return Collections.singletonList(new MetaScript(shebang, cmd, new File(prefix, stepFile)));
    }

    private String getShebang(String cmd) {
        if (StringUtils.isBlank((String)cmd)) {
            return "";
        }
        if (!cmd.startsWith("#!")) {
            return "";
        }
        return cmd.split("\r?\n", 2)[0];
    }

    private String getExtensionFor(String shebang) {
        if (StringUtils.isBlank((String)shebang)) {
            return ".sh";
        }
        if (shebang.contains("python")) {
            return ".py";
        }
        if (shebang.contains("perl")) {
            return ".pl";
        }
        return ".sh";
    }

    @Override
    public List<AbstractProject<?, ?>> getDependentProjects(AbstractProject<?, ?> p) {
        return Collections.emptyList();
    }
}

