/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects.creation;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class ProjectTemplate
implements Describable<ProjectTemplate>,
Serializable {
    private static final long serialVersionUID = 7940442135531816851L;
    private final String name;
    private final String shortDescription;
    private transient WeakReference<AbstractProject<?, ?>> project;
    @Extension
    public static final ProjectTemplateDescriptor DESCRIPTOR = new ProjectTemplateDescriptor();

    @DataBoundConstructor
    public ProjectTemplate(String name, String shortDescription) {
        this.name = name;
        this.shortDescription = shortDescription;
    }

    public String toString() {
        return String.format("%s - %s", this.name, this.shortDescription);
    }

    public AbstractProject<?, ?> getProject() {
        AbstractProject p;
        if (this.project != null && (p = (AbstractProject)this.project.get()) != null) {
            return p;
        }
        p = (AbstractProject)Jenkins.get().getItemByFullName(this.name, AbstractProject.class);
        if (p == null) {
            return null;
        }
        this.project = new WeakReference<AbstractProject>(p);
        return p;
    }

    public String getName() {
        return this.name;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public Descriptor<ProjectTemplate> getDescriptor() {
        return DESCRIPTOR;
    }

    public static class ProjectTemplateDescriptor
    extends Descriptor<ProjectTemplate> {
        public ListBoxModel doFillNameItems() {
            ListBoxModel lbm = new ListBoxModel();
            for (AbstractProject p : Jenkins.get().getItems(AbstractProject.class)) {
                lbm.add(p.getFullName(), p.getFullName());
            }
            return lbm;
        }
    }
}

