/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.project_inheritance.projects;

import com.google.common.base.Joiner;
import com.sun.mail.util.BASE64EncoderStream;
import com.thoughtworks.xstream.XStreamException;
import difflib.DiffUtils;
import difflib.Patch;
import hudson.BulkChange;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.model.Label;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Project;
import hudson.model.Queue;
import hudson.model.Saveable;
import hudson.model.StringParameterValue;
import hudson.model.TopLevelItem;
import hudson.model.TransientProjectActionFactory;
import hudson.model.listeners.ItemListener;
import hudson.model.queue.QueueTaskFuture;
import hudson.model.queue.ScheduleResult;
import hudson.model.queue.SubTask;
import hudson.model.queue.SubTaskContributor;
import hudson.plugins.project_inheritance.projects.InheritanceBuild;
import hudson.plugins.project_inheritance.projects.Messages;
import hudson.plugins.project_inheritance.projects.actions.VersioningAction;
import hudson.plugins.project_inheritance.projects.causes.BuildCauseOverride;
import hudson.plugins.project_inheritance.projects.creation.ProjectCreationEngine;
import hudson.plugins.project_inheritance.projects.inheritance.InheritanceGovernor;
import hudson.plugins.project_inheritance.projects.inheritance.ParameterSelector;
import hudson.plugins.project_inheritance.projects.parameters.InheritableStringParameterDefinition;
import hudson.plugins.project_inheritance.projects.parameters.InheritableStringParameterReferenceDefinition;
import hudson.plugins.project_inheritance.projects.rebuild.InheritanceRebuildAction;
import hudson.plugins.project_inheritance.projects.rebuild.RebuildCause;
import hudson.plugins.project_inheritance.projects.references.AbstractProjectReference;
import hudson.plugins.project_inheritance.projects.references.ParameterizedProjectReference;
import hudson.plugins.project_inheritance.projects.references.ProjectReference;
import hudson.plugins.project_inheritance.projects.references.Referencer;
import hudson.plugins.project_inheritance.projects.references.SimpleProjectReference;
import hudson.plugins.project_inheritance.projects.versioning.VersionChangeListener;
import hudson.plugins.project_inheritance.projects.versioning.VersionHandler;
import hudson.plugins.project_inheritance.projects.view.BuildViewExtension;
import hudson.plugins.project_inheritance.util.Helpers;
import hudson.plugins.project_inheritance.util.MockItemGroup;
import hudson.plugins.project_inheritance.util.ThreadAssocStore;
import hudson.plugins.project_inheritance.util.TimedBuffer;
import hudson.plugins.project_inheritance.util.VersionedObjectStore;
import hudson.plugins.project_inheritance.util.VersionsNotification;
import hudson.plugins.project_inheritance.util.exceptions.HttpStatusException;
import hudson.plugins.project_inheritance.util.svg.Graph;
import hudson.plugins.project_inheritance.util.svg.SVGNode;
import hudson.plugins.project_inheritance.util.svg.renderers.SVGTreeRenderer;
import hudson.plugins.project_inheritance.widgets.ExtendedBuildHistoryWidget;
import hudson.scm.NullSCM;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.security.PermissionScope;
import hudson.tasks.ArtifactArchiver;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Builder;
import hudson.tasks.LogRotator;
import hudson.tasks.Publisher;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.DescribableList;
import hudson.util.FormApply;
import hudson.util.ListBoxModel;
import hudson.widgets.BuildHistoryWidget;
import hudson.widgets.HistoryWidget;
import hudson.widgets.Widget;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Normalizer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jenkins.model.BuildDiscarder;
import jenkins.model.BuildDiscarderProperty;
import jenkins.model.Jenkins;
import jenkins.scm.SCMCheckoutStrategy;
import jenkins.util.TimeDuration;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.w3c.dom.Document;

public class InheritanceProject
extends Project<InheritanceProject, InheritanceBuild>
implements TopLevelItem,
Comparable<Project>,
SVGNode {
    private static final Logger log = Logger.getLogger(InheritanceProject.class.toString());
    private static ReentrantLock globalGraphBuildingLock = new ReentrantLock();
    protected static TimedBuffer<InheritanceProject, String> onInheritChangeBuffer = null;
    protected static TimedBuffer<InheritanceProject, String> onSelfChangeBuffer = null;
    protected static TimedBuffer<InheritanceProject, String> onChangeBuffer = null;
    public static Permission VERSION_CONFIG = new Permission(PERMISSIONS, "ConfigureVersions", Messages._InheritanceProject_VersionsConfigPermissionDescription(), Jenkins.ADMINISTER, PermissionScope.ITEM);
    protected transient String variance = null;
    protected transient VersionedObjectStore versionStore = null;
    protected final boolean isTransient;
    public boolean isAbstract = false;
    protected String creationClass = null;
    protected LinkedList<AbstractProjectReference> compatibleProjects = new LinkedList();
    protected LinkedList<AbstractProjectReference> parentReferences = new LinkedList();
    protected String parameterizedWorkspace;
    @Extension(ordinal=10000.0)
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @Initializer(after=InitMilestone.STARTED)
    public static void createConfigureVersionsPermission() {
    }

    protected Object readResolve() {
        if (this.parentReferences == null) {
            this.parentReferences = new LinkedList();
        }
        if (this.compatibleProjects == null) {
            this.compatibleProjects = new LinkedList();
        }
        return this;
    }

    public InheritanceProject(ItemGroup parent, String name, boolean isTransient) {
        super(parent, name);
        this.isTransient = isTransient;
        InheritanceProject.createBuffers();
        this.versionStore = this.loadVersionedObjectStore();
        InheritanceProject.clearBuffers(null);
    }

    @Override
    public int compareTo(Project o) {
        return this.name.compareTo(o.getFullName());
    }

    public String toString() {
        return this.getFullName();
    }

    public String getIconFileName() {
        return "/plugin/project-inheritance/images/64x64/gear.png";
    }

    protected Class<InheritanceBuild> getBuildClass() {
        return InheritanceBuild.class;
    }

    @Deprecated
    public static Map<String, InheritanceProject> getProjectsMap() {
        Object obj = onChangeBuffer.get(null, "getProjectsMap");
        if (obj != null && obj instanceof Map) {
            return (Map)obj;
        }
        HashMap<String, InheritanceProject> pMap = new HashMap<String, InheritanceProject>();
        for (InheritanceProject p : Jenkins.get().getAllItems(InheritanceProject.class)) {
            if (p == null) continue;
            pMap.put(p.getFullName(), p);
        }
        onChangeBuffer.set(null, "getProjectsMap", pMap);
        return pMap;
    }

    @CheckForNull
    public static InheritanceProject getProjectByName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        return (InheritanceProject)Jenkins.get().getItemByFullName(name, InheritanceProject.class);
    }

    public static void createBuffers() {
        if (onChangeBuffer == null) {
            onChangeBuffer = new TimedBuffer();
        }
        if (onSelfChangeBuffer == null) {
            onSelfChangeBuffer = new TimedBuffer();
        }
        if (onInheritChangeBuffer == null) {
            onInheritChangeBuffer = new TimedBuffer();
        }
    }

    public static void clearBuffers(InheritanceProject root) {
        InheritanceProject.createBuffers();
        if (root == null) {
            onChangeBuffer.clearAll();
            onSelfChangeBuffer.clearAll();
            onInheritChangeBuffer.clearAll();
            return;
        }
        onChangeBuffer.clearAll();
        onSelfChangeBuffer.clear(root);
        onInheritChangeBuffer.clear(root);
        Map<InheritanceProject, Relationship> relMap = root.getRelationships();
        for (Map.Entry<InheritanceProject, Relationship> e : relMap.entrySet()) {
            if (e.getValue().type == Relationship.Type.MATE) continue;
            onInheritChangeBuffer.clear(e.getKey());
        }
    }

    public void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        if (this.isTransient) {
            return;
        }
        super.doConfigSubmit(req, rsp);
    }

    protected void submit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        if (this.isTransient) {
            return;
        }
        InheritanceProject.clearBuffers(this);
        super.submit(req, rsp);
        JSONObject json = req.getSubmittedForm();
        this.isAbstract = json.has("isAbstract") ? json.getBoolean("isAbstract") : false;
        if (json.has("projects")) {
            Object obj = json.get("projects");
            List refs = AbstractProjectReference.ProjectReferenceDescriptor.newInstancesFromHeteroList((StaplerRequest)req, (Object)obj, AbstractProjectReference.all());
            if (this.parentReferences != null) {
                this.parentReferences.clear();
            } else {
                this.parentReferences = new LinkedList();
            }
            this.parentReferences.addAll(refs);
        } else if (this.parentReferences != null) {
            this.parentReferences.clear();
        }
        if (req.hasParameter("parameterizedWorkspace")) {
            this.parameterizedWorkspace = Util.fixEmptyAndTrim((String)req.getParameter("parameterizedWorkspace.directory"));
            if (this.parameterizedWorkspace != null) {
                this.parameterizedWorkspace = Normalizer.normalize(this.parameterizedWorkspace, Normalizer.Form.NFKC);
            }
        } else {
            this.parameterizedWorkspace = null;
        }
        this.creationClass = json.has("creationClass") ? json.getString("creationClass") : null;
        InheritanceProject.clearBuffers(this);
        if (json.has("versionMessageString")) {
            this.dumpConfigToNewVersion(json.getString("versionMessageString"));
        } else {
            this.dumpConfigToNewVersion();
        }
        InheritanceProject.clearBuffers(this);
    }

    public void updateByXml(Source source) throws IOException {
        if (this.getIsTransient()) {
            String msg = String.format("Updating %s by XML upload is not allowed: Transient project", this.getFullName());
            log.warning(msg);
            throw new IOException(msg);
        }
        super.updateByXml(source);
        InheritanceProject.clearBuffers(this);
        this.dumpConfigToNewVersion("New version uploaded as XML via API/CLI");
        InheritanceProject.clearBuffers(this);
        ItemListener.fireOnUpdated((Item)this);
    }

    @RequirePOST
    public synchronized void doSubmitChildJobCreation(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        if (this.isTransient) {
            return;
        }
        JSONObject json = req.getSubmittedForm();
        InheritanceProject.clearBuffers(null);
        if (json.has("properties")) {
            LinkedList<JobProperty> oldProps = new LinkedList<JobProperty>();
            for (JobProperty jobProperty : this.properties) {
                if (jobProperty instanceof ParametersDefinitionProperty) continue;
                oldProps.add(jobProperty);
            }
            DescribableList newProps = new DescribableList(NOOP);
            newProps.rebuild(req, json.optJSONObject("properties"), JobPropertyDescriptor.getPropertyDescriptors(this.getClass()));
            this.properties.clear();
            for (JobProperty p : newProps) {
                this.addProperty(p);
            }
            this.properties.addAll(oldProps);
        }
        if (json.has("compatibleProjects")) {
            Object obj = json.get("compatibleProjects");
            List refs = AbstractProjectReference.ProjectReferenceDescriptor.newInstancesFromHeteroList((StaplerRequest)req, (Object)obj, AbstractProjectReference.all());
            if (this.compatibleProjects != null) {
                this.compatibleProjects.clear();
            } else {
                this.compatibleProjects = new LinkedList();
            }
            this.compatibleProjects.addAll(refs);
        } else if (this.compatibleProjects != null) {
            this.compatibleProjects.clear();
        }
        InheritanceProject.clearBuffers(null);
        this.save();
        rsp.sendRedirect(this.getAbsoluteUrl());
        if (json.has("versionMessageString")) {
            this.dumpConfigToNewVersion(json.getString("versionMessageString"));
        } else {
            this.dumpConfigToNewVersion();
        }
        InheritanceProject.clearBuffers(this);
        ItemListener.fireOnUpdated((Item)this);
    }

    public void renameTo(String newName) throws IOException {
        if (this.name.equals(newName)) {
            return;
        }
        if (this.getIsTransient() && !ProjectCreationEngine.instance.currentUserMayRename()) {
            throw new IOException("Current user is not allowed to rename transient projects");
        }
        String oldName = this.name;
        super.renameTo(newName);
        InheritanceProject.clearBuffers(this);
        for (InheritanceProject p : InheritanceProject.getProjectsMap().values()) {
            VersionedObjectStore verStore;
            boolean modified = false;
            for (AbstractProjectReference ref : p.getRawParentReferences()) {
                if (!ref.getName().equals(oldName)) continue;
                ref.switchProject(this);
                modified = true;
            }
            for (AbstractProjectReference ref : p.compatibleProjects) {
                if (!ref.getName().equals(oldName)) continue;
                ref.switchProject(this);
                modified = true;
            }
            if (modified) {
                p.save();
            }
            if ((verStore = p.getVersionedObjectStore()) == null) continue;
            modified |= this.changeVersionedProjectReferences(verStore, "parentReferences", oldName, newName);
            if (!(modified |= this.changeVersionedProjectReferences(verStore, "compatibleProjects", oldName, newName))) continue;
            p.saveVersionedObjectStore();
        }
    }

    private boolean changeVersionedProjectReferences(VersionedObjectStore verStore, String keyInVersionStore, String oldName, String newName) {
        boolean modified = false;
        for (VersionedObjectStore.Version v : verStore.getAllVersions()) {
            LinkedList referencesInVersionStore = (LinkedList)verStore.getObject(v, keyInVersionStore);
            for (AbstractProjectReference ref : referencesInVersionStore) {
                if (!ref.getName().equals(oldName)) continue;
                ref.switchProject(newName);
                modified = true;
            }
        }
        return modified;
    }

    public void addParentReference(AbstractProjectReference ref, boolean duplicateCheck) {
        if (duplicateCheck) {
            for (AbstractProjectReference ourRef : this.getParentReferences()) {
                if (!ourRef.getName().equals(ref.getName())) continue;
                return;
            }
        }
        this.parentReferences.push(ref);
        InheritanceProject.clearBuffers(this);
    }

    public void addParentReference(AbstractProjectReference ref) {
        this.addParentReference(ref, true);
    }

    public boolean removeParentReference(String name) {
        Iterator iter = this.parentReferences.iterator();
        while (iter.hasNext()) {
            AbstractProjectReference apr = (AbstractProjectReference)iter.next();
            if (!apr.getName().equals(name)) continue;
            iter.remove();
            InheritanceProject.clearBuffers(this);
            return true;
        }
        return false;
    }

    public void setVarianceLabel(String variance) {
        if (this.isTransient && StringUtils.isNotBlank((String)variance)) {
            this.variance = variance.trim();
        }
    }

    public void setAssignedLabel(Label l) throws IOException {
        super.setAssignedLabel(l);
        InheritanceProject.clearBuffers(this);
    }

    public void setCreationClass(String creationClass) {
        if (creationClass == null) {
            return;
        }
        for (ProjectCreationEngine.CreationClass cc : ProjectCreationEngine.instance.getCreationClasses()) {
            if (!cc.name.equals(creationClass)) continue;
            this.creationClass = creationClass;
            break;
        }
    }

    protected void buildDependencyGraph(DependencyGraph graph) {
        globalGraphBuildingLock.lock();
        try {
            super.buildDependencyGraph(graph);
        }
        finally {
            globalGraphBuildingLock.unlock();
        }
    }

    public synchronized void save() throws IOException {
        if (this.isTransient) {
            return;
        }
        super.save();
    }

    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        InheritanceProject.createBuffers();
        InheritanceProject.clearBuffers(null);
        this.versionStore = new VersionedObjectStore();
        super.onLoad(parent, name);
        this.versionStore = this.loadVersionedObjectStore();
        InheritanceProject.clearBuffers(null);
    }

    public void onCopiedFrom(Item src) {
        super.onCopiedFrom(src);
        if (!(src instanceof InheritanceProject)) {
            return;
        }
        InheritanceProject ip = (InheritanceProject)src;
        if (ip.getLatestVersion() == ip.getStableVersion()) {
            this.dumpConfigToNewVersion(String.format("Copied from: %s", ip.getFullName()));
            return;
        }
        try {
            this.copyVersionedSettingsFrom(ip);
        }
        catch (IOException ex) {
            log.severe(String.format("Job '%s' could not be copied cleanly. Reason: %s", this.getFullName(), ex.getMessage()));
        }
        this.dumpConfigToNewVersion(String.format("Copied from: %s", ip.getFullName()));
    }

    public File getRootDir() {
        if (!this.isTransient) {
            return super.getRootDir();
        }
        File standardRoot = this.getParent().getRootDir();
        String pathSafeJobName = this.getFullName().replaceAll("[/\\\\]", "_");
        File newRoot = new File(standardRoot.getAbsolutePath() + File.separator + "transient_jobs" + File.separator + pathSafeJobName);
        return newRoot;
    }

    protected File getVersionFile() {
        if (this.isTransient) {
            return null;
        }
        return new File(this.getRootDir(), "versions.xml.gz");
    }

    public File getBuildDir() {
        return super.getBuildDir();
    }

    private void copyVersionedSettingsFrom(InheritanceProject src) throws IOException {
        if (src == null) {
            return;
        }
        this.parameterizedWorkspace = src.getParameterizedWorkspace(IMode.LOCAL_ONLY);
        this.setCustomWorkspace(src.getCustomWorkspace());
        this.setQuietPeriod(src.getQuietPeriodObject());
        this.setScmCheckoutStrategy(src.getScmCheckoutStrategy(IMode.LOCAL_ONLY));
        this.parentReferences.clear();
        this.parentReferences.addAll(src.getParentReferences());
        this.properties.replaceBy(src.getAllProperties(IMode.LOCAL_ONLY));
        this.getRawPublishersList().replaceBy(src.getPublishersList(IMode.LOCAL_ONLY));
        this.setBuildDiscarder(src.getBuildDiscarder(IMode.LOCAL_ONLY));
        this.blockBuildWhenDownstreamBuilding = src.blockBuildWhenDownstreamBuilding(IMode.LOCAL_ONLY);
        this.blockBuildWhenUpstreamBuilding = src.blockBuildWhenUpstreamBuilding(IMode.LOCAL_ONLY);
        this.getRawBuildWrappersList().replaceBy(src.getBuildWrappersList(IMode.LOCAL_ONLY));
        this.compatibleProjects.clear();
        this.compatibleProjects.addAll(src.getCompatibleProjects());
        this.getRawBuildersList().replaceBy(src.getBuildersList(IMode.LOCAL_ONLY));
        this.setScm(src.getScm(IMode.LOCAL_ONLY));
    }

    @WebMethod(name={"config.xml"})
    public void doConfigDotXml(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (req.getMethod().equals("POST")) {
            super.doConfigDotXml(req, rsp);
        }
        if (!req.getMethod().equals("GET")) {
            rsp.sendError(400);
        }
        this.checkPermission(EXTENDED_READ);
        if (!this.isTransient) {
            Long latestVersion = this.getLatestVersion();
            Long selectedVersion = VersionHandler.getVersion(this);
            if (selectedVersion == null || selectedVersion == latestVersion) {
                super.doConfigDotXml(req, rsp);
                return;
            }
        }
        try {
            rsp.setContentType("application/xml");
            this.writeStableConfigDotXml((OutputStream)rsp.getOutputStream());
        }
        catch (HttpStatusException ex) {
            rsp.sendError(ex.status, ex.getMessage());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeStableConfigDotXml(OutputStream out) throws IOException, HttpStatusException {
        if (out == null) {
            return;
        }
        String selfXml = Items.XSTREAM2.toXML((Object)this);
        Object obj = Items.XSTREAM2.fromXML(selfXml);
        if (!(obj instanceof InheritanceProject)) {
            throw new HttpStatusException(500, "Error, could not (de-)serialize project");
        }
        InheritanceProject mod = (InheritanceProject)obj;
        MockItemGroup mig = new MockItemGroup();
        try {
            UUID uuid = UUID.randomUUID();
            mod.onLoad(mig, uuid.toString());
            mod.versionStore = new VersionedObjectStore();
            try {
                mod.copyVersionedSettingsFrom(this);
            }
            catch (IOException ex) {
                throw new HttpStatusException(500, "Failed to produce XML for stable version", ex);
            }
            Items.XSTREAM2.toXMLUTF8((Object)mod, out);
        }
        finally {
            mig.clean();
            onChangeBuffer.clear(mod);
            onInheritChangeBuffer.clear(mod);
            onSelfChangeBuffer.clear(mod);
            onInheritChangeBuffer.clear(this);
        }
    }

    public String doGetConfigAsXML(StaplerRequest req, StaplerResponse rsp) {
        String depth = req.getParameter("depth");
        int iDepth = 0;
        if (depth != null && !depth.isEmpty()) {
            try {
                iDepth = Integer.valueOf(depth);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (iDepth <= 0) {
            Object obj = onSelfChangeBuffer.get(this, "doGetConfigAsXML");
            if (obj != null && obj instanceof String) {
                return (String)obj;
            }
            String str = Jenkins.XSTREAM2.toXML((Object)this);
            onSelfChangeBuffer.set(this, "doGetConfigAsXML", str);
            return str;
        }
        LinkedHashMap<String, InheritanceProject> projs = new LinkedHashMap<String, InheritanceProject>();
        for (AbstractProjectReference apr : this.getAllParentReferences(ProjectReference.PrioComparator.SELECTOR.BUILDER)) {
            InheritanceProject ip = apr.getProject();
            if (ip == null) continue;
            projs.put(ip.getFullName(), ip);
        }
        projs.put(this.getFullName(), this);
        return Jenkins.XSTREAM2.toXML(projs);
    }

    public String doGetParamExpansionsAsXML() {
        List<ParameterDefinition> defLst = this.getParameters(IMode.INHERIT_FORCED);
        LinkedList<ParameterValue> valLst = new LinkedList<ParameterValue>();
        for (ParameterDefinition pd : defLst) {
            ParameterValue pv = null;
            if (pd instanceof InheritableStringParameterDefinition) {
                InheritableStringParameterDefinition ispd = (InheritableStringParameterDefinition)pd;
                pv = ispd.createValue(ispd.getDefaultValue());
            } else {
                pv = pd.getDefaultParameterValue();
            }
            if (pv == null) continue;
            valLst.add(pv);
        }
        String str = Jenkins.XSTREAM2.toXML(valLst);
        return str;
    }

    public String doGetParamDefaultsAsXML() {
        Object obj = onInheritChangeBuffer.get(this, "doGetParamDefaultsAsXML");
        if (obj != null && obj instanceof String) {
            return (String)obj;
        }
        List<ParameterDefinition> defLst = this.getParameters(IMode.INHERIT_FORCED);
        LinkedList<ParameterValue> valLst = new LinkedList<ParameterValue>();
        for (ParameterDefinition pd : defLst) {
            ParameterValue pv = pd.getDefaultParameterValue();
            if (pv == null) continue;
            valLst.add(pv);
        }
        String str = Jenkins.XSTREAM2.toXML(valLst);
        onInheritChangeBuffer.set(this, "doGetParamDefaultsAsXML", str);
        return str;
    }

    public String doGetVersionsAsXML() {
        if (this.versionStore == null) {
            return "";
        }
        return this.versionStore.toXML();
    }

    public String doGetVersionsAsCompressedXML() {
        if (this.versionStore == null) {
            return "";
        }
        String xml = this.versionStore.toXML();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
            BASE64EncoderStream b64s = new BASE64EncoderStream((OutputStream)baos);
            GZIPOutputStream gos = new GZIPOutputStream((OutputStream)b64s);
            gos.write(xml.getBytes());
            gos.finish();
            gos.close();
            return baos.toString();
        }
        catch (IOException ex) {
            return "";
        }
    }

    public void doDoDelete(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
        for (Relationship rel : this.getRelationships().values()) {
            if (rel.type != Relationship.Type.CHILD && rel.type != Relationship.Type.MATE) continue;
            rsp.sendRedirect(this.getAbsoluteUrl() + "/showReferencedBy");
            return;
        }
        super.doDoDelete(req, rsp);
        InheritanceProject.clearBuffers(this);
    }

    public String doComputeVersionDiff(StaplerRequest req, StaplerResponse rsp) {
        if (!req.hasParameter("l") || !req.hasParameter("r")) {
            return "<span style=\"color:red\"><b>No left/right version selected!</b></span>";
        }
        Long l = null;
        Long r = null;
        String mode = "unified";
        try {
            l = Long.parseLong(req.getParameter("l"), 10);
            r = Long.parseLong(req.getParameter("r"), 10);
            if (req.hasParameter("mode")) {
                mode = req.getParameter("mode");
            }
        }
        catch (NumberFormatException ex) {
            return "<span style=\"color:red\"><b>Left/right version is not a number!</b></span>";
        }
        Map<String, Object> lMap = this.versionStore.getValueMapFor(l);
        if (lMap == null) {
            return "<span style=\"color:red\"><b>Left version does not exist!</b></span>";
        }
        Map<String, Object> rMap = this.versionStore.getValueMapFor(r);
        if (rMap == null) {
            return "<span style=\"color:red\"><b>Right version does not exist!</b></span>";
        }
        String lXml = Jenkins.XSTREAM2.toXML(lMap);
        String rXml = Jenkins.XSTREAM2.toXML(rMap);
        StringBuilder b = new StringBuilder();
        if (mode.equals("unified")) {
            return this.computeUnifiedDiff(5, new AbstractMap.SimpleEntry<Long, String>(l, lXml), new AbstractMap.SimpleEntry<Long, String>(r, rXml));
        }
        if (mode.equals("side")) {
            b.append("<span style=\"color:red\"><b>");
            b.append("Side-by-Side diff not yet implemented.");
            b.append("</b></span>");
        } else {
            if (mode.equals("raw")) {
                return this.computeRawTable(new AbstractMap.SimpleEntry<Long, String>(l, lXml), new AbstractMap.SimpleEntry<Long, String>(r, rXml));
            }
            b.append("<span style=\"color:red\"><b>");
            b.append("Select a valid diff mode: 'unified', 'side' (for side-by-side), or 'raw'.");
            b.append("</b></span>");
        }
        return b.toString();
    }

    public String warnUserOnUnstableVersions() {
        String warnMessage = null;
        if (this.isAbstract) {
            Deque<VersionedObjectStore.Version> stableVersions = this.getStableVersions();
            Long latestVersion = this.getLatestVersion();
            if (stableVersions.size() > 0) {
                if (!this.versionStore.getVersion(latestVersion).getStability()) {
                    warnMessage = Messages.InheritanceProject_OlderVersionMarkedAsStable();
                }
            } else {
                warnMessage = Messages.InheritanceProject_NoVersionMarkedAsStable();
            }
        }
        return warnMessage;
    }

    public VersionsNotification getCurrentVersionNotification() {
        return this.versionStore.getUserNotificationFor(VersionHandler.getVersion(this));
    }

    private static String escapeHTMLFull(String str) {
        return StringEscapeUtils.escapeHtml((String)str);
    }

    private String computeRawTable(Map.Entry<Long, String> ... versions) {
        String headFmt = "<tr><th $c style=\"width:3em\">#</th><th $c>Version %d</th><th $c style=\"width:3em\">#</th><th $c>Version %d</th></tr>".replace("$c", "class=\"mono\"");
        String rowFmt = "<tr><td $c>%d</td><td $c>%s</td><td $c>%d</td><td $c>%s</td></tr>".replace("$c", "class=\"mono\"");
        StringBuilder b = new StringBuilder();
        b.append("<table frame=\"void\" rules=\"cols\" width=\"100%\"");
        b.append("class=\"mono\">");
        b.append(String.format(headFmt, versions[0].getKey(), versions[1].getKey()));
        String[] lArr = versions[0].getValue().split("\n");
        String[] rArr = versions[1].getValue().split("\n");
        String[] lines = new String[2];
        int max = Math.max(lArr.length, rArr.length);
        for (int i = 0; i < max; ++i) {
            lines[0] = i < lArr.length ? InheritanceProject.escapeHTMLFull(lArr[i]) : "";
            lines[1] = i < rArr.length ? InheritanceProject.escapeHTMLFull(rArr[i]) : "";
            b.append(String.format(rowFmt, i, lines[0], i, lines[1]));
        }
        b.append("</table>");
        return b.toString();
    }

    private String computeUnifiedDiff(int context, Map.Entry<Long, String> ... versions) {
        if (versions.length != 2) {
            throw new IllegalArgumentException("You must pass exactly two versions");
        }
        if (context < 0) {
            context = 0;
        }
        StringBuilder b = new StringBuilder();
        List<String> lLst = Arrays.asList(versions[0].getValue().split("\n"));
        List<String> rLst = Arrays.asList(versions[1].getValue().split("\n"));
        Patch p = DiffUtils.diff(lLst, rLst);
        List outLst = DiffUtils.generateUnifiedDiff((String)("Version " + versions[0].getKey()), (String)("Version " + versions[1].getKey()), lLst, (Patch)p, (int)context);
        for (String line : outLst) {
            boolean hasColour = false;
            if (line.startsWith("++")) {
                b.append("<span style=\"color:orange\">");
                hasColour = true;
            } else if (line.startsWith("+")) {
                b.append("<span style=\"color:green\">");
                hasColour = true;
            } else if (line.startsWith("--")) {
                b.append("<span style=\"color:blue\">");
                hasColour = true;
            } else if (line.startsWith("-")) {
                b.append("<span style=\"color:red\">");
                hasColour = true;
            }
            String mod = InheritanceProject.escapeHTMLFull(line);
            b.append(mod);
            if (hasColour) {
                b.append("</span>");
            }
            b.append("<br>");
        }
        return b.toString();
    }

    protected void onBuild(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
    }

    protected void onScheduleBuild2(int quietPeriod, Cause c, Collection<? extends Action> actions) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBuild(StaplerRequest req, StaplerResponse rsp, @QueryParameter TimeDuration delay) throws IOException, ServletException {
        VersionHandler.clearVersionsPartial();
        VersionHandler.initVersions(this);
        try {
            this.doBuildInternal(req, rsp, delay);
        }
        finally {
            VersionHandler.clearVersions();
        }
    }

    private void doBuildInternal(StaplerRequest req, StaplerResponse rsp, @QueryParameter TimeDuration delay) throws IOException, ServletException {
        if (delay == null) {
            delay = new TimeDuration(0L);
        }
        this.onBuild(req, rsp);
        ACL acl = Jenkins.get().getACL();
        acl.checkPermission(BUILD);
        ParametersDefinitionProperty pp = this.getProperty(ParametersDefinitionProperty.class);
        if (pp != null) {
            if (!req.getMethod().equals("POST")) {
                req.getView((Object)pp, "index.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
                return;
            }
            pp._doBuild(req, rsp, delay);
            return;
        }
        if (!this.isBuildable()) {
            rsp.sendError(500, String.format("%s is not buildable", this.getFullName()));
            return;
        }
        List<Action> actions = BuildViewExtension.callAll(this, req);
        actions.add(new VersioningAction(VersionHandler.getVersions()));
        actions.add((Action)this.getBuildCauseOverride(req));
        Jenkins.get().getQueue().schedule2((Queue.Task)this, delay.getTime(), actions);
        if (req.getAttribute("rebuildNoRedirect") == null) {
            rsp.forwardToPreviousPage(req);
        }
    }

    public void doBuildSpecificVersion(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        if (!req.getMethod().equals("POST")) {
            req.getView((Object)this, "buildSpecificVersion").forward((ServletRequest)req, (ServletResponse)rsp);
            return;
        }
        Map<String, Long> verMap = VersionHandler.getFromFormRequest(req);
        if (verMap == null) {
            throw new Descriptor.FormException("Could not decode versioning table", "versions");
        }
        this.filterVersionMap(verMap);
        String verMapStr = VersionHandler.encodeUrlParameter(verMap);
        String verUrlParm = VersionHandler.getFullUrlParameter(verMapStr);
        if (req.hasParameter("doRefresh")) {
            rsp.sendRedirect("buildSpecificVersion?" + verUrlParm);
        } else {
            rsp.sendRedirect("build?" + verUrlParm);
        }
    }

    protected void filterVersionMap(Map<String, Long> verMap) {
        if (verMap == null) {
            return;
        }
        HashSet<String> removals = new HashSet<String>();
        for (String pName : verMap.keySet()) {
            InheritanceProject ip = (InheritanceProject)Jenkins.getInstance().getItemByFullName(pName, InheritanceProject.class);
            if (ip == null) {
                removals.add(pName);
                continue;
            }
            if (ip.getVersionedObjectStore().getAllVersions().isEmpty()) {
                removals.add(pName);
                continue;
            }
            Long selectedVersion = verMap.get(pName);
            if (selectedVersion == null || selectedVersion < 1L) {
                removals.add(pName);
                continue;
            }
            Long stableVersion = ip.getStableVersion();
            if (stableVersion == null || !stableVersion.equals(selectedVersion)) continue;
            removals.add(pName);
        }
        if (!removals.isEmpty()) {
            verMap.keySet().removeAll(removals);
        }
    }

    public void doBuildWithParameters(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        TimeDuration td = new TimeDuration(0L);
        super.doBuildWithParameters(req, rsp, td);
    }

    public QueueTaskFuture<InheritanceBuild> scheduleBuild2(int quietPeriod, Cause c, Collection<? extends Action> actions) {
        VersionHandler.clearVersions();
        LinkedList<Object> oActions = new LinkedList<Object>();
        LinkedList<VersioningAction> vActions = new LinkedList<VersioningAction>();
        LinkedList<ParametersAction> pActions = new LinkedList<ParametersAction>();
        for (Action action : actions) {
            if (action instanceof VersioningAction) {
                vActions.add((VersioningAction)action);
                continue;
            }
            if (action instanceof ParametersAction) {
                pActions.add((ParametersAction)action);
                continue;
            }
            oActions.add(action);
        }
        for (VersioningAction versioningAction : vActions) {
            VersionHandler.addVersions(versioningAction.versionMap);
        }
        for (ParametersAction parametersAction : pActions) {
            StringParameterValue spv;
            Object vMap;
            ParameterValue pv = parametersAction.getParameter("JENKINS_JOB_VERSIONS");
            if (pv == null || !(pv instanceof StringParameterValue) || (vMap = VersionHandler.decodeUrlParameter((spv = (StringParameterValue)pv).getValue().toString())) == null) continue;
            VersionHandler.addVersions(vMap);
        }
        Map<String, Long> vMap = VersionHandler.initVersions(this);
        oActions.add(new VersioningAction(vMap));
        if (!this.isBuildable()) {
            return null;
        }
        if (this.isParameterized()) {
            HashMap<String, ParameterValue> hashMap = new HashMap<String, ParameterValue>();
            for (ParametersAction pa : pActions) {
                for (ParameterValue pv : pa.getParameters()) {
                    if (pv == null || pv.getName() == null) continue;
                    hashMap.put(pv.getName(), pv);
                }
            }
            for (ParameterDefinition def : this.getParameters()) {
                ParameterValue pv;
                String pName = def.getName();
                if (hashMap.containsKey(pName)) continue;
                if (def instanceof InheritableStringParameterDefinition) {
                    InheritableStringParameterDefinition ispd = (InheritableStringParameterDefinition)def;
                    pv = ispd.createValue(ispd.getDefaultValue());
                } else {
                    pv = def.getDefaultParameterValue();
                }
                hashMap.put(pName, pv);
            }
            LinkedList pvLst = new LinkedList(hashMap.values());
            oActions.add(new ParametersAction(pvLst));
        } else {
            oActions.addAll(pActions);
        }
        if (c != null) {
            oActions.add(new CauseAction(c));
        }
        this.onScheduleBuild2(quietPeriod, c, oActions);
        ScheduleResult scheduleResult = Jenkins.get().getQueue().schedule2((Queue.Task)this, quietPeriod, oActions);
        if (scheduleResult == null || scheduleResult.isRefused()) {
            return null;
        }
        return scheduleResult.getItem().getFuture();
    }

    public CauseAction getBuildCauseOverride(StaplerRequest req) {
        List<Cause> causes = BuildCauseOverride.getBuildCauseOverrideByAll(req);
        if (this.getAuthToken() != null && this.getAuthToken().getToken() != null && req.getParameter("token") != null) {
            String causeText = req.getParameter("cause");
            causes.add((Cause)new Cause.RemoteCause(req.getRemoteAddr(), causeText));
        } else {
            Object rebuild = req.getAttribute("rebuildCause");
            if (rebuild != null && rebuild instanceof InheritanceRebuildAction) {
                InheritanceRebuildAction inheritanceRebuildAction = (InheritanceRebuildAction)rebuild;
                if (inheritanceRebuildAction.getBuild() != null) {
                    causes.add((Cause)new RebuildCause(inheritanceRebuildAction.getBuild().number, inheritanceRebuildAction.getBuild().getUrl()));
                }
            } else {
                causes.add((Cause)new Cause.UserIdCause());
            }
        }
        return new CauseAction(causes);
    }

    @RequirePOST
    public void doConfigVersionsSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        this.checkPermission(VERSION_CONFIG);
        class Entry {
            Long id;
            String desc;
            boolean stable;

            public Entry(Long id, String desc, boolean stable) {
                this.id = id;
                this.desc = desc;
                this.stable = stable;
            }
        }
        LinkedList<Entry> fields = new LinkedList<Entry>();
        try {
            String[] keys;
            JSONObject json = req.getSubmittedForm();
            for (String key : keys = new String[]{"versionID", "description", "stable"}) {
                if (json.has(key)) continue;
                log.warning("Got submission of broken version config form.");
                return;
            }
            try {
                JSONArray vArr = json.getJSONArray("versionID");
                JSONArray dArr = json.getJSONArray("description");
                JSONArray sArr = json.getJSONArray("stable");
                if (vArr.size() != dArr.size() || vArr.size() != sArr.size()) {
                    log.warning("Field in version config form differ in length.");
                    return;
                }
                for (int i = 0; i < vArr.size(); ++i) {
                    try {
                        fields.add(new Entry(Long.valueOf(vArr.getString(i), 10), dArr.getString(i), sArr.getBoolean(i)));
                        continue;
                    }
                    catch (JSONException ex) {
                        log.warning("Invalid value in version config at index " + i);
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        log.warning("Invalid id in version config at index " + i);
                    }
                }
            }
            catch (JSONException ex) {
                try {
                    Long jv = Long.valueOf(json.getString("versionID"), 10);
                    String jd = json.getString("description");
                    Boolean js = json.getBoolean("stable");
                    fields.add(new Entry(jv, jd, js));
                }
                catch (JSONException ex2) {
                    log.warning("Invalid value in version config!");
                    return;
                }
                catch (NumberFormatException ex2) {
                    log.warning("Invalid id in version config!");
                    return;
                }
            }
            for (Entry e : fields) {
                VersionedObjectStore.Version v = this.versionStore.getVersion(e.id);
                if (v == null) {
                    log.warning("No such version " + e.id + " for " + this.getFullName());
                    continue;
                }
                v.setStability(e.stable);
                v.setDescription(e.desc);
            }
            this.versionStore.save(this.getVersionFile());
            for (VersionChangeListener vcl : VersionChangeListener.all()) {
                vcl.onUpdated((Item)this);
            }
            InheritanceProject.clearBuffers(this);
            ItemListener.fireOnUpdated((Item)this);
            FormApply.success((String)".").generateResponse(req, rsp, null);
        }
        catch (JSONException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("Failed to parse form data. Please report this problem as a bug!");
            pw.println("JSON=" + req.getSubmittedForm());
            pw.println();
            e.printStackTrace(pw);
            rsp.setStatus(400);
            this.sendError(sw.toString(), req, rsp, true);
        }
    }

    protected VersionedObjectStore loadVersionedObjectStore() {
        File vFile = this.getVersionFile();
        if (vFile == null || !vFile.isFile()) {
            return new VersionedObjectStore();
        }
        VersionedObjectStore vos = null;
        try {
            vos = VersionedObjectStore.load(vFile);
        }
        catch (IOException ex) {
            log.warning("No versions loaded for " + this.getFullName() + ". " + ex.getLocalizedMessage());
            return new VersionedObjectStore();
        }
        catch (IllegalArgumentException ex) {
            log.warning("No versions loaded for " + this.getFullName() + ". " + ex.getLocalizedMessage());
            return new VersionedObjectStore();
        }
        catch (XStreamException ex) {
            log.warning("Could not load Version for: " + this.getFullName() + ". " + ex.getLocalizedMessage());
            return new VersionedObjectStore();
        }
        boolean wasModified = InheritanceProject.updateVersionedObjectStore(vos);
        if (wasModified) {
            try {
                vos.save(vFile);
            }
            catch (IOException ex) {
                log.severe(String.format("Failed to save version to: %s; Reason = %s", this.getVersionFile(), ex.getMessage()));
            }
        }
        try (BulkChange bc = new BulkChange((Saveable)this);){
            for (HashMap<String, Object> m : vos.getAllValueMaps()) {
                Object obj = m.get("properties");
                if (obj == null || !(obj instanceof List)) continue;
                List lst = (List)obj;
                for (JobProperty prop : lst) {
                    this.addProperty(prop);
                    this.removeProperty(prop);
                }
            }
            bc.commit();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return vos;
    }

    private static boolean updateVersionedObjectStore(VersionedObjectStore vos) {
        if (vos == null) {
            return false;
        }
        boolean wasModified = false;
        for (HashMap<String, Object> vm : vos.getAllValueMaps()) {
            LinkedList<BuildDiscarderProperty> pLst;
            if (!vm.containsKey("logRotator")) continue;
            Object logRotator = vm.get("logRotator");
            if (!(logRotator instanceof BuildDiscarder)) {
                vm.remove("logRotator");
                wasModified = true;
                continue;
            }
            Object pObj = vm.get("properties");
            if (!(pObj instanceof List)) {
                pLst = new LinkedList<BuildDiscarderProperty>();
                pLst.add(new BuildDiscarderProperty((BuildDiscarder)logRotator));
            } else {
                pLst = (LinkedList<BuildDiscarderProperty>)pObj;
                boolean hasDiscarder = false;
                for (JobProperty jobProperty : pLst) {
                    if (!(jobProperty instanceof BuildDiscarderProperty)) continue;
                    hasDiscarder = true;
                    break;
                }
                if (!hasDiscarder) {
                    pLst.add(new BuildDiscarderProperty((BuildDiscarder)logRotator));
                }
            }
            vm.remove("logRotator");
            wasModified = true;
        }
        return wasModified;
    }

    public synchronized void dumpConfigToNewVersion() {
        this.dumpConfigToNewVersion(null);
    }

    public synchronized void dumpConfigToNewVersion(String message) {
        if (this.isTransient) {
            return;
        }
        if (this.versionStore == null) {
            this.versionStore = this.loadVersionedObjectStore();
        }
        VersionedObjectStore.Version v = this.versionStore.createNextVersionAsEmpty();
        String username = Jenkins.getAuthentication().getName();
        if (username != null && !username.isEmpty()) {
            v.setUsername(username);
        }
        if (message != null) {
            v.setDescription(message);
        }
        this.dumpConfigToVersion(v);
        VersionedObjectStore.Version prev = this.versionStore.getVersion(v.id - 1L);
        if (prev != null && this.versionStore.areIdentical(prev, v)) {
            this.versionStore.undoVersion(v);
        }
        try {
            this.versionStore.save(this.getVersionFile());
        }
        catch (IOException ex) {
            log.severe(String.format("Failed to save version to: %s; Reason = %s", this.getVersionFile(), ex.getMessage()));
        }
    }

    protected void dumpConfigToVersion(VersionedObjectStore.Version v) {
        this.versionStore.setObjectFor(v, "parentReferences", new LinkedList<AbstractProjectReference>(this.getRawParentReferences()));
        this.versionStore.setObjectFor(v, "compatibleProjects", new LinkedList<AbstractProjectReference>(this.compatibleProjects));
        this.versionStore.setObjectFor(v, "properties", new LinkedList(super.getAllProperties()));
        this.versionStore.setObjectFor(v, "buildWrappersList", new DescribableList(NOOP, (Collection)super.getBuildWrappersList().toList()));
        this.versionStore.setObjectFor(v, "buildersList", new DescribableList(NOOP, (Collection)super.getBuildersList().toList()));
        this.versionStore.setObjectFor(v, "publishersList", new DescribableList(NOOP, (Collection)super.getPublishersList().toList()));
        this.versionStore.setObjectFor(v, "actions", new LinkedList(super.getActions()));
        this.versionStore.setObjectFor(v, "scm", super.getScm());
        this.versionStore.setObjectFor(v, "quietPeriod", this.getRawQuietPeriod());
        this.versionStore.setObjectFor(v, "scmCheckoutRetryCount", this.getRawScmCheckoutRetryCount());
        this.versionStore.setObjectFor(v, "scmCheckoutStrategy", super.getScmCheckoutStrategy());
        this.versionStore.setObjectFor(v, "blockBuildWhenDownstreamBuilding", super.blockBuildWhenDownstreamBuilding());
        this.versionStore.setObjectFor(v, "blockBuildWhenUpstreamBuilding", super.blockBuildWhenUpstreamBuilding());
        this.versionStore.setObjectFor(v, "customWorkspace", super.getCustomWorkspace());
        this.versionStore.setObjectFor(v, "parameterizedWorkspace", this.getRawParameterizedWorkspace());
    }

    public static InheritanceProject getProjectFromRequest(StaplerRequest req) {
        return (InheritanceProject)req.findAncestorObject(InheritanceProject.class);
    }

    public String getUserDesiredVersion() {
        Long v = VersionHandler.getVersion(this);
        if (v == null) {
            return "";
        }
        return v.toString();
    }

    public Deque<Long> getVersionIDs() {
        Object obj = onSelfChangeBuffer.get(this, "getVersionIDs()");
        if (obj != null && obj instanceof Deque) {
            return (Deque)obj;
        }
        LinkedList<Long> lst = new LinkedList<Long>();
        for (VersionedObjectStore.Version v : this.getVersions()) {
            lst.add(v.id);
        }
        onSelfChangeBuffer.set(this, "getVersionIDs()", lst);
        return lst;
    }

    public Deque<VersionedObjectStore.Version> getVersions() {
        Object obj = onSelfChangeBuffer.get(this, "getVersions()");
        if (obj != null && obj instanceof Deque) {
            return (Deque)obj;
        }
        LinkedList<VersionedObjectStore.Version> lst = new LinkedList<VersionedObjectStore.Version>();
        if (this.versionStore == null) {
            return lst;
        }
        lst.addAll(this.versionStore.getAllVersions());
        onSelfChangeBuffer.set(this, "getVersions()", lst);
        return lst;
    }

    public Deque<VersionedObjectStore.Version> getStableVersions() {
        Object obj = onSelfChangeBuffer.get(this, "getStableVersions()");
        if (obj != null && obj instanceof Deque) {
            return (Deque)obj;
        }
        LinkedList<VersionedObjectStore.Version> lst = new LinkedList<VersionedObjectStore.Version>();
        if (this.versionStore == null) {
            return lst;
        }
        for (VersionedObjectStore.Version version : this.versionStore.getAllVersions()) {
            if (!version.getStability()) continue;
            lst.add(version);
        }
        onSelfChangeBuffer.set(this, "getStableVersions()", lst);
        return lst;
    }

    public VersionedObjectStore getVersionedObjectStore() {
        return this.versionStore;
    }

    public void saveVersionedObjectStore() throws IOException {
        this.versionStore.save(this.getVersionFile());
    }

    public Long getStableVersion() {
        if (this.versionStore == null) {
            return null;
        }
        VersionedObjectStore.Version v = this.versionStore.getLatestStable();
        return v == null ? null : v.id;
    }

    public Long getLatestVersion() {
        if (this.versionStore == null) {
            return null;
        }
        VersionedObjectStore.Version v = this.versionStore.getLatestVersion();
        return v == null ? null : v.id;
    }

    public boolean setVersionStability(long version, boolean stable) {
        VersionedObjectStore.Version v = this.versionStore.getVersion(version);
        if (v == null) {
            return false;
        }
        v.setStability(stable);
        try {
            this.versionStore.save(this.getVersionFile());
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public List<InheritedVersionInfo> getAllInheritedVersionsList() {
        return this.getAllInheritedVersionsList(null);
    }

    public List<InheritedVersionInfo> getAllInheritedVersionsList(InheritanceBuild build) {
        return InheritanceProject.getAllInheritedVersionsList(this, build);
    }

    public static List<InheritedVersionInfo> getAllInheritedVersionsList(InheritanceProject root, InheritanceBuild build) {
        LinkedList<InheritedVersionInfo> out = new LinkedList<InheritedVersionInfo>();
        HashMap<String, Long> predefs = new HashMap<String, Long>();
        if (build != null) {
            predefs.putAll(build.getProjectVersions());
        }
        predefs.putAll(VersionHandler.getVersions());
        HashSet<String> seen = new HashSet<String>();
        LinkedList<InheritanceProject> open = new LinkedList<InheritanceProject>();
        open.add(root);
        while (!open.isEmpty()) {
            AbstractProject ap = (AbstractProject)open.pop();
            if (seen.contains(ap.getFullName())) continue;
            seen.add(ap.getFullName());
            if (ap instanceof InheritanceProject) {
                InheritanceProject ip = (InheritanceProject)ap;
                InheritedVersionInfo ivf = InheritedVersionInfo.getVersionFrom(ip, predefs);
                if (ivf != null && ivf.version != null) {
                    out.add(ivf);
                }
                for (AbstractProjectReference ref : ip.getParentReferences()) {
                    InheritanceProject par = ref.getProject();
                    if (par == null) continue;
                    open.add(par);
                }
            }
            for (String ref : InheritanceProject.getReferencers(ap)) {
                AbstractProject it = (AbstractProject)Jenkins.get().getItemByFullName(ref, AbstractProject.class);
                if (it == null) continue;
                open.push((InheritanceProject)it);
            }
        }
        return out;
    }

    private static Set<String> getReferencers(AbstractProject<?, ?> ap) {
        if (ap == null) {
            return Collections.emptySet();
        }
        LinkedList<Referencer> refs = new LinkedList<Referencer>();
        if (ap instanceof InheritanceProject) {
            InheritanceProject ip = (InheritanceProject)ap;
            for (BuildWrapper w : ip.getRawBuildWrappersList()) {
                if (!(w instanceof Referencer)) continue;
                refs.add((Referencer)w);
            }
            for (BuildWrapper w : ip.getRawBuildersList()) {
                if (!(w instanceof Referencer)) continue;
                refs.add((Referencer)w);
            }
            for (BuildWrapper w : ip.getRawPublishersList()) {
                if (!(w instanceof Referencer)) continue;
                refs.add((Referencer)w);
            }
        } else if (ap instanceof AbstractProject) {
            Project p = (Project)ap;
            for (BuildWrapper w : p.getBuildWrappersList()) {
                if (!(w instanceof Referencer)) continue;
                refs.add((Referencer)w);
            }
            for (BuildWrapper w : p.getBuildersList()) {
                if (!(w instanceof Referencer)) continue;
                refs.add((Referencer)w);
            }
            for (BuildWrapper w : p.getPublishersList()) {
                if (!(w instanceof Referencer)) continue;
                refs.add((Referencer)w);
            }
        }
        if (refs.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> out = new HashSet<String>();
        for (Referencer r : refs) {
            for (String ref : r.getReferencedJobs()) {
                out.add(ref);
            }
        }
        return out;
    }

    public List<InheritanceProject> getChildrenProjects() {
        Object obj = onChangeBuffer.get(this, "getChildrenProjects");
        if (obj != null && obj instanceof LinkedList) {
            return (LinkedList)obj;
        }
        LinkedList<InheritanceProject> lst = new LinkedList<InheritanceProject>();
        Map<String, InheritanceProject> map = InheritanceProject.getProjectsMap();
        for (InheritanceProject p : map.values()) {
            for (AbstractProjectReference ref : p.getParentReferences()) {
                if (!this.name.equals(ref.getName())) continue;
                lst.add(p);
            }
        }
        onChangeBuffer.set(this, "getChildrenProjects", lst);
        return lst;
    }

    public List<InheritanceProject> getParentProjects() {
        LinkedList<InheritanceProject> lst = new LinkedList<InheritanceProject>();
        for (AbstractProjectReference ref : this.getParentReferences()) {
            InheritanceProject ip;
            if (ref == null || (ip = ref.getProject()) == null) continue;
            lst.add(ip);
        }
        return lst;
    }

    private <T extends Trigger> T getReparentedTrigger(T trigger) {
        try {
            String xml = Jenkins.XSTREAM2.toXML(trigger);
            if (xml == null) {
                return trigger;
            }
            Object copy = Jenkins.XSTREAM2.fromXML(xml);
            if (copy == null || !(copy instanceof Trigger)) {
                return trigger;
            }
            trigger = (Trigger)copy;
            trigger.start((Item)this, false);
            return trigger;
        }
        catch (XStreamException ex) {
            return trigger;
        }
    }

    public void setScm(SCM scm) throws IOException {
        super.setScm(scm);
    }

    private InheritanceGovernor<List<AbstractProjectReference>> getParentReferencesGovernor(ProjectReference.PrioComparator.SELECTOR sortKey) {
        return new InheritanceGovernor<List<AbstractProjectReference>>("parentReferences", sortKey, this){

            @Override
            protected List<AbstractProjectReference> castToDestinationType(Object o) {
                return 1.castToList(o);
            }

            @Override
            public List<AbstractProjectReference> getRawField(InheritanceProject ip) {
                return ip.getRawParentReferences();
            }

            @Override
            protected List<AbstractProjectReference> reduceFromFullInheritance(Deque<List<AbstractProjectReference>> list) {
                return InheritanceGovernor.reduceByMergeWithDuplicates(list, AbstractProjectReference.class, this.caller);
            }
        };
    }

    public List<AbstractProjectReference> getParentReferences() {
        return this.getParentReferences(ProjectReference.PrioComparator.SELECTOR.MISC);
    }

    static <T> List<T> nonNull(List<T> v) {
        if (v == null) {
            return Collections.emptyList();
        }
        return v;
    }

    public List<AbstractProjectReference> getParentReferences(ProjectReference.PrioComparator.SELECTOR sortKey) {
        InheritanceGovernor<List<AbstractProjectReference>> gov = this.getParentReferencesGovernor(sortKey);
        return InheritanceProject.nonNull(gov.retrieveFullyDerivedField(this, IMode.LOCAL_ONLY));
    }

    public List<AbstractProjectReference> getRawParentReferences() {
        return this.parentReferences;
    }

    public List<AbstractProjectReference> getAllParentReferences(ProjectReference.PrioComparator.SELECTOR sortKey) {
        InheritanceGovernor<List<AbstractProjectReference>> gov = this.getParentReferencesGovernor(sortKey);
        return gov.retrieveFullyDerivedField(this, IMode.INHERIT_FORCED);
    }

    public List<AbstractProjectReference> getAllParentReferences(ProjectReference.PrioComparator.SELECTOR sortKey, boolean addSelf) {
        List<AbstractProjectReference> lst = this.getAllParentReferences(sortKey);
        if (addSelf) {
            boolean hasAddedSelf = false;
            ListIterator<AbstractProjectReference> iter = lst.listIterator();
            while (iter.hasNext()) {
                AbstractProjectReference ref = iter.next();
                int prio = ref instanceof ProjectReference ? ProjectReference.PrioComparator.getPriorityFor(ref, sortKey) : 0;
                if (hasAddedSelf || prio <= 0) continue;
                hasAddedSelf = true;
                iter.set(new SimpleProjectReference(this.getFullName()));
                iter.add(ref);
                break;
            }
            if (!hasAddedSelf) {
                lst.add(new SimpleProjectReference(this.getFullName()));
            }
        }
        return lst;
    }

    public List<AbstractProjectReference> getCompatibleProjects() {
        return this.getCompatibleProjects(ProjectReference.PrioComparator.SELECTOR.MISC);
    }

    public List<AbstractProjectReference> getCompatibleProjects(ProjectReference.PrioComparator.SELECTOR sortKey) {
        InheritanceGovernor<List<AbstractProjectReference>> gov = new InheritanceGovernor<List<AbstractProjectReference>>("compatibleProjects", sortKey, this){

            @Override
            protected List<AbstractProjectReference> castToDestinationType(Object o) {
                return 2.castToList(o);
            }

            @Override
            public List<AbstractProjectReference> getRawField(InheritanceProject ip) {
                return ip.getRawCompatibleProjects();
            }
        };
        List refs = (List)gov.retrieveFullyDerivedField(this, IMode.LOCAL_ONLY);
        if (refs == null) {
            return new LinkedList<AbstractProjectReference>();
        }
        return refs;
    }

    public List<AbstractProjectReference> getRawCompatibleProjects() {
        return this.compatibleProjects;
    }

    public List<Action> getActions() {
        return this.getActions(IMode.AUTO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Action> getActions(IMode mode) {
        List<Object> transients;
        InheritanceGovernor<List<Action>> gov = new InheritanceGovernor<List<Action>>("actions", ProjectReference.PrioComparator.SELECTOR.MISC, this){

            @Override
            protected List<Action> castToDestinationType(Object o) {
                return 3.castToList(o);
            }

            @Override
            public List<Action> getRawField(InheritanceProject ip) {
                return ip.getRawActions();
            }

            @Override
            protected List<Action> reduceFromFullInheritance(Deque<List<Action>> list) {
                return InheritanceGovernor.reduceByMerge(list, Action.class, this.caller);
            }
        };
        List nonTransients = (List)gov.retrieveFullyDerivedField(this, IMode.LOCAL_ONLY);
        ThreadAssocStore tas = ThreadAssocStore.getInstance();
        String key = String.format("project-%s-creates-transients", this.getFullName());
        Object o = tas.getValue(key);
        if (o == null) {
            try {
                tas.setValue(key, this);
                transients = this.createVersionAwareTransientActions();
            }
            finally {
                tas.clear(key);
            }
        } else {
            transients = Collections.emptyList();
        }
        LinkedList merge = new LinkedList();
        merge.addAll(nonTransients);
        merge.addAll(transients);
        return Collections.unmodifiableList(merge);
    }

    public List<Action> getRawActions() {
        return super.getActions();
    }

    protected final List<Action> createTransientActions() {
        return Collections.emptyList();
    }

    protected List<Action> createVersionAwareTransientActions() {
        Vector<Action> ta = new Vector<Action>();
        for (JobProperty<? super InheritanceProject> p : this.getAllProperties()) {
            ta.addAll(p.getJobActions((Job)this));
        }
        for (TransientProjectActionFactory tpaf : TransientProjectActionFactory.all()) {
            try {
                ta.addAll(Util.fixNull((Collection)tpaf.createFor((AbstractProject)this)));
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "Could not load actions from " + tpaf + " for " + this, e);
            }
        }
        for (BuildStep step : this.getBuildersList()) {
            try {
                ta.addAll(step.getProjectActions((AbstractProject)this));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error loading build step.", e);
            }
        }
        for (BuildStep step : this.getPublishersList()) {
            try {
                ta.addAll(step.getProjectActions((AbstractProject)this));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error loading publisher.", e);
            }
        }
        for (BuildStep step : this.getBuildWrappersList()) {
            try {
                ta.addAll(step.getProjectActions((AbstractProject)this));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error loading build wrapper.", e);
            }
        }
        for (Trigger<?> trigger : this.getTriggers().values()) {
            try {
                ta.addAll(trigger.getProjectActions());
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error loading trigger.", e);
            }
        }
        return ta;
    }

    public DescribableList<Builder, Descriptor<Builder>> getBuildersListForVersion(Long versionId) {
        return (DescribableList)this.versionStore.getObject(versionId, "buildersList");
    }

    public DescribableList<Builder, Descriptor<Builder>> getBuildersList() {
        return this.getBuildersList(IMode.AUTO);
    }

    public DescribableList<Builder, Descriptor<Builder>> getBuildersList(IMode mode) {
        InheritanceGovernor<DescribableList<Builder, Descriptor<Builder>>> gov = new InheritanceGovernor<DescribableList<Builder, Descriptor<Builder>>>("buildersList", ProjectReference.PrioComparator.SELECTOR.BUILDER, this){

            @Override
            protected DescribableList<Builder, Descriptor<Builder>> castToDestinationType(Object o) {
                return 4.castToDescribableList(o);
            }

            @Override
            public DescribableList<Builder, Descriptor<Builder>> getRawField(InheritanceProject ip) {
                return ip.getRawBuildersList();
            }

            @Override
            protected DescribableList<Builder, Descriptor<Builder>> reduceFromFullInheritance(Deque<DescribableList<Builder, Descriptor<Builder>>> list) {
                return InheritanceGovernor.reduceDescribableByMerge(list);
            }
        };
        return (DescribableList)gov.retrieveFullyDerivedField(this, mode);
    }

    public DescribableList<Builder, Descriptor<Builder>> getRawBuildersList() {
        return super.getBuildersList();
    }

    public DescribableList<BuildWrapper, Descriptor<BuildWrapper>> getBuildWrappersList() {
        return this.getBuildWrappersList(IMode.AUTO);
    }

    public DescribableList<BuildWrapper, Descriptor<BuildWrapper>> getBuildWrappersList(IMode mode) {
        InheritanceGovernor<DescribableList<BuildWrapper, Descriptor<BuildWrapper>>> gov = new InheritanceGovernor<DescribableList<BuildWrapper, Descriptor<BuildWrapper>>>("buildWrappersList", ProjectReference.PrioComparator.SELECTOR.BUILD_WRAPPER, this){

            @Override
            protected DescribableList<BuildWrapper, Descriptor<BuildWrapper>> castToDestinationType(Object o) {
                return 5.castToDescribableList(o);
            }

            @Override
            public DescribableList<BuildWrapper, Descriptor<BuildWrapper>> getRawField(InheritanceProject ip) {
                return ip.getRawBuildWrappersList();
            }

            @Override
            protected DescribableList<BuildWrapper, Descriptor<BuildWrapper>> reduceFromFullInheritance(Deque<DescribableList<BuildWrapper, Descriptor<BuildWrapper>>> list) {
                return InheritanceGovernor.reduceDescribableByMergeWithoutDuplicates(list);
            }
        };
        return (DescribableList)gov.retrieveFullyDerivedField(this, mode);
    }

    public DescribableList<BuildWrapper, Descriptor<BuildWrapper>> getRawBuildWrappersList() {
        return super.getBuildWrappersList();
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getPublishersList() {
        return this.getPublishersList(IMode.AUTO);
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getPublishersList(IMode mode) {
        InheritanceGovernor<DescribableList<Publisher, Descriptor<Publisher>>> gov = new InheritanceGovernor<DescribableList<Publisher, Descriptor<Publisher>>>("publishersList", ProjectReference.PrioComparator.SELECTOR.PUBLISHER, this){

            @Override
            protected DescribableList<Publisher, Descriptor<Publisher>> castToDestinationType(Object o) {
                return 6.castToDescribableList(o);
            }

            @Override
            public DescribableList<Publisher, Descriptor<Publisher>> getRawField(InheritanceProject ip) {
                return ip.getRawPublishersList();
            }

            @Override
            protected DescribableList<Publisher, Descriptor<Publisher>> reduceFromFullInheritance(Deque<DescribableList<Publisher, Descriptor<Publisher>>> list) {
                return InheritanceGovernor.reduceDescribableByMerge(list);
            }
        };
        return (DescribableList)gov.retrieveFullyDerivedField(this, mode);
    }

    public DescribableList<Publisher, Descriptor<Publisher>> getRawPublishersList() {
        return super.getPublishersList();
    }

    public Map<TriggerDescriptor, Trigger<?>> getTriggers() {
        return this.getTriggers(IMode.AUTO);
    }

    public Map<TriggerDescriptor, Trigger<?>> getTriggers(IMode mode) {
        InheritanceGovernor gov = new InheritanceGovernor<Collection<Trigger<?>>>("triggers", ProjectReference.PrioComparator.SELECTOR.MISC, this){

            @Override
            protected Collection<Trigger<?>> castToDestinationType(Object o) {
                try {
                    return (Collection)o;
                }
                catch (ClassCastException e) {
                    return null;
                }
            }

            @Override
            public Collection<Trigger<?>> getRawField(InheritanceProject ip) {
                Map<TriggerDescriptor, Trigger<?>> raw = ip.getRawTriggers();
                return raw.values();
            }

            @Override
            protected Collection<Trigger<?>> reduceFromFullInheritance(Deque<Collection<Trigger<?>>> list) {
                LinkedList out = new LinkedList();
                for (Collection<Trigger<?>> sub : list) {
                    out.addAll(sub);
                }
                return out;
            }
        };
        Collection triggers = (Collection)gov.retrieveFullyDerivedField(this, mode);
        HashMap out = new HashMap();
        for (Trigger t : triggers) {
            Trigger copied = this.getReparentedTrigger(t);
            out.put(copied.getDescriptor(), copied);
        }
        return out;
    }

    public Map<TriggerDescriptor, Trigger<?>> getRawTriggers() {
        return super.getTriggers();
    }

    public <T extends Trigger> T getTrigger(Class<T> clazz) {
        return this.getTrigger(clazz, IMode.AUTO);
    }

    public <T extends Trigger> T getTrigger(Class<T> clazz, IMode mode) {
        final Class<T> fClazz = clazz;
        InheritanceGovernor gov = new InheritanceGovernor<T>("triggers", ProjectReference.PrioComparator.SELECTOR.MISC, this){

            @Override
            protected T castToDestinationType(Object o) {
                try {
                    return (Trigger)o;
                }
                catch (ClassCastException e) {
                    return null;
                }
            }

            @Override
            public T getRawField(InheritanceProject ip) {
                return ip.getRawTrigger(fClazz);
            }
        };
        Trigger trigger = (Trigger)gov.retrieveFullyDerivedField(this, mode);
        return (T)this.getReparentedTrigger(trigger);
    }

    public <T extends Trigger> T getRawTrigger(Class<T> clazz) {
        return (T)super.getTrigger(clazz);
    }

    public Map<JobPropertyDescriptor, JobProperty<? super InheritanceProject>> getProperties() {
        return this.getProperties(IMode.AUTO);
    }

    public Map<JobPropertyDescriptor, JobProperty<? super InheritanceProject>> getProperties(IMode mode) {
        List<JobProperty<? super InheritanceProject>> lst = this.getAllProperties(mode);
        if (lst == null || lst.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<JobPropertyDescriptor, JobProperty<? super InheritanceProject>> map = new HashMap<JobPropertyDescriptor, JobProperty<? super InheritanceProject>>();
        for (JobProperty<? super InheritanceProject> prop : lst) {
            map.put(prop.getDescriptor(), prop);
        }
        return map;
    }

    @Exported(name="property", inline=true)
    public List<JobProperty<? super InheritanceProject>> getAllProperties() {
        return this.getAllProperties(IMode.AUTO);
    }

    public List<JobProperty<? super InheritanceProject>> getAllProperties(IMode mode) {
        final InheritanceProject rootProject = this;
        InheritanceGovernor<List<JobProperty<? super InheritanceProject>>> gov = new InheritanceGovernor<List<JobProperty<? super InheritanceProject>>>("properties", ProjectReference.PrioComparator.SELECTOR.PARAMETER, this){

            @Override
            protected List<JobProperty<? super InheritanceProject>> castToDestinationType(Object o) {
                return 9.castToList(o);
            }

            @Override
            public List<JobProperty<? super InheritanceProject>> getRawField(InheritanceProject ip) {
                return ip.getRawAllProperties();
            }

            @Override
            protected List<JobProperty<? super InheritanceProject>> reduceFromFullInheritance(Deque<List<JobProperty<? super InheritanceProject>>> list) {
                ParametersDefinitionProperty variance = rootProject.getVarianceParameters();
                if (variance != null) {
                    LinkedList<ParametersDefinitionProperty> varLst = new LinkedList<ParametersDefinitionProperty>();
                    varLst.add(variance);
                    list.addLast(varLst);
                }
                return InheritanceGovernor.reduceByMerge(list, JobProperty.class, this.caller);
            }
        };
        return (List)gov.retrieveFullyDerivedField(this, mode);
    }

    public List<JobProperty<? super InheritanceProject>> getRawAllProperties() {
        return super.getAllProperties();
    }

    public ParametersDefinitionProperty getVarianceParameters() {
        if (!this.isTransient) {
            return null;
        }
        List<InheritanceProject> parLst = this.getParentProjects();
        if (parLst == null || parLst.size() < 2) {
            return null;
        }
        for (InheritanceProject ip : parLst) {
            List<AbstractProjectReference> compatLst;
            if (ip == null || !this.name.startsWith(ip.name) || (compatLst = ip.getCompatibleProjects()) == null) continue;
            for (AbstractProjectReference apr : compatLst) {
                String compatName;
                if (!(apr instanceof ParameterizedProjectReference)) continue;
                ParameterizedProjectReference ppr = (ParameterizedProjectReference)apr;
                String projVar = ppr.getVariance();
                if ((this.variance == null ? projVar != null : projVar == null || !this.variance.equals(ppr.getVariance())) || !this.name.equals(compatName = ProjectCreationEngine.generateNameFor(ppr.getVariance(), ip.name, ppr.getName()))) continue;
                return new ParametersDefinitionProperty(ppr.getParameters());
            }
        }
        return null;
    }

    public <T extends JobProperty> T getProperty(Class<T> clazz) {
        return this.getProperty(clazz, IMode.AUTO);
    }

    public <T extends JobProperty> T getProperty(Class<T> clazz, IMode mode) {
        List<JobProperty<? super InheritanceProject>> props = this.getAllProperties(mode);
        if (props instanceof Deque) {
            Iterator rIter = ((Deque)((Object)props)).descendingIterator();
            while (rIter.hasNext()) {
                JobProperty p = (JobProperty)rIter.next();
                if (!clazz.isInstance(p)) continue;
                return (T)((JobProperty)clazz.cast(p));
            }
        } else {
            for (JobProperty<? super InheritanceProject> p : props) {
                if (!clazz.isInstance(p)) continue;
                return (T)((JobProperty)clazz.cast(p));
            }
        }
        return null;
    }

    public JobProperty getProperty(String className) {
        return this.getProperty(className, IMode.AUTO);
    }

    public JobProperty getProperty(String className, IMode mode) {
        for (JobProperty<? super InheritanceProject> p : this.getAllProperties(mode)) {
            if (!p.getClass().getName().equals(className)) continue;
            return p;
        }
        return null;
    }

    public Collection<?> getOverrides() {
        return this.getOverrides(IMode.AUTO);
    }

    public Collection<?> getOverrides(IMode mode) {
        ArrayList r = new ArrayList();
        for (JobProperty<? super InheritanceProject> p : this.getAllProperties(mode)) {
            r.addAll(p.getJobOverrides());
        }
        return r;
    }

    public List<SubTask> getSubTasks() {
        ArrayList<SubTask> r = new ArrayList<SubTask>();
        r.add((SubTask)this);
        for (SubTaskContributor euc : SubTaskContributor.all()) {
            r.addAll(euc.forProject((AbstractProject)this));
        }
        for (JobProperty<? super InheritanceProject> p : this.getAllProperties()) {
            r.addAll(p.getSubTasks());
        }
        return r;
    }

    public List<ParameterDefinition> getParameters() {
        return this.getParameters(IMode.AUTO);
    }

    public List<ParameterDefinition> getParameters(IMode mode) {
        ParametersDefinitionProperty pdp = this.getProperty(ParametersDefinitionProperty.class, mode);
        if (pdp == null) {
            return new LinkedList<ParameterDefinition>();
        }
        return pdp.getParameterDefinitions();
    }

    public SCM getScm() {
        return this.getScm(IMode.AUTO);
    }

    public SCM getScm(IMode mode) {
        InheritanceGovernor<SCM> gov = new InheritanceGovernor<SCM>("scm", ProjectReference.PrioComparator.SELECTOR.MISC, this){

            @Override
            protected SCM castToDestinationType(Object o) {
                return o instanceof SCM ? (SCM)o : null;
            }

            @Override
            public SCM getRawField(InheritanceProject ip) {
                return ip.getRawScm();
            }

            @Override
            protected SCM reduceFromFullInheritance(Deque<SCM> list) {
                if (list == null || list.isEmpty()) {
                    return new NullSCM();
                }
                Iterator<SCM> iter = list.descendingIterator();
                while (iter.hasNext()) {
                    SCM scm = iter.next();
                    if (scm == null || scm instanceof NullSCM) continue;
                    return scm;
                }
                return list.peekLast();
            }
        };
        SCM scm = (SCM)gov.retrieveFullyDerivedField(this, mode);
        return scm == null ? new NullSCM() : scm;
    }

    public SCM getRawScm() {
        return super.getScm();
    }

    public int getQuietPeriod() {
        Integer i = this.getQuietPeriodObject();
        return i != null ? i.intValue() : super.getQuietPeriod();
    }

    public Integer getQuietPeriodObject() {
        InheritanceGovernor<Integer> gov = new InheritanceGovernor<Integer>("quietPeriod", ProjectReference.PrioComparator.SELECTOR.MISC, this){

            @Override
            protected Integer castToDestinationType(Object o) {
                return o instanceof Integer ? (Integer)o : null;
            }

            @Override
            public Integer getRawField(InheritanceProject ip) {
                return ip.getRawQuietPeriod();
            }
        };
        return (Integer)gov.retrieveFullyDerivedField(this, IMode.AUTO);
    }

    public Integer getRawQuietPeriod() {
        if (super.getHasCustomQuietPeriod()) {
            return super.getQuietPeriod();
        }
        return null;
    }

    public boolean getHasCustomQuietPeriod() {
        Integer i = this.getQuietPeriodObject();
        return i != null;
    }

    public int getScmCheckoutRetryCount() {
        Integer i = this.getScmCheckoutRetryCountObject();
        return i != null ? i.intValue() : super.getScmCheckoutRetryCount();
    }

    public Integer getScmCheckoutRetryCountObject() {
        InheritanceGovernor<Integer> gov = new InheritanceGovernor<Integer>("scmCheckoutRetryCount", ProjectReference.PrioComparator.SELECTOR.MISC, this){

            @Override
            protected Integer castToDestinationType(Object o) {
                return o instanceof Integer ? (Integer)o : null;
            }

            @Override
            public Integer getRawField(InheritanceProject ip) {
                return ip.getRawScmCheckoutRetryCount();
            }
        };
        return (Integer)gov.retrieveFullyDerivedField(this, IMode.AUTO);
    }

    public Integer getRawScmCheckoutRetryCount() {
        if (super.hasCustomScmCheckoutRetryCount()) {
            return super.getScmCheckoutRetryCount();
        }
        return null;
    }

    public boolean hasCustomScmCheckoutRetryCount() {
        return this.getScmCheckoutRetryCountObject() != null;
    }

    public SCMCheckoutStrategy getScmCheckoutStrategy() {
        return this.getScmCheckoutStrategy(IMode.AUTO);
    }

    public SCMCheckoutStrategy getScmCheckoutStrategy(IMode mode) {
        InheritanceGovernor<SCMCheckoutStrategy> gov = new InheritanceGovernor<SCMCheckoutStrategy>("scmCheckoutStrategy", ProjectReference.PrioComparator.SELECTOR.MISC, this){

            @Override
            protected SCMCheckoutStrategy castToDestinationType(Object o) {
                return o instanceof SCMCheckoutStrategy ? (SCMCheckoutStrategy)o : null;
            }

            @Override
            public SCMCheckoutStrategy getRawField(InheritanceProject ip) {
                return ip.getRawScmCheckoutStrategy();
            }
        };
        return (SCMCheckoutStrategy)gov.retrieveFullyDerivedField(this, mode);
    }

    public SCMCheckoutStrategy getRawScmCheckoutStrategy() {
        return super.getScmCheckoutStrategy();
    }

    public boolean blockBuildWhenDownstreamBuilding() {
        return this.blockBuildWhenDownstreamBuilding(IMode.AUTO);
    }

    public boolean blockBuildWhenDownstreamBuilding(IMode mode) {
        InheritanceGovernor<Boolean> gov = new InheritanceGovernor<Boolean>("blockBuildWhenDownstreamBuilding", ProjectReference.PrioComparator.SELECTOR.MISC, this){

            @Override
            protected Boolean castToDestinationType(Object o) {
                return o instanceof Boolean ? (Boolean)o : null;
            }

            @Override
            public Boolean getRawField(InheritanceProject ip) {
                return ip.getRawBlockBuildWhenDownstreamBuilding();
            }
        };
        return (Boolean)gov.retrieveFullyDerivedField(this, mode);
    }

    public boolean getRawBlockBuildWhenDownstreamBuilding() {
        return super.blockBuildWhenDownstreamBuilding();
    }

    public boolean blockBuildWhenUpstreamBuilding() {
        return this.blockBuildWhenUpstreamBuilding(IMode.AUTO);
    }

    public boolean blockBuildWhenUpstreamBuilding(IMode mode) {
        InheritanceGovernor<Boolean> gov = new InheritanceGovernor<Boolean>("blockBuildWhenUpstreamBuilding", ProjectReference.PrioComparator.SELECTOR.MISC, this){

            @Override
            protected Boolean castToDestinationType(Object o) {
                return o instanceof Boolean ? (Boolean)o : null;
            }

            @Override
            public Boolean getRawField(InheritanceProject ip) {
                return ip.getRawBlockBuildWhenUpstreamBuilding();
            }
        };
        return (Boolean)gov.retrieveFullyDerivedField(this, mode);
    }

    public boolean getRawBlockBuildWhenUpstreamBuilding() {
        return super.blockBuildWhenUpstreamBuilding();
    }

    public String getCustomWorkspace() {
        return this.getCustomWorkspace(IMode.AUTO);
    }

    public String getCustomWorkspace(IMode mode) {
        InheritanceGovernor<String> gov = new InheritanceGovernor<String>("customWorkspace", ProjectReference.PrioComparator.SELECTOR.MISC, this){

            @Override
            protected String castToDestinationType(Object o) {
                return o instanceof String ? (String)o : null;
            }

            @Override
            public String getRawField(InheritanceProject ip) {
                return ip.getRawCustomWorkspace();
            }
        };
        return (String)gov.retrieveFullyDerivedField(this, mode);
    }

    public String getRawCustomWorkspace() {
        return super.getCustomWorkspace();
    }

    public String getParameterizedWorkspace() {
        return this.getParameterizedWorkspace(IMode.AUTO);
    }

    public String getParameterizedWorkspace(IMode mode) {
        InheritanceGovernor<String> gov = new InheritanceGovernor<String>("parameterizedWorkspace", ProjectReference.PrioComparator.SELECTOR.MISC, this){

            @Override
            protected String castToDestinationType(Object o) {
                return o instanceof String ? (String)o : null;
            }

            @Override
            public String getRawField(InheritanceProject ip) {
                return ip.getRawParameterizedWorkspace();
            }
        };
        return (String)gov.retrieveFullyDerivedField(this, mode);
    }

    public String getRawParameterizedWorkspace() {
        return this.parameterizedWorkspace;
    }

    @Deprecated
    public void setRawParameterizedWorkspace(String workspace) {
        this.parameterizedWorkspace = workspace;
    }

    @Deprecated
    public LogRotator getLogRotator() {
        BuildDiscarder d = this.getBuildDiscarder();
        if (d instanceof LogRotator) {
            return (LogRotator)d;
        }
        return null;
    }

    @Deprecated
    public LogRotator getLogRotator(IMode mode) {
        BuildDiscarder d = this.getBuildDiscarder(mode);
        if (d instanceof LogRotator) {
            return (LogRotator)d;
        }
        return null;
    }

    public BuildDiscarder getBuildDiscarder() {
        return this.getBuildDiscarder(IMode.AUTO);
    }

    public BuildDiscarder getBuildDiscarder(IMode mode) {
        BuildDiscarderProperty bdProp = this.getProperty(BuildDiscarderProperty.class, mode);
        return bdProp != null ? bdProp.getStrategy() : null;
    }

    public Label getAssignedLabel() {
        Object cached = onChangeBuffer.get(this, "maintenanceAssignedLabel");
        if (cached != null && cached instanceof Label) {
            Label lbl = (Label)cached;
            return Jenkins.get().getLabel('\"' + lbl.getName() + '\"');
        }
        Label lbl = this.getAssignedLabel(IMode.INHERIT_FORCED);
        if (lbl == null) {
            lbl = super.getAssignedLabel();
        }
        if (lbl != null) {
            onChangeBuffer.set(this, "maintenanceAssignedLabel", lbl);
        }
        return lbl;
    }

    public Label getAssignedLabel(IMode mode) {
        InheritanceGovernor<Label> gov = new InheritanceGovernor<Label>("assignedLabel", ProjectReference.PrioComparator.SELECTOR.MISC, this){

            @Override
            protected Label castToDestinationType(Object o) {
                if (o instanceof Label) {
                    return (Label)o;
                }
                return null;
            }

            @Override
            public Label getRawField(InheritanceProject ip) {
                return ip.getRawAssignedLabel();
            }

            @Override
            protected Label reduceFromFullInheritance(Deque<Label> list) {
                Label out = null;
                if (list == null || list.isEmpty()) {
                    return out;
                }
                for (Label l : list) {
                    if (l == null) continue;
                    out = out == null ? l : out.and(l);
                }
                return out;
            }
        };
        Label lbl = (Label)gov.retrieveFullyDerivedField(this, mode);
        if (lbl == null) {
            return null;
        }
        return Jenkins.get().getLabel('\"' + lbl.getName() + '\"');
    }

    public Label getRawAssignedLabel() {
        if (this.isTransient) {
            return null;
        }
        return super.getAssignedLabel();
    }

    public String getAssignedLabelString() {
        if (!InheritanceGovernor.inheritanceLookupRequired(this)) {
            return super.getAssignedLabelString();
        }
        Label lbl = this.getAssignedLabel();
        if (lbl == null) {
            return super.getAssignedLabelString();
        }
        return lbl.getExpression();
    }

    @Exported
    public boolean isConcurrentBuild() {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req != null && req.getRequestURI().endsWith("/configure")) {
            return this.isConcurrentBuildFast(false);
        }
        return this.isConcurrentBuildFast(true);
    }

    public boolean isConcurrentBuildFast(boolean inherit) {
        if (!inherit) {
            return super.isConcurrentBuild();
        }
        boolean isConc = super.isConcurrentBuild();
        if (isConc) {
            return true;
        }
        for (AbstractProjectReference apr : this.getParentReferences()) {
            if (apr == null || apr.getProject() == null || !apr.getProject().isConcurrentBuildFast(inherit)) continue;
            return true;
        }
        return false;
    }

    public boolean isConcurrentBuild(IMode mode) {
        InheritanceGovernor<Boolean> gov = new InheritanceGovernor<Boolean>("concurrentBuild", ProjectReference.PrioComparator.SELECTOR.MISC, this){

            @Override
            protected Boolean castToDestinationType(Object o) {
                if (o instanceof Boolean) {
                    return (Boolean)o;
                }
                return null;
            }

            @Override
            public Boolean getRawField(InheritanceProject ip) {
                return ip.isRawConcurrentBuild();
            }
        };
        Boolean b = (Boolean)gov.retrieveFullyDerivedField(this, mode);
        return b != null ? b : false;
    }

    public boolean isRawConcurrentBuild() {
        return super.isConcurrentBuild();
    }

    public boolean isParameterized() {
        ParametersDefinitionProperty pdp = this.getProperty(ParametersDefinitionProperty.class, IMode.INHERIT_FORCED);
        return pdp != null;
    }

    public boolean isRawParameterized() {
        return super.isParameterized();
    }

    public boolean isBuildable() {
        if (!super.isBuildable()) {
            log.fine(String.format("%s not buildable; super.isBuildable() is false", this.getFullName()));
            return false;
        }
        if (this.isAbstract) {
            log.fine(String.format("%s not buildable; project is abstract", this.getFullName()));
            return false;
        }
        if (!this.getMissingDependencies().isEmpty()) {
            return false;
        }
        if (this.hasCyclicDependency()) {
            return false;
        }
        AbstractMap.SimpleEntry<Boolean, String> paramCheck = this.getParameterSanity();
        if (!paramCheck.getKey().booleanValue()) {
            log.fine(String.format("%s not buildable; Parameter inconsistency: %s", this.getFullName(), paramCheck.getValue()));
            return false;
        }
        return true;
    }

    public boolean getIsTransient() {
        return this.isTransient;
    }

    public String getCreationClass() {
        if (!this.needsCreationClass()) {
            return null;
        }
        return this.creationClass;
    }

    protected boolean needsCreationClass() {
        return true;
    }

    public static Map<String, ProjectGraphNode> getConnectionGraph() {
        Object obj = onChangeBuffer.get(null, "getConnectionGraph");
        if (obj != null && obj instanceof Map) {
            return (Map)obj;
        }
        HashMap<String, ProjectGraphNode> map = new HashMap<String, ProjectGraphNode>();
        for (InheritanceProject ip : InheritanceProject.getProjectsMap().values()) {
            String currName = ip.getFullName();
            ProjectGraphNode currNode = map.containsKey(currName) ? (ProjectGraphNode)map.get(currName) : new ProjectGraphNode();
            for (AbstractProjectReference apr : ip.getParentReferences()) {
                String parName = apr.getName();
                currNode.parents.add(parName);
                ProjectGraphNode parNode = map.containsKey(parName) ? (ProjectGraphNode)map.get(parName) : new ProjectGraphNode();
                parNode.children.add(currName);
                map.put(parName, parNode);
            }
            for (AbstractProjectReference apr : ip.getCompatibleProjects()) {
                currNode.mates.add(apr.getName());
            }
            map.put(currName, currNode);
        }
        onChangeBuffer.set(null, "getConnectionGraph", map);
        return map;
    }

    public Collection<InheritanceProject> getRelationshipsOfType(Relationship.Type type) {
        Collection<Object> relationshipsOfType = new LinkedList();
        Map<InheritanceProject, Relationship> relationships = this.getRelationships();
        if (type == Relationship.Type.CHILD) {
            relationshipsOfType = this.getChildrenByBuildDate(relationships);
        } else if (type == Relationship.Type.PARENT) {
            LinkedList<InheritanceProject> parents = new LinkedList<InheritanceProject>();
            for (Map.Entry<InheritanceProject, Relationship> project : relationships.entrySet()) {
                if (Relationship.Type.PARENT != project.getValue().type) continue;
                parents.add(project.getKey());
            }
            relationshipsOfType = parents;
        }
        return relationshipsOfType;
    }

    public Collection<InheritanceProject> getChildrenByBuildDate(Map<InheritanceProject, Relationship> relationships) {
        TreeSet<InheritanceProject> tree = new TreeSet<InheritanceProject>(new RunTimeComparator());
        Map<InheritanceProject, Relationship> relations = this.getRelationships();
        if (relations.isEmpty()) {
            return tree;
        }
        for (Map.Entry<InheritanceProject, Relationship> pair : relations.entrySet()) {
            InheritanceProject child = pair.getKey();
            Relationship.Type type = pair.getValue().type;
            if (type != Relationship.Type.CHILD) continue;
            tree.add(child);
        }
        return tree;
    }

    public Map<InheritanceProject, Relationship> getRelationships() {
        InheritanceProject ip;
        Object obj = onInheritChangeBuffer.get(this, "getRelationships");
        if (obj != null && obj instanceof Map) {
            return (Map)obj;
        }
        HashMap<InheritanceProject, Relationship> map = new HashMap<InheritanceProject, Relationship>();
        HashSet<String> seenProjects = new HashSet<String>();
        Map<String, ProjectGraphNode> connGraph = InheritanceProject.getConnectionGraph();
        ProjectGraphNode node = connGraph.get(this.getFullName());
        if (node == null) {
            return map;
        }
        for (String mate : node.mates) {
            boolean isLeaf;
            InheritanceProject p = InheritanceProject.getProjectByName(mate);
            ProjectGraphNode mateNode = connGraph.get(mate);
            boolean bl = isLeaf = mateNode == null ? true : mateNode.children.isEmpty();
            if (p == null || seenProjects.contains(p.getFullName())) continue;
            map.put(p, new Relationship(Relationship.Type.MATE, 0, isLeaf));
            seenProjects.add(p.getFullName());
        }
        int distance = 1;
        seenProjects.clear();
        LinkedList<InheritanceProject> cOpen = new LinkedList<InheritanceProject>();
        LinkedList<InheritanceProject> nOpen = new LinkedList<InheritanceProject>();
        cOpen.add(this);
        while (!cOpen.isEmpty()) {
            ip = (InheritanceProject)cOpen.pop();
            if (ip == null || seenProjects.contains(ip.getFullName())) continue;
            seenProjects.add(ip.getFullName());
            node = connGraph.get(ip.getFullName());
            if (ip == null || node == null) continue;
            for (String parent : node.parents) {
                InheritanceProject par = InheritanceProject.getProjectByName(parent);
                if (par == null || seenProjects.contains(parent)) continue;
                map.put(par, new Relationship(Relationship.Type.PARENT, distance, false));
                nOpen.push(par);
            }
            if (!cOpen.isEmpty() || nOpen.isEmpty()) continue;
            cOpen = nOpen;
            nOpen = new LinkedList();
            ++distance;
        }
        distance = 1;
        seenProjects.clear();
        cOpen.clear();
        nOpen.clear();
        cOpen.add(this);
        while (!cOpen.isEmpty()) {
            ip = (InheritanceProject)cOpen.pop();
            if (ip == null || seenProjects.contains(ip.getFullName())) continue;
            seenProjects.add(ip.getFullName());
            node = connGraph.get(ip.getFullName());
            if (ip == null || node == null) continue;
            for (String child : node.children) {
                InheritanceProject cProj = InheritanceProject.getProjectByName(child);
                if (cProj == null || seenProjects.contains(child)) continue;
                ProjectGraphNode childNode = connGraph.get(child);
                boolean isLeaf = childNode == null ? true : childNode.children.isEmpty();
                map.put(cProj, new Relationship(Relationship.Type.CHILD, distance, isLeaf));
                nOpen.push(cProj);
            }
            if (!cOpen.isEmpty() || nOpen.isEmpty()) continue;
            cOpen = nOpen;
            nOpen = new LinkedList();
            ++distance;
        }
        onInheritChangeBuffer.set(this, "getRelationships", map);
        return map;
    }

    public List<Vector<String>> getRelatedProjects() {
        Object obj = onInheritChangeBuffer.get(this, "getRelatedProjects");
        if (obj != null && obj instanceof LinkedList) {
            return (LinkedList)obj;
        }
        LinkedList<Vector<String>> lst = new LinkedList<Vector<String>>();
        Map<InheritanceProject, Relationship> rels = this.getRelationships();
        for (Map.Entry<InheritanceProject, Relationship> entry : rels.entrySet()) {
            Relationship rel = entry.getValue();
            Vector<String> vec = new Vector<String>();
            vec.add(entry.getKey().getFullName());
            switch (rel.type) {
                case PARENT: {
                    vec.add(Messages.InheritanceProject_Relationship_Type_ParentDesc());
                    break;
                }
                case CHILD: {
                    vec.add(Messages.InheritanceProject_Relationship_Type_ChildDesc());
                    break;
                }
                case MATE: {
                    vec.add(Messages.InheritanceProject_Relationship_Type_MateDesc());
                }
            }
            vec.add(Integer.toString(rel.distance));
            lst.add(vec);
        }
        onInheritChangeBuffer.set(this, "getRelatedProjects", lst);
        return lst;
    }

    private List<ParameterSelector.ScopeEntry> getFullParameterScope() {
        return ParameterSelector.instance.getAllScopedParameterDefinitions(this);
    }

    public List<ParameterDerivationDetails> getParameterDerivationList() {
        LinkedList<ParameterDerivationDetails> list = new LinkedList<ParameterDerivationDetails>();
        List<ParameterSelector.ScopeEntry> fullScope = this.getFullParameterScope();
        int cnt = 0;
        for (ParameterSelector.ScopeEntry scope : fullScope) {
            String paramName = scope.param.getName();
            String projName = scope.owner;
            String detail = "";
            Object def = scope.param.getDefaultParameterValue().getValue();
            if (scope.param instanceof InheritableStringParameterDefinition) {
                InheritableStringParameterDefinition ispd = (InheritableStringParameterDefinition)scope.param;
                StringBuilder b = new StringBuilder();
                b.append(ispd.getMustHaveDefaultValue());
                b.append("; ");
                b.append(ispd.getMustBeAssigned());
                detail = b.toString();
            }
            ParameterDerivationDetails pdd = new ParameterDerivationDetails(paramName, projName, detail, def);
            pdd.setOrder(cnt++);
            list.add(pdd);
        }
        return list;
    }

    @Override
    public String getSVGLabel() {
        return this.getFullName();
    }

    @Override
    public String getSVGDetail() {
        List builders;
        List<ParameterDefinition> pLst = this.getParameters(IMode.LOCAL_ONLY);
        if (pLst == null) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (ParameterDefinition pd : pLst) {
            if (pd == null) continue;
            b.append(pd.getName());
            ParameterValue pv = pd.getDefaultParameterValue();
            if (pv != null && pv instanceof StringParameterValue) {
                b.append(": ");
                b.append(((StringParameterValue)pv).getValue().toString());
            }
            b.append('\n');
        }
        if (b.length() > 0) {
            b.append("\r\n");
        }
        String str = (builders = this.getBuilders()) == null || builders.size() != 1 ? "steps" : "step";
        int num = builders == null ? 0 : builders.size();
        b.append(String.format("%d build %s\n", num, str));
        DescribableList<Publisher, Descriptor<Publisher>> pubs = this.getPublishersList();
        str = pubs == null || pubs.size() != 1 ? "publishers" : "publisher";
        num = pubs == null ? 0 : pubs.size();
        b.append(String.format("%d %s", num, str));
        return b.toString();
    }

    @Override
    public URL getSVGLabelLink() {
        try {
            return new URL(this.getAbsoluteUrl());
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public Graph<SVGNode> getSVGRelationGraph() {
        Graph<SVGNode> out = new Graph<SVGNode>();
        LinkedList<InheritanceProject> open = new LinkedList<InheritanceProject>();
        HashSet<InheritanceProject> visited = new HashSet<InheritanceProject>();
        open.add(this);
        while (!open.isEmpty()) {
            InheritanceProject ip = (InheritanceProject)open.pop();
            if (visited.contains(ip)) continue;
            visited.add(ip);
            out.addNode(ip, (SVGNode[])new SVGNode[0]);
            for (InheritanceProject parent : ip.getParentProjects()) {
                open.add(parent);
                out.addNode(ip, (SVGNode[])new SVGNode[]{parent});
            }
        }
        return out;
    }

    public String doRenderSVGRelationGraph() {
        return this.renderSVGRelationGraph(0, 0);
    }

    public String renderSVGRelationGraph(int width, int height) {
        SVGTreeRenderer tree = new SVGTreeRenderer(this.getSVGRelationGraph(), width, height);
        Document doc = tree.render();
        try {
            DOMSource source = new DOMSource(doc);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
            return stringWriter.getBuffer().toString();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return "";
    }

    public final Collection<Dependency> getMissingDependencies() {
        HashSet<AbstractProject> seen = new HashSet<AbstractProject>();
        TreeSet<Dependency> missing = new TreeSet<Dependency>();
        LinkedList<AbstractMap.SimpleEntry<InheritanceProject, List<Object>>> open = new LinkedList<AbstractMap.SimpleEntry<InheritanceProject, List<Object>>>();
        Map.Entry<InheritanceProject, List<Object>> entry = new AbstractMap.SimpleEntry(this, Collections.emptyList());
        open.push((AbstractMap.SimpleEntry<InheritanceProject, List<Object>>)entry);
        while (!open.isEmpty()) {
            InheritanceProject next;
            InheritanceProject ip;
            entry = (Map.Entry)open.pop();
            AbstractProject ap = (AbstractProject)entry.getKey();
            List<Object> trace = entry.getValue();
            if (ap == null || seen.contains(ap)) continue;
            seen.add(ap);
            trace = new LinkedList<Object>(trace);
            if (ap != this) {
                trace.add(ap.getFullName());
            }
            InheritanceProject inheritanceProject = ip = ap instanceof InheritanceProject ? (InheritanceProject)ap : null;
            if (ip != null) {
                for (AbstractProjectReference abstractProjectReference : ip.getParentReferences()) {
                    next = abstractProjectReference.getProject();
                    if (next == null) {
                        missing.add(new Dependency(abstractProjectReference.getName(), trace));
                        continue;
                    }
                    open.push(new AbstractMap.SimpleEntry<InheritanceProject, List<Object>>(next, trace));
                }
            }
            for (String string : InheritanceProject.getReferencers(ap)) {
                next = (AbstractProject)Jenkins.get().getItemByFullName(string, AbstractProject.class);
                if (next == null) {
                    missing.add(new Dependency(string, trace));
                    continue;
                }
                open.push(new AbstractMap.SimpleEntry<InheritanceProject, List<Object>>(next, trace));
            }
        }
        for (AbstractProjectReference ref : this.compatibleProjects) {
            InheritanceProject next = ref.getProject();
            if (next != null) continue;
            missing.add(new Dependency(ref.getName(), Collections.emptyList()));
        }
        return missing;
    }

    public final boolean hasCyclicDependency() {
        Object obj = onInheritChangeBuffer.get(this, "hasCyclicDependency");
        if (obj != null && obj instanceof Boolean) {
            return (Boolean)obj;
        }
        Boolean bufRes = this.hasCyclicDependency(true, new String[0]);
        onInheritChangeBuffer.set(this, "hasCyclicDependency", bufRes);
        return bufRes;
    }

    public final boolean hasCyclicDependency(String[] whenTheseProjectsAdded) {
        return this.hasCyclicDependency(true, whenTheseProjectsAdded);
    }

    public final boolean hasCyclicDependency(boolean addExisting, String ... whenTheseProjectsAdded) {
        LinkedList<InheritanceProject> open = new LinkedList<InheritanceProject>();
        if (whenTheseProjectsAdded != null) {
            for (String string : whenTheseProjectsAdded) {
                InheritanceProject p = (InheritanceProject)Jenkins.get().getItemByFullName(string, InheritanceProject.class);
                if (p == null) continue;
                open.add(p);
            }
        }
        if (addExisting) {
            for (AbstractProjectReference par : this.getParentReferences()) {
                InheritanceProject p = par.getProject();
                if (p == null) continue;
                open.add(p);
            }
        }
        HashSet<String> closed = new HashSet<String>();
        closed.add(this.getFullName());
        while (!open.isEmpty()) {
            InheritanceProject p = (InheritanceProject)open.pop();
            if (closed.contains(p.name)) {
                return true;
            }
            for (AbstractProjectReference abstractProjectReference : p.getParentReferences()) {
                InheritanceProject refP = abstractProjectReference.getProject();
                if (refP == null) continue;
                open.push(refP);
            }
            closed.add(p.name);
        }
        return false;
    }

    public final AbstractMap.SimpleEntry<Boolean, String> getParameterSanity() {
        final class SanityRestrictions {
            public Class<?> hasToBeOfThisClass;
            public boolean mustHaveDefault;
            public boolean mustBeAssigned;
            public boolean hadDefaultSet;
            public InheritableStringParameterDefinition.IModes previousMode;

            SanityRestrictions() {
            }
        }
        SanityRestrictions s;
        HashMap<String, SanityRestrictions> resMap = new HashMap<String, SanityRestrictions>();
        List<ParameterSelector.ScopeEntry> fullScope = this.getFullParameterScope();
        for (ParameterSelector.ScopeEntry scope : fullScope) {
            ParameterDefinition pd = scope.param;
            if (pd == null) continue;
            s = (SanityRestrictions)resMap.get(pd.getName());
            if (s == null) {
                s = new SanityRestrictions();
                s.hasToBeOfThisClass = pd.getClass();
                if (pd instanceof InheritableStringParameterDefinition) {
                    InheritableStringParameterDefinition ispd = (InheritableStringParameterDefinition)pd;
                    s.mustHaveDefault = ispd.getMustHaveDefaultValue();
                    s.mustBeAssigned = ispd.getMustBeAssigned();
                    String defVal = ispd.getDefaultValue();
                    s.hadDefaultSet = defVal != null && !defVal.isEmpty();
                    s.previousMode = ispd.getInheritanceModeAsVar();
                } else {
                    s.mustHaveDefault = false;
                    s.previousMode = InheritableStringParameterDefinition.IModes.OVERWRITABLE;
                }
                resMap.put(pd.getName(), s);
                continue;
            }
            boolean isScopeCastToCurrent = pd.getClass().isAssignableFrom(s.hasToBeOfThisClass);
            boolean isCurrentCastToScope = s.hasToBeOfThisClass.isAssignableFrom(pd.getClass());
            if (!isScopeCastToCurrent && !isCurrentCastToScope) {
                return new AbstractMap.SimpleEntry<Boolean, String>(false, "Parameter '" + pd.getName() + "' redefined with different class name.");
            }
            if (s.previousMode == InheritableStringParameterDefinition.IModes.FIXED) {
                return new AbstractMap.SimpleEntry<Boolean, String>(false, "Fixed parameter '" + pd.getName() + "' may not be redefined at all.");
            }
            if (!(pd instanceof InheritableStringParameterDefinition)) continue;
            InheritableStringParameterDefinition ispd = (InheritableStringParameterDefinition)pd;
            String defVal = ispd.getDefaultValue();
            boolean defValNewlySet = defVal != null && !defVal.isEmpty();
            switch (s.previousMode) {
                case OVERWRITABLE: {
                    s.hadDefaultSet = defValNewlySet;
                    break;
                }
                case EXTENSIBLE: {
                    if (s.hadDefaultSet) break;
                    s.hadDefaultSet = defValNewlySet;
                    break;
                }
                case FIXED: {
                    break;
                }
                default: {
                    log.warning("Detected invalid inheritance mode: " + s.previousMode.toString() + " on " + this.getFullName() + "->" + pd.getName());
                }
            }
            if (pd instanceof InheritableStringParameterReferenceDefinition) continue;
            if (s.mustHaveDefault && !ispd.getMustHaveDefaultValue()) {
                return new AbstractMap.SimpleEntry<Boolean, String>(false, "Parameter '" + pd.getName() + "' may not unset the flag that ensures that a default value is set.");
            }
            if (s.mustBeAssigned && !ispd.getMustBeAssigned()) {
                return new AbstractMap.SimpleEntry<Boolean, String>(false, "Parameter '" + pd.getName() + "' may not unset the flag that ensures that a final value is set before execution.");
            }
            s.previousMode = ispd.getInheritanceModeAsVar();
            s.mustHaveDefault = ispd.getMustHaveDefaultValue();
            s.mustBeAssigned = ispd.getMustBeAssigned();
        }
        if (!this.isAbstract) {
            ArrayList mandatoryParams = new ArrayList();
            for (Map.Entry e : resMap.entrySet()) {
                s = (SanityRestrictions)e.getValue();
                if (!s.mustHaveDefault || s.hadDefaultSet) continue;
                mandatoryParams.add(e.getKey());
            }
            if (!mandatoryParams.isEmpty()) {
                return new AbstractMap.SimpleEntry<Boolean, String>(false, String.format(Messages.InheritanceProject_ErrorMsg_ParameterDefaultValue(), StringUtils.join(mandatoryParams, (String)" ',' ")));
            }
        }
        return new AbstractMap.SimpleEntry<Boolean, String>(true, "");
    }

    public String getPronoun() {
        if (this.getIsTransient()) {
            return Messages.InheritanceProject_TransientPronounLabel();
        }
        String cClass = this.getCreationClass();
        if (!StringUtils.isBlank((String)cClass)) {
            return cClass;
        }
        return super.getPronoun();
    }

    public List<Widget> getWidgets() {
        List widgets = super.getWidgets();
        ArrayList<Widget> strippedOffWidgets = new ArrayList<Widget>();
        BuildHistoryWidget bhw = null;
        for (Widget widget : widgets) {
            if (!(widget instanceof HistoryWidget)) {
                strippedOffWidgets.add(widget);
                continue;
            }
            if (!(widget instanceof BuildHistoryWidget)) continue;
            bhw = (BuildHistoryWidget)widget;
        }
        if (!this.isBuildable() && this.getLastBuild() == null) {
            return strippedOffWidgets;
        }
        if (bhw != null) {
            ExtendedBuildHistoryWidget ibhw = new ExtendedBuildHistoryWidget((Queue.Task)bhw.owner, bhw.baseList, (HistoryWidget.Adapter<? super InheritanceProject>)bhw.adapter);
            strippedOffWidgets.add((Widget)ibhw);
            return strippedOffWidgets;
        }
        strippedOffWidgets.add((Widget)bhw);
        return strippedOffWidgets;
    }

    public static List<JobPropertyDescriptor> getJobPropertyDescriptors(Class<? extends Job> clazz, boolean filterIsExcluding, String ... filters) {
        ArrayList<JobPropertyDescriptor> out = new ArrayList<JobPropertyDescriptor>();
        List allDesc = Functions.getJobPropertyDescriptors(clazz);
        for (JobPropertyDescriptor desc : allDesc) {
            String dName = desc.getClass().getName();
            if (filters.length > 0) {
                boolean matched = false;
                if (filters != null) {
                    for (String filter : filters) {
                        if (!dName.contains(filter)) continue;
                        matched = true;
                        break;
                    }
                }
                if (filterIsExcluding && matched || !filterIsExcluding && !matched) continue;
            }
            out.add(desc);
        }
        Collections.sort(out, new Comparator<JobPropertyDescriptor>(){

            @Override
            public int compare(JobPropertyDescriptor o1, JobPropertyDescriptor o2) {
                String c1 = o1.getClass().getName();
                String c2 = o2.getClass().getName();
                return c1.compareTo(c2);
            }
        });
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<AbstractProjectReference, List<Builder>> getBuildersFor(Map<String, Long> verMap, Class<?> clazz) {
        Map<String, Long> oldVerMap = VersionHandler.getVersions();
        try {
            if (verMap != null && !verMap.isEmpty()) {
                VersionHandler.initVersions(verMap);
            }
            LinkedHashMap<AbstractProjectReference, List> out = new LinkedHashMap<AbstractProjectReference, List>();
            LinkedList<AbstractProjectReference> refs = new LinkedList<AbstractProjectReference>(this.getAllParentReferences(ProjectReference.PrioComparator.SELECTOR.BUILDER, true));
            for (AbstractProjectReference apr : refs) {
                InheritanceProject ip = apr.getProject();
                if (ip == null) continue;
                List bLst = ip.getBuildersList(IMode.LOCAL_ONLY).toList();
                if (clazz != null) {
                    LinkedList<Builder> bSubLst = new LinkedList<Builder>();
                    for (Builder b : bLst) {
                        if (b == null || !clazz.isAssignableFrom(b.getClass())) continue;
                        bSubLst.add(b);
                    }
                    out.put(apr, bSubLst);
                    continue;
                }
                out.put(apr, bLst);
            }
            LinkedHashMap<AbstractProjectReference, List> linkedHashMap = out;
            return linkedHashMap;
        }
        finally {
            VersionHandler.initVersions(oldVerMap);
        }
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public static class DescriptorImpl
    extends AbstractProject.AbstractProjectDescriptor {
        private final HashSet<String> projectsToBeCreatedTransient = new HashSet();
        public static final Pattern urlJobPattern = Pattern.compile("/job/([^/]+)");

        public DescriptorImpl() {
            InheritanceProject.createBuffers();
        }

        public String getDisplayName() {
            return Messages.InheritanceProject_DisplayName();
        }

        public String getDescription() {
            return Messages.InheritanceProject_Description();
        }

        public boolean isApplicable(Descriptor descriptor) {
            if (descriptor.isSubTypeOf(ArtifactArchiver.class)) {
                return false;
            }
            return super.isApplicable(descriptor);
        }

        public String getCategoryId() {
            return "inheritable-projects";
        }

        public String getIconFilePathPattern() {
            return "plugin/project-inheritance/images/:size/gear.png";
        }

        public String getIconClassName() {
            return "icon-inheritance-project";
        }

        public InheritanceProject newInstance(ItemGroup parent, String name) {
            if (this.projectsToBeCreatedTransient.contains(name)) {
                this.projectsToBeCreatedTransient.remove(name);
                return new InheritanceProject(parent, name, true);
            }
            return new InheritanceProject(parent, name, false);
        }

        public ListBoxModel doFillCreationClassItems() {
            ListBoxModel names = new ListBoxModel();
            for (ProjectCreationEngine.CreationClass cl : ProjectCreationEngine.instance.getCreationClasses()) {
                names.add(cl.name);
            }
            names.add("<None Specified>", "");
            return names;
        }

        public ListBoxModel doFillProjectClassItems() {
            return this.doFillCreationClassItems();
        }

        public ListBoxModel doFillUserDesiredVersionItems() {
            ListBoxModel verBox = new ListBoxModel();
            InheritanceProject ip = this.getConfiguredProject();
            if (ip != null) {
                for (VersionedObjectStore.Version v : ip.getVersions()) {
                    verBox.add(v.toString(), v.id.toString());
                }
            } else {
                log.warning("Could not fetch or resolve project name");
            }
            return verBox;
        }

        public InheritanceProject getConfiguredProject(StaplerRequest req) {
            if (req == null) {
                return null;
            }
            InheritanceProject ip = (InheritanceProject)req.findAncestorObject(InheritanceProject.class);
            if (ip != null) {
                return ip;
            }
            String uri = req.getRequestURI();
            if (uri == null || uri.length() == 0) {
                return null;
            }
            Matcher m = urlJobPattern.matcher(uri);
            if (m == null || !m.find()) {
                return null;
            }
            String pName = m.group(1);
            if (pName == null || pName.length() == 0) {
                return null;
            }
            return InheritanceProject.getProjectByName(pName);
        }

        protected InheritanceProject getConfiguredProject() {
            return this.getConfiguredProject(Stapler.getCurrentRequest());
        }

        public synchronized void addProjectToBeCreatedTransient(String name) {
            this.projectsToBeCreatedTransient.add(name);
        }

        public synchronized void dropProjectToBeCreatedTransient(String name) {
            this.projectsToBeCreatedTransient.remove(name);
        }

        static {
            IconSet.icons.addIcon(new Icon("icon-inheritance-project icon-sm", "plugin/project-inheritance/images/16x16/gear.png", "width: 16px; height: 16px;"));
            IconSet.icons.addIcon(new Icon("icon-inheritance-project icon-md", "plugin/project-inheritance/images/24x24/gear.png", "width: 24px; height: 24px;"));
            IconSet.icons.addIcon(new Icon("icon-inheritance-project icon-lg", "plugin/project-inheritance/images/32x32/gear.png", "width: 32px; height: 32px;"));
            IconSet.icons.addIcon(new Icon("icon-inheritance-project icon-xlg", "plugin/project-inheritance/images/48x48/gear.png", "width: 48px; height: 48px;"));
        }
    }

    public static class Dependency
    implements Comparable<Dependency> {
        public final String ref;
        public final List<String> trace;

        public Dependency(String ref, String ... trace) {
            this.ref = ref;
            this.trace = trace == null ? Collections.emptyList() : Arrays.asList(trace);
        }

        public Dependency(String ref, List<String> trace) {
            this.ref = ref;
            this.trace = new LinkedList<String>(trace);
        }

        @Override
        public int compareTo(Dependency other) {
            String s = Joiner.on((String)":").join(this.trace);
            s = s.isEmpty() ? this.ref : s + ":" + this.ref;
            String o = Joiner.on((String)":").join(other.trace);
            o = o.isEmpty() ? other.ref : o + ":" + other.ref;
            return s.compareTo(o);
        }
    }

    private class RunTimeComparator
    implements Comparator<InheritanceProject> {
        private RunTimeComparator() {
        }

        @Override
        public int compare(InheritanceProject a, InheritanceProject b) {
            InheritanceBuild aBuild = (InheritanceBuild)a.getLastBuild();
            InheritanceBuild bBuild = (InheritanceBuild)b.getLastBuild();
            if (aBuild == null) {
                int retVal = bBuild == null ? a.getFullName().compareTo(b.getFullName()) : 1;
                return retVal;
            }
            if (bBuild == null) {
                int retVal = aBuild == null ? a.getFullName().compareTo(b.getFullName()) : -1;
                return retVal;
            }
            return bBuild.getTime().compareTo(aBuild.getTime());
        }
    }

    private static class ProjectGraphNode {
        public HashSet<String> parents = new HashSet();
        public HashSet<String> mates = new HashSet();
        public HashSet<String> children = new HashSet();

        private ProjectGraphNode() {
        }
    }

    public static class InheritedVersionInfo {
        public final InheritanceProject project;
        public final Long version;
        public final List<Long> versions;
        public final String description;

        public InheritedVersionInfo(InheritanceProject project, Long version, List<Long> versions, String description) {
            this.project = project;
            this.version = version;
            this.versions = versions;
            this.description = description;
        }

        public String toString() {
            return String.format("%s(%d)", this.project.getFullName(), this.version);
        }

        public List<Long> getVersions() {
            return this.versions;
        }

        public static InheritedVersionInfo getVersionFrom(InheritanceProject p, Map<String, Long> predefs) {
            VersionedObjectStore.Version verObj;
            LinkedList<Long> verLst = new LinkedList<Long>();
            for (VersionedObjectStore.Version v : p.versionStore.getAllVersions()) {
                verLst.add(v.id);
            }
            Long verId = predefs.get(p.getFullName());
            if (verId == null) {
                verId = p.getStableVersion();
            }
            return new InheritedVersionInfo(p, verId, verLst, (verObj = p.versionStore.getVersion(verId)) != null ? verObj.getDescription() : null);
        }
    }

    public static enum IMode {
        LOCAL_ONLY,
        INHERIT_FORCED,
        AUTO;

    }

    public class ParameterDerivationDetails
    implements Comparable<ParameterDerivationDetails> {
        private final String parameterName;
        private final String projectName;
        private final String detail;
        private final Object defaultValue;
        private int order = 0;

        public ParameterDerivationDetails(String paramName, String projectName, String detail, Object defaultValue) {
            this.parameterName = paramName;
            this.projectName = projectName;
            this.detail = detail;
            this.defaultValue = defaultValue;
            if (this.parameterName == null || this.projectName == null) {
                throw new NullPointerException();
            }
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getDetail() {
            return this.detail;
        }

        public String getProjectAndDetail() {
            if (this.detail != null && this.detail.length() > 0) {
                return this.projectName + "(" + this.detail + ")";
            }
            return this.projectName;
        }

        public String getDefault() {
            if (this.defaultValue == null) {
                return "NULL";
            }
            return this.defaultValue.toString();
        }

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ParameterDerivationDetails)) {
                return false;
            }
            ParameterDerivationDetails o = (ParameterDerivationDetails)other;
            return Helpers.bothNullOrEqual(this.parameterName, o.parameterName) && Helpers.bothNullOrEqual(this.projectName, o.projectName) && Helpers.bothNullOrEqual(this.detail, o.detail) && Helpers.bothNullOrEqual(this.defaultValue, o.defaultValue);
        }

        @Override
        public int compareTo(ParameterDerivationDetails o) {
            if (!Helpers.bothNullOrEqual(this.parameterName, o.parameterName)) {
                return this.parameterName.compareTo(this.parameterName);
            }
            if (!Helpers.bothNullOrEqual(this.projectName, o.projectName)) {
                return this.projectName.compareTo(this.projectName);
            }
            if (!Helpers.bothNullOrEqual(this.detail, o.detail)) {
                return this.detail.compareTo(this.detail);
            }
            if (!Helpers.bothNullOrEqual(this.defaultValue, o.defaultValue)) {
                return this.defaultValue.toString().compareTo(this.defaultValue.toString());
            }
            return 0;
        }
    }

    public static class Relationship {
        public final Type type;
        public final int distance;
        public final boolean isLeaf;

        public Relationship(Type type, int distance, boolean isLeaf) {
            this.type = type;
            this.distance = distance;
            this.isLeaf = isLeaf;
        }

        public static enum Type {
            PARENT,
            MATE,
            CHILD;


            public String toString() {
                switch (this) {
                    case PARENT: {
                        return Messages.InheritanceProject_Relationship_Type_Parent();
                    }
                    case MATE: {
                        return Messages.InheritanceProject_Relationship_Type_Mate();
                    }
                    case CHILD: {
                        return Messages.InheritanceProject_Relationship_Type_Child();
                    }
                }
                return "N/A";
            }

            public String getDescription() {
                switch (this) {
                    case PARENT: {
                        return Messages.InheritanceProject_Relationship_Type_ParentDesc();
                    }
                    case MATE: {
                        return Messages.InheritanceProject_Relationship_Type_MateDesc();
                    }
                    case CHILD: {
                        return Messages.InheritanceProject_Relationship_Type_ChildDesc();
                    }
                }
                return "N/A";
            }
        }
    }
}

