/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.miniconnect.jdbc.provider.impl;

import hu.webarticum.miniconnect.api.MiniSession;
import hu.webarticum.miniconnect.jdbc.provider.TransactionIsolationLevel;
import hu.webarticum.miniconnect.jdbc.provider.impl.AbstractBlanketDatabaseProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class H2DatabaseProvider
extends AbstractBlanketDatabaseProvider {
    private static final String DATABASE_PRODUCT_NAME = "H2";
    private static final String SAVEPOINT_PREFIX = "MINICONNECT_H2_SAVEPOINT_";
    private static final Map<String, TransactionIsolationLevel> ADDITIONAL_TRANSACTION_ISOLATION_LEVELS = new HashMap<String, TransactionIsolationLevel>();

    @Override
    public String getDatabaseFullVersion(MiniSession session) {
        String sql = "SELECT H2VERSION()";
        return this.extractSingleField(this.checkResult(session.execute(sql)), String.class);
    }

    @Override
    public String getDatabaseProductName(MiniSession session) {
        return DATABASE_PRODUCT_NAME;
    }

    @Override
    public boolean isAutoCommit(MiniSession session) {
        String sql = "SELECT AUTOCOMMIT()";
        return this.extractSingleField(this.checkResult(session.execute(sql)), Boolean.class);
    }

    @Override
    public void setAutoCommit(MiniSession session, boolean autoCommit) {
        String sql = "SET AUTOCOMMIT " + (autoCommit ? "ON" : "OFF");
        this.checkResult(session.execute(sql));
    }

    @Override
    public void commit(MiniSession session) {
        String sql = "COMMIT";
        this.checkResult(session.execute(sql));
    }

    @Override
    public void rollback(MiniSession session) {
        String sql = "ROLLBACK";
        this.checkResult(session.execute(sql));
    }

    @Override
    public int setSavepoint(MiniSession session) {
        int id = UUID.randomUUID().hashCode();
        String name = SAVEPOINT_PREFIX + id;
        String sql = "SAVEPOINT " + this.quoteIdentifier(name);
        this.checkResult(session.execute(sql));
        return id;
    }

    @Override
    public void setSavepoint(MiniSession session, String name) {
        String sql = "SAVEPOINT " + this.quoteIdentifier(name);
        this.checkResult(session.execute(sql));
    }

    @Override
    public void rollbackToSavepoint(MiniSession session, int id) {
        String name = SAVEPOINT_PREFIX + id;
        String sql = "SAVEPOINT " + this.quoteIdentifier(name);
        this.checkResult(session.execute(sql));
    }

    @Override
    public void rollbackToSavepoint(MiniSession session, String name) {
        String sql = "ROLLBACK TO SAVEPOINT " + this.quoteIdentifier(name);
        this.checkResult(session.execute(sql));
    }

    @Override
    public void releaseSavepoint(MiniSession session, int id) {
    }

    @Override
    public void releaseSavepoint(MiniSession session, String name) {
    }

    @Override
    public void setTransactionIsolationLevel(MiniSession session, TransactionIsolationLevel level) {
        String levelName = (String)TRANSACTION_ISOLATION_LEVEL_NAME_MAP.get((Object)level);
        String sql = "SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL " + levelName;
        this.checkResult(session.execute(sql));
    }

    @Override
    public TransactionIsolationLevel getTransactionIsolationLevel(MiniSession session) {
        String sql = "SELECT ISOLATION_LEVEL FROM INFORMATION_SCHEMA.SESSIONS WHERE ID = SESSION_ID()";
        String levelName = this.extractSingleField(this.checkResult(session.execute(sql)), String.class);
        TransactionIsolationLevel level = ADDITIONAL_TRANSACTION_ISOLATION_LEVELS.get(levelName);
        if (level != null) {
            return level;
        }
        return TRANSACTION_ISOLATION_LEVEL_NAME_MAP.entrySet().stream().filter(e -> ((String)e.getValue()).equals(levelName)).map(Map.Entry::getKey).findAny().get();
    }

    static {
        ADDITIONAL_TRANSACTION_ISOLATION_LEVELS.put("SNAPSHOT", TransactionIsolationLevel.READ_COMMITTED);
    }
}

