/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.miniconnect.jdbc.blob;

import hu.webarticum.miniconnect.jdbc.blob.WriteableBlob;
import hu.webarticum.miniconnect.jdbc.io.LongBoundedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.io.output.WriterOutputStream;

public class BlobClob
implements NClob {
    private final Blob blob;
    private final Charset blobCharset;
    private final int blobCharWidth;
    private final Charset targetCharset;
    private final boolean lengthIsCachable;
    private volatile long cachedLength = -1L;

    public BlobClob() {
        this(StandardCharsets.UTF_8);
    }

    public BlobClob(Charset targetCharset) {
        this(new WriteableBlob(), StandardCharsets.UTF_16BE, 2, targetCharset);
    }

    public BlobClob(Charset blobCharset, Charset targetCharset) {
        this(new WriteableBlob(), blobCharset, 0, targetCharset);
    }

    public BlobClob(Blob blob, Charset blobCharset, Charset targetCharset) {
        this(blob, blobCharset, 0, targetCharset);
    }

    public BlobClob(Blob blob, Charset blobCharset, int blobCharWidth, Charset targetCharset) {
        this(blob, blobCharset, blobCharWidth, targetCharset, false);
    }

    public BlobClob(Blob blob, Charset blobCharset, int blobCharWidth, Charset targetCharset, boolean lengthIsCachable) {
        this.blob = blob;
        this.blobCharset = blobCharset;
        this.blobCharWidth = blobCharWidth;
        this.targetCharset = targetCharset;
        this.lengthIsCachable = lengthIsCachable;
    }

    public Blob getBlob() {
        return this.blob;
    }

    public Charset getBlobCharset() {
        return this.blobCharset;
    }

    public int getBlobCharWidth() {
        return this.blobCharWidth;
    }

    public Charset getTargetCharset() {
        return this.targetCharset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() throws SQLException {
        if (this.cachedLength >= 0L) {
            return this.cachedLength;
        }
        if (!this.lengthIsCachable) {
            return this.calculateLength();
        }
        BlobClob blobClob = this;
        synchronized (blobClob) {
            this.cachedLength = this.calculateLength();
            return this.cachedLength;
        }
    }

    private long calculateLength() throws SQLException {
        if (this.blobCharWidth > 0) {
            return this.blob.length() / (long)this.blobCharWidth;
        }
        return BlobClob.countCharactersIn(this.getCharacterStream());
    }

    private static long countCharactersIn(Reader reader) throws SQLException {
        try {
            return reader.skip(9223372036854774807L);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        if (this.blobCharWidth > 0) {
            return this.getSubStringWithFixedCharWidth(pos, length);
        }
        return this.getSubStringWithVariableCharWidth(pos, length);
    }

    private String getSubStringWithFixedCharWidth(long pos, int length) throws SQLException {
        long bytePos = this.findBytePos(pos);
        int byteLength = length * this.blobCharWidth;
        byte[] bytes = this.blob.getBytes(bytePos, byteLength);
        return new String(bytes, this.blobCharset);
    }

    private String getSubStringWithVariableCharWidth(long pos, int length) throws SQLException {
        try {
            return IOUtils.toString((Reader)this.getCharacterStreamWithVariableCharWidth(pos, length));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return new InputStreamReader(this.blob.getBinaryStream(), this.blobCharset);
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        if (this.blobCharWidth > 0) {
            return this.getCharacterStreamWithFixedCharWidth(pos, length);
        }
        return this.getCharacterStreamWithVariableCharWidth(pos, length);
    }

    private Reader getCharacterStreamWithFixedCharWidth(long pos, long length) throws SQLException {
        long bytePos = this.findBytePos(pos);
        long byteLength = length * (long)this.blobCharWidth;
        return new InputStreamReader(this.blob.getBinaryStream(bytePos, byteLength), this.blobCharset);
    }

    private Reader getCharacterStreamWithVariableCharWidth(long pos, long length) throws SQLException {
        long zeroBasedPos = pos - 1L;
        long until = zeroBasedPos + length;
        LongBoundedReader reader = new LongBoundedReader(new InputStreamReader(this.blob.getBinaryStream()), until);
        try {
            reader.skip(zeroBasedPos);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return reader;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        if (this.blobCharset == this.targetCharset) {
            return this.blob.getBinaryStream();
        }
        return new ReaderInputStream((Reader)new InputStreamReader(this.blob.getBinaryStream(), this.blobCharset), this.targetCharset);
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        return this.setString(pos, str.substring(offset, offset + len));
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        long bytePos = this.findBytePos(pos);
        byte[] bytes = str.getBytes(this.blobCharset);
        this.blob.setBytes(bytePos, bytes);
        return bytes.length;
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        long bytePos = this.findBytePos(pos);
        if (this.blobCharset == this.targetCharset) {
            return this.blob.setBinaryStream(bytePos);
        }
        OutputStream byteStream = this.blob.setBinaryStream(bytePos);
        return new WriterOutputStream((Writer)new OutputStreamWriter(byteStream, this.blobCharset), this.targetCharset);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        long bytePos = this.findBytePos(pos);
        OutputStream byteStream = this.blob.setBinaryStream(bytePos);
        return new OutputStreamWriter(byteStream, this.blobCharset);
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void free() throws SQLException {
        this.blob.free();
    }

    private long findBytePos(long charPos) throws SQLException {
        if (charPos == 1L) {
            return 1L;
        }
        if (this.blobCharWidth > 0) {
            return (charPos - 1L) * (long)this.blobCharWidth + 1L;
        }
        InputStreamReader reader = new InputStreamReader(this.blob.getBinaryStream());
        try {
            return this.countReaderBytesUntil(reader, charPos - 1L) + 1L;
        }
        catch (IOException e) {
            throw new SQLException();
        }
    }

    private long countReaderBytesUntil(Reader reader, long until) throws IOException {
        int readLength;
        long result = 0L;
        long remainingChars = until;
        char[] buffer = new char[1024];
        while ((readLength = reader.read(buffer)) != -1) {
            int usefulLength = (remainingChars -= (long)readLength) >= 0L ? readLength : (int)((long)readLength + remainingChars);
            int byteLength = this.blobCharset.encode(new String(buffer, 0, usefulLength)).remaining();
            result += (long)byteLength;
        }
        return result;
    }
}

