/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.miniconnect.jdbc;

import hu.webarticum.miniconnect.api.MiniColumnHeader;
import hu.webarticum.miniconnect.api.MiniResultSet;
import hu.webarticum.miniconnect.api.MiniValue;
import hu.webarticum.miniconnect.jdbc.MiniJdbcResultSetMetaData;
import hu.webarticum.miniconnect.jdbc.blob.BlobClob;
import hu.webarticum.miniconnect.jdbc.blob.ContentAccessBlob;
import hu.webarticum.miniconnect.lang.ImmutableList;
import hu.webarticum.miniconnect.record.ResultField;
import hu.webarticum.miniconnect.record.ResultRecord;
import hu.webarticum.miniconnect.record.ResultTable;
import hu.webarticum.miniconnect.record.translator.ValueTranslator;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;

public class MiniJdbcResultSet
implements ResultSet {
    private final Statement statement;
    private final ResultTable resultTable;
    private final MiniJdbcResultSetMetaData metaData;
    private final int columnCount;
    private volatile ResultRecord currentRecord = null;
    private volatile boolean wasNull = false;
    private final Object closeLock = new Object();
    private volatile boolean closed = false;

    public MiniJdbcResultSet(Statement statement, MiniResultSet miniResultSet) {
        this.statement = statement;
        this.resultTable = new ResultTable(miniResultSet);
        this.metaData = new MiniJdbcResultSetMetaData(this.getMiniColumnHeaders(), (ImmutableList<String>)this.getValueTranslators().map(ValueTranslator::assuredClazzName));
        this.columnCount = miniResultSet.columnHeaders().size();
    }

    public ImmutableList<ValueTranslator> getValueTranslators() {
        return this.resultTable.valueTranslators();
    }

    public ImmutableList<MiniColumnHeader> getMiniColumnHeaders() {
        return this.resultTable.resultSet().columnHeaders();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public <T> T unwrap(Class<T> type) throws SQLException {
        if (!this.isWrapperFor(type)) {
            throw new SQLException(String.format("Unable to convert %s to %s", this.getClass(), type));
        }
        MiniJdbcResultSet result = this;
        return (T)result;
    }

    @Override
    public boolean isWrapperFor(Class<?> type) throws SQLException {
        return type != null && type.isAssignableFrom(this.getClass());
    }

    @Override
    public MiniJdbcResultSetMetaData getMetaData() throws SQLException {
        return this.metaData;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        ImmutableList<MiniColumnHeader> columnHeaders = this.getMiniColumnHeaders();
        for (int i = 0; i < this.columnCount; ++i) {
            String columnName = ((MiniColumnHeader)columnHeaders.get(i)).name();
            if (!columnName.equals(columnLabel)) continue;
            return i + 1;
        }
        throw new SQLException(String.format("No column with label '%s'", columnLabel));
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw this.createForwardOnlyException();
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getRow() throws SQLException {
        throw this.createForwardOnlyException();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw this.createForwardOnlyException();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw this.createForwardOnlyException();
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw this.createForwardOnlyException();
    }

    @Override
    public boolean isLast() throws SQLException {
        throw this.createForwardOnlyException();
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw this.createForwardOnlyException();
    }

    @Override
    public void afterLast() throws SQLException {
        throw this.createForwardOnlyException();
    }

    @Override
    public boolean first() throws SQLException {
        throw this.createForwardOnlyException();
    }

    @Override
    public boolean last() throws SQLException {
        throw this.createForwardOnlyException();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw this.createForwardOnlyException();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (rows == 1) {
            return this.next();
        }
        throw this.createForwardOnlyException();
    }

    @Override
    public boolean next() throws SQLException {
        Iterator iterator = this.resultTable.iterator();
        if (!iterator.hasNext()) {
            this.currentRecord = null;
            return false;
        }
        this.currentRecord = (ResultRecord)iterator.next();
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        throw this.createForwardOnlyException();
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Boolean result = this.getObject(columnIndex, Boolean.class);
        if (result == null) {
            return false;
        }
        return result;
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Byte result = this.getObject(columnIndex, Byte.class);
        if (result == null) {
            return 0;
        }
        return result;
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Short result = this.getObject(columnIndex, Short.class);
        if (result == null) {
            return 0;
        }
        return result;
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Integer result = this.getObject(columnIndex, Integer.class);
        if (result == null) {
            return 0;
        }
        return result;
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Long result = this.getObject(columnIndex, Long.class);
        if (result == null) {
            return 0L;
        }
        return result;
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Float result = this.getObject(columnIndex, Float.class);
        if (result == null) {
            return 0.0f;
        }
        return result.floatValue();
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Double result = this.getObject(columnIndex, Double.class);
        if (result == null) {
            return 0.0;
        }
        return result;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getObject(columnIndex, BigDecimal.class);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getBigDecimal(columnIndex).setScale(scale, RoundingMode.HALF_UP);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.getObject(columnIndex, byte[].class);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.getObject(columnIndex, String.class);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getNString(this.findColumn(columnLabel));
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getObject(columnIndex, String.class);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), calendar);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getObject(columnIndex, Date.class);
    }

    @Override
    public Date getDate(int columnIndex, Calendar calendar) throws SQLException {
        Instant instant = this.getDate(columnIndex).toInstant();
        ZoneId zoneId = calendar.getTimeZone().toZoneId();
        LocalDate localDate = LocalDateTime.ofInstant(instant, zoneId).toLocalDate();
        return Date.valueOf(localDate);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), calendar);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getObject(columnIndex, Time.class);
    }

    @Override
    public Time getTime(int columnIndex, Calendar calendar) throws SQLException {
        return this.getTime(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getObject(columnIndex, Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return this.getObject(columnIndex, URL.class);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getBinaryStream(columnIndex);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.getNCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getNCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getObject(columnIndex, Reader.class);
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.getObject(columnIndex, InputStream.class);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return this.getObject(columnIndex, Blob.class);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getNClob(columnLabel);
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return this.getNClob(columnIndex);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return this.getObject(columnIndex, NClob.class);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return this.getRef(this.findColumn(columnLabel));
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), map);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        ResultField resultField = this.getResultField(columnIndex);
        Object value = resultField.get();
        if (value == null || type.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        T jdbcTypeResult = this.tryConvertToJdbcType(columnIndex, type);
        if (jdbcTypeResult != null) {
            return jdbcTypeResult;
        }
        return (T)resultField.as(type);
    }

    private <T> T tryConvertToJdbcType(int columnIndex, Class<T> type) throws SQLException {
        if (type == Date.class) {
            return (T)Date.valueOf((LocalDate)this.getResultField(columnIndex).as(LocalDate.class));
        }
        if (type == Time.class) {
            return (T)Time.valueOf((LocalTime)this.getResultField(columnIndex).as(LocalTime.class));
        }
        if (type == Timestamp.class) {
            return (T)Timestamp.from((Instant)this.getResultField(columnIndex).as(Instant.class));
        }
        if (type == Blob.class) {
            return (T)new ContentAccessBlob(this.getMiniValue(columnIndex).contentAccess());
        }
        if (type == Clob.class || type == NClob.class) {
            return (T)new BlobClob(new ContentAccessBlob(this.getMiniValue(columnIndex).contentAccess()), StandardCharsets.ISO_8859_1, 1, StandardCharsets.UTF_8);
        }
        return null;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        ResultField resultField = this.getResultField(columnIndex);
        Object result = resultField.get();
        this.wasNull = result == null;
        return result;
    }

    public MiniValue getMiniValue(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.columnCount) {
            throw new SQLException(String.format("Invalid column index: %d", columnIndex));
        }
        return (MiniValue)this.currentRecord.row().get(columnIndex - 1);
    }

    public ResultField getResultField(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this.columnCount) {
            throw new SQLException(String.format("Invalid column index: %d", columnIndex));
        }
        return this.currentRecord.get(columnIndex - 1);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw this.createReadOnlyException();
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.closed) {
                this.closeInternal();
            }
        }
    }

    public void closeInternal() throws SQLException {
        this.closed = true;
        try {
            this.resultTable.resultSet().close();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    private SQLException createForwardOnlyException() {
        return new SQLException("This result set is FORWARD_ONLY");
    }

    private SQLException createReadOnlyException() {
        return new SQLException("This result set is READ_ONLY");
    }
}

