/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.miniconnect.jdbc;

import hu.webarticum.miniconnect.api.MiniSession;
import hu.webarticum.miniconnect.jdbc.ConnectionUrlInfo;
import hu.webarticum.miniconnect.jdbc.MiniJdbcConnection;
import hu.webarticum.miniconnect.jdbc.provider.DatabaseProvider;
import hu.webarticum.miniconnect.jdbc.provider.impl.BlanketDatabaseProvider;
import hu.webarticum.miniconnect.jdbc.provider.impl.H2DatabaseProvider;
import hu.webarticum.miniconnect.lang.ImmutableMap;
import hu.webarticum.miniconnect.messenger.Messenger;
import hu.webarticum.miniconnect.messenger.adapter.MessengerSessionManager;
import hu.webarticum.miniconnect.server.ClientMessenger;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class MiniJdbcDriver
implements Driver {
    public static final int JDBC_MAJOR_VERSION = 4;
    public static final int JDBC_MINOR_VERSION = 2;
    public static final String DRIVER_NAME = "MiniConnect JDBC";
    public static final int DRIVER_MAJOR_VERSION = 0;
    public static final int DRIVER_MINOR_VERSION = 1;
    public static final String DRIVER_VERSION = "0.1";
    public static final String PROPERTY_USER = "user";
    public static final String PROPERTY_PASSSWORD = "password";
    public static final String PROPERTY_PROVIDER = "provider";
    public static final String PROVIDER_BLANKET = "blanket";
    public static final String PROVIDER_H2 = "h2";

    @Override
    public boolean acceptsURL(String url) {
        return ConnectionUrlInfo.isUrlSupported(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        ConnectionUrlInfo urlInfo = ConnectionUrlInfo.parse(url, info);
        ImmutableMap<String, String> properties = urlInfo.properties();
        String schema = urlInfo.schema();
        ClientMessenger clientMessenger = new ClientMessenger(urlInfo.host(), urlInfo.port());
        MiniSession session = new MessengerSessionManager((Messenger)clientMessenger).openSession();
        String providerName = (String)properties.getOrDefault((Object)PROPERTY_PROVIDER, (Object)PROVIDER_BLANKET);
        DatabaseProvider databaseProvider = this.createProviderFor(providerName);
        MiniJdbcConnection connection = new MiniJdbcConnection(session, databaseProvider, url, () -> ((ClientMessenger)clientMessenger).close());
        if (schema != null) {
            try {
                connection.setSchema(schema);
            }
            catch (Exception e) {
                connection.close();
                throw e;
            }
        }
        return connection;
    }

    private DatabaseProvider createProviderFor(String providerName) {
        if (providerName.equals(PROVIDER_BLANKET)) {
            return new BlanketDatabaseProvider();
        }
        if (providerName.equals(PROVIDER_H2)) {
            return new H2DatabaseProvider();
        }
        throw new IllegalArgumentException("Unsupported provider name: " + providerName);
    }
}

