/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.miniconnect.jdbc;

import hu.webarticum.miniconnect.api.MiniSession;
import hu.webarticum.miniconnect.jdbc.MiniJdbcDatabaseMetaData;
import hu.webarticum.miniconnect.jdbc.MiniJdbcPreparedStatement;
import hu.webarticum.miniconnect.jdbc.MiniJdbcSavepoint;
import hu.webarticum.miniconnect.jdbc.MiniJdbcStatement;
import hu.webarticum.miniconnect.jdbc.blob.BlobClob;
import hu.webarticum.miniconnect.jdbc.blob.WriteableBlob;
import hu.webarticum.miniconnect.jdbc.provider.DatabaseProvider;
import hu.webarticum.miniconnect.jdbc.provider.TransactionIsolationLevel;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;

public class MiniJdbcConnection
implements Connection {
    private static final Map<Integer, TransactionIsolationLevel> TRANSACTION_ISOLATION_LEVEL_MAP = new HashMap<Integer, TransactionIsolationLevel>();
    private final MiniSession miniSession;
    private final DatabaseProvider databaseProvider;
    private final String connectionUrl;
    private final Runnable closeCallback;
    private final MiniJdbcDatabaseMetaData metaData;
    private final Map<String, String> clientInfo = Collections.synchronizedMap(new HashMap());
    private volatile SQLWarning currentWarningHead = null;
    private volatile boolean closed = false;
    private final Object closeLock = new Object();
    private final CopyOnWriteArrayList<Statement> activeStatements = new CopyOnWriteArrayList();

    public MiniJdbcConnection(MiniSession session, DatabaseProvider databaseProvider) {
        this(session, databaseProvider, null);
    }

    public MiniJdbcConnection(MiniSession session, DatabaseProvider databaseProvider, String connectionUrl) {
        this(session, databaseProvider, connectionUrl, null);
    }

    public MiniJdbcConnection(MiniSession session, DatabaseProvider databaseProvider, String connectionUrl, Runnable closeCallback) {
        this.miniSession = session;
        this.databaseProvider = databaseProvider;
        this.connectionUrl = connectionUrl;
        this.closeCallback = closeCallback;
        this.metaData = new MiniJdbcDatabaseMetaData(this);
    }

    public MiniSession getMiniSession() {
        return this.miniSession;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public DatabaseProvider getDatabaseProvider() {
        return this.databaseProvider;
    }

    public void registerActiveStatement(Statement statement) {
        this.activeStatements.add(statement);
    }

    public void unregisterActiveStatement(Statement statement) {
        this.activeStatements.remove(statement);
    }

    @Override
    public <T> T unwrap(Class<T> type) throws SQLException {
        if (!this.isWrapperFor(type)) {
            throw new SQLException(String.format("Unable to convert %s to %s", this.getClass(), type));
        }
        MiniJdbcConnection result = this;
        return (T)result;
    }

    @Override
    public boolean isWrapperFor(Class<?> type) throws SQLException {
        return type != null && type.isAssignableFrom(this.getClass());
    }

    @Override
    public MiniJdbcDatabaseMetaData getMetaData() throws SQLException {
        return this.metaData;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return Collections.emptyMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        if (map != null && map.size() > 0) {
            throw new SQLException("Only empty map is supported");
        }
    }

    void setCurrentWarningHead(SQLWarning warning) {
        this.currentWarningHead = warning;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.currentWarningHead;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.currentWarningHead = null;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.clientInfo.put(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        HashMap replacements = new HashMap();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> replacements.put(k != null ? k.toString() : null, v != null ? v.toString() : null)));
        this.clientInfo.keySet().forEach(k -> replacements.putIfAbsent(k, null));
        this.clientInfo.putAll(replacements);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.clientInfo.get(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        Properties properties = new Properties();
        properties.putAll(this.clientInfo);
        return properties;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this.databaseProvider.setReadOnly(this.miniSession, readOnly);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return this.databaseProvider.isReadOnly(this.miniSession);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        try {
            this.databaseProvider.setCatalog(this.miniSession, catalog);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            return this.databaseProvider.getCatalog(this.miniSession);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        try {
            this.databaseProvider.setSchema(this.miniSession, schema);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        try {
            return this.databaseProvider.getSchema(this.miniSession);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 1);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetType != 1003) {
            throw new SQLException("Only TYPE_FORWARD_ONLY result sets are supported");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLException("Only READ_ONLY result sets are supported");
        }
        if (resultSetHoldability != 1) {
            throw new SQLException("Only HOLD_CURSORS_OVER_COMMIT result sets are supported");
        }
        return new MiniJdbcStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new MiniJdbcPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    @Override
    public Blob createBlob() throws SQLException {
        return new WriteableBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.createUtf8BlobClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.createUtf8BlobClob();
    }

    public BlobClob createUtf8BlobClob() {
        return new BlobClob(StandardCharsets.UTF_8, StandardCharsets.UTF_8);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this.databaseProvider.setAutoCommit(this.miniSession, autoCommit);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            return this.databaseProvider.isAutoCommit(this.miniSession);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void commit() throws SQLException {
        try {
            this.databaseProvider.commit(this.miniSession);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            this.databaseProvider.rollback(this.miniSession);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            return new MiniJdbcSavepoint(this.databaseProvider.setSavepoint(this.miniSession));
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        try {
            this.databaseProvider.setSavepoint(this.miniSession, name);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return new MiniJdbcSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            if (((MiniJdbcSavepoint)savepoint).isNamed()) {
                this.databaseProvider.rollbackToSavepoint(this.miniSession, savepoint.getSavepointName());
            } else {
                this.databaseProvider.rollbackToSavepoint(this.miniSession, savepoint.getSavepointId());
            }
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            if (((MiniJdbcSavepoint)savepoint).isNamed()) {
                this.databaseProvider.releaseSavepoint(this.miniSession, savepoint.getSavepointName());
            } else {
                this.databaseProvider.releaseSavepoint(this.miniSession, savepoint.getSavepointId());
            }
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (level == -1) {
            return;
        }
        try {
            this.databaseProvider.setTransactionIsolationLevel(this.miniSession, Objects.requireNonNull(TRANSACTION_ISOLATION_LEVEL_MAP.get(level)));
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        TransactionIsolationLevel levelObject;
        try {
            levelObject = this.databaseProvider.getTransactionIsolationLevel(this.miniSession);
        }
        catch (Exception e2) {
            throw new SQLException(e2);
        }
        return TRANSACTION_ISOLATION_LEVEL_MAP.entrySet().stream().filter(e -> e.getValue() == levelObject).map(Map.Entry::getKey).findAny().get();
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return this.databaseProvider.isTransactionIsolationLevelSupported(this.miniSession, TRANSACTION_ISOLATION_LEVEL_MAP.get(level));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        Iterator<Statement> iterator = this.closeLock;
        synchronized (iterator) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        for (Statement activeStatement : this.activeStatements) {
            activeStatement.close();
        }
        try {
            this.miniSession.close();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        finally {
            this.runCloseCallbackSilently();
        }
    }

    private void runCloseCallbackSilently() {
        if (this.closeCallback == null) {
            return;
        }
        try {
            this.closeCallback.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        try {
            this.databaseProvider.checkSessionValid(this.miniSession);
        }
        catch (Exception e) {
            return false;
        }
        return !this.closed;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    static {
        TRANSACTION_ISOLATION_LEVEL_MAP.put(0, TransactionIsolationLevel.NONE);
        TRANSACTION_ISOLATION_LEVEL_MAP.put(1, TransactionIsolationLevel.READ_UNCOMMITTED);
        TRANSACTION_ISOLATION_LEVEL_MAP.put(2, TransactionIsolationLevel.READ_COMMITTED);
        TRANSACTION_ISOLATION_LEVEL_MAP.put(4, TransactionIsolationLevel.REPEATABLE_READ);
        TRANSACTION_ISOLATION_LEVEL_MAP.put(8, TransactionIsolationLevel.SERIALIZABLE);
    }
}

