/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.miniconnect.jdbc;

import hu.webarticum.miniconnect.api.MiniColumnHeader;
import hu.webarticum.miniconnect.api.MiniError;
import hu.webarticum.miniconnect.api.MiniResult;
import hu.webarticum.miniconnect.api.MiniResultSet;
import hu.webarticum.miniconnect.api.MiniValue;
import hu.webarticum.miniconnect.impl.result.StoredColumnHeader;
import hu.webarticum.miniconnect.impl.result.StoredResultSet;
import hu.webarticum.miniconnect.impl.result.StoredResultSetData;
import hu.webarticum.miniconnect.jdbc.MiniJdbcConnection;
import hu.webarticum.miniconnect.jdbc.MiniJdbcResultSet;
import hu.webarticum.miniconnect.lang.ImmutableList;
import hu.webarticum.miniconnect.record.translator.BigintTranslator;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.regex.Pattern;

public abstract class AbstractJdbcStatement
implements Statement {
    private static final Pattern INSERT_PATTERN = Pattern.compile("^\\s*INSERT\\b", 2);
    private final MiniJdbcConnection connection;
    private volatile boolean escapeProcessing = false;
    private volatile ResultHolder currentResultHolder = null;
    private volatile SQLWarning currentWarningHead = null;
    private volatile BigInteger lastInsertedId = null;

    AbstractJdbcStatement(MiniJdbcConnection connection) {
        this.connection = connection;
        connection.registerActiveStatement(this);
    }

    @Override
    public <T> T unwrap(Class<T> type) throws SQLException {
        if (!this.isWrapperFor(type)) {
            throw new SQLException(String.format("Unable to convert %s to %s", this.getClass(), type));
        }
        AbstractJdbcStatement result = this;
        return (T)result;
    }

    @Override
    public boolean isWrapperFor(Class<?> type) throws SQLException {
        return type != null && type.isAssignableFrom(this.getClass());
    }

    @Override
    public MiniJdbcConnection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.escapeProcessing = enable;
    }

    public boolean getEscapeProcessing() {
        return this.escapeProcessing;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return -1;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.currentWarningHead;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.currentWarningHead = null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.currentResultHolder != null ? this.currentResultHolder.jdbcResultSet : null;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw this.createForwardOnlyException();
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1003;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        ImmutableList rows;
        BigintTranslator bigintTranslator = BigintTranslator.instance();
        StoredColumnHeader columnHeader = new StoredColumnHeader("GENERATED_KEYS", false, bigintTranslator.definition());
        if (this.lastInsertedId != null) {
            MiniValue resultValue = bigintTranslator.encodeFully((Object)this.lastInsertedId);
            rows = ImmutableList.of((Object[])new ImmutableList[]{ImmutableList.of((Object[])new MiniValue[]{resultValue})});
        } else {
            rows = ImmutableList.empty();
        }
        StoredResultSetData data = new StoredResultSetData(ImmutableList.of((Object[])new MiniColumnHeader[]{columnHeader}), rows);
        return new MiniJdbcResultSet(this, (MiniResultSet)new StoredResultSet(data));
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    protected void handleExecuteCompleted(String sql, ResultHolder resultHolder) {
        this.currentResultHolder = resultHolder;
        this.currentWarningHead = this.wrapWarnings((ImmutableList<MiniError>)resultHolder.result.warnings());
        this.connection.setCurrentWarningHead(this.currentWarningHead);
        this.lastInsertedId = INSERT_PATTERN.matcher(sql).find() ? this.connection.getDatabaseProvider().getLastInsertedId(this.connection.getMiniSession()) : null;
    }

    private SQLWarning wrapWarnings(ImmutableList<MiniError> miniWarnings) {
        SQLWarning headWarning;
        if (miniWarnings.isEmpty()) {
            return null;
        }
        SQLWarning parentWarning = headWarning = this.wrapWarning((MiniError)miniWarnings.get(0));
        int length = miniWarnings.size();
        for (int i = 1; i < length; ++i) {
            SQLWarning childWarning = this.wrapWarning((MiniError)miniWarnings.get(i));
            parentWarning.setNextException(childWarning);
            parentWarning = childWarning;
        }
        return headWarning;
    }

    private SQLWarning wrapWarning(MiniError miniWarning) {
        return new SQLWarning(miniWarning.message(), miniWarning.sqlState(), miniWarning.code());
    }

    private SQLException createForwardOnlyException() {
        return new SQLException("This result set is FORWARD_ONLY");
    }

    protected static class ResultHolder {
        protected final MiniResult result;
        protected final MiniJdbcResultSet jdbcResultSet;

        protected ResultHolder(MiniResult result, MiniJdbcResultSet jdbcResultSet) {
            this.result = result;
            this.jdbcResultSet = jdbcResultSet;
        }
    }
}

