/*
 * Decompiled with CFR 0.152.
 */
package hr.fer.grading;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class NetworkInterfaceWrapper {
    private NetworkInterface ni;

    public NetworkInterfaceWrapper(NetworkInterface ni) {
        this.ni = ni;
    }

    public String getName() {
        return this.ni.getName();
    }

    public String getDisplayName() {
        return this.ni.getDisplayName();
    }

    public Stream<InetAddress> getInetAddresses() {
        Iterator<InetAddress> iterator = this.ni.getInetAddresses().asIterator();
        Spliterator<InetAddress> spliterator = Spliterators.spliteratorUnknownSize(iterator, 16);
        return StreamSupport.stream(spliterator, false);
    }

    public List<Integer> getMacAddress() throws SocketException {
        byte[] mac = this.ni.getHardwareAddress();
        if (mac == null) {
            return null;
        }
        LinkedList<Integer> list = new LinkedList<Integer>();
        for (byte b : mac) {
            list.add(Byte.toUnsignedInt(b));
        }
        return list;
    }

    public boolean isUp() throws SocketException {
        return this.ni.isUp();
    }

    public boolean isVirtual() {
        return this.ni.isVirtual();
    }
}

