/*
 * Decompiled with CFR 0.152.
 */
package hr.fer.grading;

import hr.fer.grading.NetworkInterfaceWrapper;
import java.io.PrintWriter;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NetworkInterfacePrinter {
    private PrintWriter writer;
    private Stream<NetworkInterfaceWrapper> interfaces;

    public NetworkInterfacePrinter(PrintWriter writer) throws SocketException {
        this(writer, NetworkInterface.networkInterfaces().map(NetworkInterfaceWrapper::new));
    }

    public NetworkInterfacePrinter(PrintWriter writer, Stream<NetworkInterfaceWrapper> interfaces) {
        this.writer = writer;
        this.interfaces = interfaces;
    }

    public void print() throws SocketException {
        this.interfaces.forEach(this::print);
    }

    private void print(NetworkInterfaceWrapper ni) {
        this.writer.print("Name: ");
        this.writer.println(ni.getName());
        this.writer.print("DisplayName: ");
        this.writer.println(ni.getDisplayName());
        this.printInetAddresses(ni);
        this.printMacAddres(ni);
        this.printStatus(ni);
        this.printVirtual(ni);
        this.writer.println();
    }

    private void printVirtual(NetworkInterfaceWrapper ni) {
        this.writer.print("Virtual: ");
        this.writer.println(ni.isVirtual());
    }

    private void printStatus(NetworkInterfaceWrapper ni) {
        this.writer.print("Status: ");
        try {
            this.writer.println(ni.isUp() ? "active" : "inactive");
        }
        catch (SocketException e) {
            this.writer.println("unknown");
        }
    }

    private void printMacAddres(NetworkInterfaceWrapper ni) {
        this.writer.print("MAC: ");
        try {
            List<Integer> mac = ni.getMacAddress();
            if (mac != null) {
                this.writer.print(mac.stream().map(macPart -> String.format("%02x", macPart)).collect(Collectors.joining(":")));
                this.writer.println();
            } else {
                this.writer.println("null");
            }
        }
        catch (SocketException e) {
            this.writer.println("unknown - exception: " + e.getMessage());
        }
    }

    private void printInetAddresses(NetworkInterfaceWrapper ni) {
        this.writer.println("InetAddresses:");
        ni.getInetAddresses().forEach(addr -> {
            this.writer.print("  ");
            this.writer.println(addr.getHostAddress());
        });
    }
}

