/*
 * Decompiled with CFR 0.152.
 */
package hr.fer.grading;

import java.lang.reflect.Method;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.FilterComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradingRunner {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public static void main(String[] args) throws Exception {
        GradingRunner.configureLogging();
        Locale.setDefault(Locale.US);
        new GradingRunner().run(args);
    }

    private void run(String[] args) throws Exception {
        this.log.debug("Arguments: {}", (Object)args);
        this.runGrading(args);
        System.exit(0);
    }

    private void runGrading(String[] args) throws Exception {
        Class<?> junitRunnerClass = this.getClass().getClassLoader().loadClass("hr.fer.junit.grading.command_line.CommandLineRunner");
        Method mainMethod = junitRunnerClass.getMethod("main", String[].class);
        mainMethod.invoke(junitRunnerClass, new Object[]{args});
    }

    private static void configureLogging() {
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.setStatusLevel(Level.ERROR);
        builder.setConfigurationName("BuilderTest");
        builder.add((FilterComponentBuilder)builder.newFilter("ThresholdFilter", Filter.Result.ACCEPT, Filter.Result.NEUTRAL).addAttribute("level", Level.DEBUG));
        AppenderComponentBuilder appenderBuilder = (AppenderComponentBuilder)builder.newAppender("Stdout", "CONSOLE").addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_ERR);
        appenderBuilder.add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "%d [%t] %-5level: %msg%n%throwable"));
        appenderBuilder.add((FilterComponentBuilder)builder.newFilter("MarkerFilter", Filter.Result.DENY, Filter.Result.NEUTRAL).addAttribute("marker", "FLOW"));
        builder.add(appenderBuilder);
        builder.add((LoggerComponentBuilder)((LoggerComponentBuilder)builder.newLogger("org.apache.logging.log4j", Level.DEBUG).add(builder.newAppenderRef("Stdout"))).addAttribute("additivity", false));
        builder.add((RootLoggerComponentBuilder)builder.newRootLogger(Level.ERROR).add(builder.newAppenderRef("Stdout")));
        Configurator.initialize((Configuration)((Configuration)builder.build()));
    }
}

