/*
 * Decompiled with CFR 0.152.
 */
package hr.fer.grading;

import hr.fer.grading.GradingExtension;
import hr.fer.grading.NetworkInterfacePrinter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.WriterOutputStream;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.bundling.Zip;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradingPlugin
implements Plugin<Project> {
    private static final String JUNIT_GRADING = "hr.fer.grading:junit-grading:";
    private static final String LOGGING = "org.apache.logging.log4j:log4j-slf4j-impl:2.17.1";
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public void apply(Project project) {
        GradingExtension extension = this.initializeExtension(project);
        this.configureDependencies(project);
        this.registerTasks(project, extension);
    }

    private GradingExtension initializeExtension(Project project) {
        GradingExtension extension = (GradingExtension)project.getExtensions().create("grading", GradingExtension.class, new Object[0]);
        extension.getSolutionPrefix().set((Object)"solution");
        return extension;
    }

    private void registerTasks(final Project project, GradingExtension extension) {
        project.getTasks().register("grade", JavaExec.class, task -> {
            task.setGroup("grading");
            task.dependsOn(new Object[]{"testClasses"});
            this.initializeJavaPlugin(project);
            task.setClasspath(this.findTestClasspath(project));
            task.getMainClass().set((Object)"hr.fer.grading.GradingRunner");
            task.setArgs(this.createArgs());
            task.getLogging().captureStandardError(LogLevel.DEBUG);
            StringWriter sw = new StringWriter();
            task.setStandardOutput((OutputStream)new WriterOutputStream((Writer)sw, StandardCharsets.UTF_8));
            task.doLast(t -> {
                System.out.println(sw.toString());
                Path resultPath = project.getBuildDir().toPath().resolve("gradingResult.txt");
                try {
                    if (Files.exists(resultPath, new LinkOption[0])) {
                        Files.delete(resultPath);
                    }
                    if (!Files.exists(resultPath.getParent(), new LinkOption[0])) {
                        Files.createDirectories(resultPath.getParent(), new FileAttribute[0]);
                    }
                    Files.writeString(resultPath, (CharSequence)sw.toString(), StandardCharsets.UTF_8, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException("Can not create result file.", e);
                }
            });
        });
        project.getTasks().register("createSubmission", Zip.class, task -> {
            task.setGroup("grading");
            task.getArchiveFileName().set((Object)((String)extension.getSolutionPrefix().get() + "_" + project.getName() + ".zip"));
            task.getDestinationDirectory().set(project.getBuildDir().toPath().resolve("submission").toFile());
            task.from(new Object[]{project.fileTree((Object)project.getProjectDir()).exclude(new String[]{project.getBuildDir().getName() + "/**"}).exclude(new String[]{"bin/**"}).exclude(new String[]{".gradle/**"})});
            task.doFirst((Action)new Action<Task>(){

                public void execute(Task zipTask) {
                    GradingPlugin.this.createSubmissionTelemetryDirectory(project);
                }
            });
            task.doLast((Action)new Action<Task>(){

                public void execute(Task zipTask) {
                    GradingPlugin.this.deleteSubmissionTelemetryDirectory(project);
                }
            });
        });
    }

    private void deleteSubmissionTelemetryDirectory(Project project) {
        try {
            FileUtils.deleteDirectory((File)new File(project.getProjectDir(), "submissionTelemetry"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createSubmissionTelemetryDirectory(Project project) {
        try {
            File telemetryDirectory = new File(project.getProjectDir(), "submissionTelemetry");
            File netInterfaces = new File(telemetryDirectory, "networkInterfaces.txt");
            FileUtils.createParentDirectories((File)netInterfaces);
            try (PrintWriter pw = new PrintWriter(netInterfaces);){
                this.printNetworkTelemetry(pw);
            }
            File gradingSourceFile = new File(project.getBuildDir(), "gradingResult.txt");
            if (gradingSourceFile.exists()) {
                FileUtils.copyFile((File)gradingSourceFile, (File)new File(telemetryDirectory, "gradingResult.txt"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printNetworkTelemetry(PrintWriter pw) {
        try {
            NetworkInterfacePrinter printer = new NetworkInterfacePrinter(pw);
            printer.print();
        }
        catch (SocketException se) {
            se.printStackTrace(pw);
        }
    }

    private List<String> createArgs() {
        return List.of("-tg", "all", "-p", "hr");
    }

    private FileCollection findTestClasspath(Project project) {
        JavaPluginExtension javaExtension = (JavaPluginExtension)project.getExtensions().findByType(JavaPluginExtension.class);
        SourceSetContainer sourceSets = javaExtension.getSourceSets();
        SourceSet testSet = (SourceSet)sourceSets.findByName("test");
        FileCollection testClassPath = testSet.getRuntimeClasspath();
        if (this.log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("***Classpath:\n");
            testClassPath.forEach(file -> {
                sb.append(" - ");
                sb.append(file);
                sb.append("\n");
            });
            this.log.debug(sb.toString());
        }
        return testClassPath;
    }

    private void configureDependencies(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Configurations:");
            configurations.forEach(c -> this.log.debug(" - {}", c));
        }
        Configuration testConfiguration = (Configuration)configurations.findByName("testImplementation");
        testConfiguration.getDependencies().add((Object)project.getDependencies().create((Object)"hr.fer.grading:junit-grading:0.13.0"));
        testConfiguration.getDependencies().add((Object)project.getDependencies().create((Object)"hr.fer.grading:grading:0.13.0"));
        testConfiguration.getDependencies().add((Object)project.getDependencies().create((Object)LOGGING));
    }

    private void initializeJavaPlugin(Project project) {
        PluginManager pluginManager = project.getPluginManager();
        if (!pluginManager.hasPlugin("java")) {
            pluginManager.apply("java");
        }
    }
}

