/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.spg.processor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.noties.spg.processor.util.TextUtils;

public class StringParser {
    private static final Pattern PATTERN = Pattern.compile("(\\$\\{\\s*)(.+)(\\s*\\})");
    static final char[] ILLEGAL_CHARS = new char[]{';', '\n', ','};

    private StringParser() {
    }

    public static boolean isEvaluationString(String in) {
        if (TextUtils.isEmpty(in)) {
            return false;
        }
        Matcher matcher = PATTERN.matcher(in);
        if (!matcher.matches()) {
            return false;
        }
        in = matcher.group(2);
        char[] chars = in.toCharArray();
        int i = chars.length;
        while (--i >= 0) {
            int c = ILLEGAL_CHARS.length;
            while (--c >= 0) {
                if (chars[i] != ILLEGAL_CHARS[c]) continue;
                throw new IllegalStateException("Found illegal char: `" + ILLEGAL_CHARS[c] + "` at position: " + i + " in text: " + in);
            }
        }
        return true;
    }

    public static String extractEvaluation(String in) {
        Matcher matcher = PATTERN.matcher(in);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return null;
    }
}

