/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.spg.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import ru.noties.spg.anno.SPGPreference;
import ru.noties.spg.processor.Logger;
import ru.noties.spg.processor.data.PreferenceHolder;
import ru.noties.spg.processor.data.SPGPreferenceParser;
import ru.noties.spg.processor.writer.SPGPreferenceWriter;

public class SPGProcessor
extends AbstractProcessor
implements Logger {
    private Types mTypes;
    private Elements mElements;
    private Filer mFiler;
    private Messager mMessager;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(SPGPreference.class.getCanonicalName());
    }

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        this.mTypes = env.getTypeUtils();
        this.mElements = env.getElementUtils();
        this.mFiler = env.getFiler();
        this.mMessager = env.getMessager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean bl;
        long start = -1L;
        try {
            for (TypeElement typeElement : annotations) {
                if (start == -1L) {
                    start = System.currentTimeMillis();
                }
                this.processInner(roundEnv.getElementsAnnotatedWith(typeElement));
            }
            bl = true;
            if (start == -1L) return bl;
        }
        catch (Throwable t) {
            try {
                t.printStackTrace();
                this.log(Diagnostic.Kind.ERROR, "Exception during code generation: " + t, new Object[0]);
                if (start == -1L) return false;
            }
            catch (Throwable throwable) {
                if (start == -1L) throw throwable;
                long end = System.currentTimeMillis();
                this.log(Diagnostic.Kind.NOTE, "Processing of @SPGPreference took: %d ms", end - start);
                throw throwable;
            }
            long end = System.currentTimeMillis();
            this.log(Diagnostic.Kind.NOTE, "Processing of @SPGPreference took: %d ms", end - start);
            return false;
        }
        long l = System.currentTimeMillis();
        this.log(Diagnostic.Kind.NOTE, "Processing of @SPGPreference took: %d ms", l - start);
        return bl;
    }

    private boolean processInner(Set<? extends Element> preferences) throws Throwable {
        ArrayList<PreferenceHolder> list = new ArrayList<PreferenceHolder>();
        SPGPreferenceParser parser = new SPGPreferenceParser(this, this.mTypes, this.mElements);
        for (Element element : preferences) {
            PreferenceHolder holder = parser.parse((TypeElement)element);
            if (holder == null) continue;
            list.add(holder);
        }
        if (list.size() > 0) {
            SPGPreferenceWriter writer = new SPGPreferenceWriter(this, this.mElements, this.mFiler);
            for (PreferenceHolder ph : list) {
                writer.write(ph);
            }
        }
        return true;
    }

    @Override
    public void log(Diagnostic.Kind level, String message, Object ... args) {
        if (args != null && args.length > 0) {
            this.mMessager.printMessage(level, String.format(message, args));
            return;
        }
        this.mMessager.printMessage(level, message);
    }
}

