/*
 * Decompiled with CFR 0.152.
 */
package hk.ids.gws.android.sclick;

import android.os.SystemClock;
import hk.ids.gws.android.sclick.helper.SafeClick;
import java.util.concurrent.ConcurrentHashMap;

public class SClick {
    public static final String BUTTON_CLICK = "sclick:button-click";
    public static final String REFRESH_CLICK = "sclick:refresh-click";
    public static final String NAVIGATION_CLICK = "sclick:navigation-click";
    private static ConcurrentHashMap<String, Long> mHashMap = new ConcurrentHashMap();

    public static boolean check(String tag) {
        return SClick.check(tag, SafeClick.getDefault().interval());
    }

    public static boolean check(String tag, int intervalMs) {
        boolean result = false;
        Long current = SystemClock.elapsedRealtime();
        Long last = mHashMap.get(tag);
        if (last != null) {
            if (last != -1L && current - last >= (long)intervalMs) {
                result = true;
            }
        } else {
            result = true;
        }
        if (result) {
            mHashMap.put(tag, current);
        }
        return result;
    }

    public static boolean checkAndLock(String tag) {
        return SClick.checkAndLock(tag, SafeClick.getDefault().interval());
    }

    public static boolean checkAndLock(String tag, int interval) {
        boolean result = SClick.check(tag, interval);
        if (result) {
            mHashMap.put(tag, -1L);
        }
        return result;
    }

    public static void lock(String tag) {
        mHashMap.put(tag, -1L);
    }

    public static void unlock(String tag) {
        Long last = mHashMap.get(tag);
        if (last != null && last == -1L) {
            mHashMap.remove(tag);
        }
    }

    public static void forceUnlock(String tag) {
        mHashMap.remove(tag);
    }
}

