/*
 * Decompiled with CFR 0.152.
 */
package hk.ids.gws.android.afragment.ui.fragmentmanage;

import android.annotation.SuppressLint;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.os.Bundle;
import android.support.annotation.AnimatorRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import hk.ids.gws.android.afragment.R;
import hk.ids.gws.android.afragment.helper.AnotherFragment;
import hk.ids.gws.android.afragment.ui.activity.IRootActivity;
import hk.ids.gws.android.afragment.ui.fragment.IRootFragment;
import hk.ids.gws.android.afragment.ui.fragmentmanage.ContainerInfo;
import hk.ids.gws.android.afragment.utils.LogUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class FragmentStore {
    protected final String INTERNALTAG = "AnotherFragment:" + this.getClass().getSimpleName();
    private static final String BUNDLE_TAG_FRAGMENT_TAG = "afragment:fragment.tag";
    private static final String BUNDLE_TAG_FRAGMENT_VISIBILITY = "afragment:fragment.visibility";
    private static final String BUNDLE_TAG_TAGMAP = "afragment:tagmap";
    private static final String BUNDLE_TAG_VISIBILITYMAP = "afragment:visibilitymap";
    private static final String BUNDLE_TAG_STACKS = "afragment:stacks";
    private final Object mLock = new Object();
    private IRootActivity mActivity;
    private HashMap<String, String> mTagMap = new HashMap();
    private HashMap<String, Boolean> mVisibilityMap = new HashMap();
    private SparseArray<ContainerInfo> mStacks = new SparseArray();
    private HashMap<String, Object> mFragmentInstances = new HashMap();

    public <T extends Fragment> FragmentStore(@NonNull IRootActivity activity, @Nullable Bundle savedInstanceState) {
        this.mActivity = activity;
        if (savedInstanceState != null) {
            Serializable tagMapSerializable = savedInstanceState.getSerializable(BUNDLE_TAG_TAGMAP);
            Serializable visibilityMapSerializable = savedInstanceState.getSerializable(BUNDLE_TAG_VISIBILITYMAP);
            SparseArray sparseArray = savedInstanceState.getSparseParcelableArray(BUNDLE_TAG_STACKS);
            if (tagMapSerializable != null) {
                this.mTagMap = (HashMap)tagMapSerializable;
                LogUtil.i(this.INTERNALTAG, "FragmentStore create from saved state, mTagMap restored");
            }
            if (visibilityMapSerializable != null) {
                this.mVisibilityMap = (HashMap)visibilityMapSerializable;
                LogUtil.i(this.INTERNALTAG, "FragmentStore create from saved state, mVisibilityMap restored");
            }
            if (sparseArray != null) {
                this.mStacks = sparseArray;
                LogUtil.i(this.INTERNALTAG, "FragmentStore create from saved state, mStacks restored");
            }
            ArrayList<String> tags = new ArrayList<String>();
            for (int i = 0; i < this.mStacks.size(); ++i) {
                ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(this.mStacks.keyAt(i));
                tags.addAll(containerInfo.fragmentTags);
            }
            for (String tag : tags) {
                Fragment fragment = this.getFragmentManager().findFragmentByTag(tag);
                if (fragment == null || !(fragment instanceof IRootFragment)) continue;
                this.mFragmentInstances.put(tag, fragment);
                if (!this.getVisibility(fragment)) {
                    this.hide(fragment);
                }
                LogUtil.i(this.INTERNALTAG, String.format("FragmentStore restored an instance. Tag: %s, Fragment: %s", tag, fragment.getClass().getSimpleName()));
            }
        }
    }

    public Bundle getInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putSerializable(BUNDLE_TAG_TAGMAP, this.mTagMap);
        bundle.putSerializable(BUNDLE_TAG_VISIBILITYMAP, this.mVisibilityMap);
        bundle.putSparseParcelableArray(BUNDLE_TAG_STACKS, this.mStacks);
        return bundle;
    }

    private FragmentManager getFragmentManager() {
        return this.mActivity.getFragmentManager();
    }

    @Nullable
    private String getTopFragmentTag(int containerId) {
        return this.getTopNFragmentTag(containerId, 0);
    }

    @Nullable
    private String getTopNFragmentTag(int containerId, int n) {
        ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
        if (containerInfo == null || containerInfo.fragmentTags.size() <= n) {
            return null;
        }
        return containerInfo.fragmentTags.get(containerInfo.fragmentTags.size() - n - 1);
    }

    @Nullable
    private <T extends Fragment> T getFragmentByTag(String internalTag) {
        return (T)((Fragment)this.mFragmentInstances.get(internalTag));
    }

    @NonNull
    private <T extends Fragment> String assignTag(T fragment) {
        String uuid = this.getTag(fragment);
        if (uuid == null) {
            uuid = UUID.randomUUID().toString();
            Bundle bundle = fragment.getArguments();
            if (bundle == null) {
                bundle = new Bundle();
            }
            bundle.putString(BUNDLE_TAG_FRAGMENT_TAG, uuid);
            fragment.setArguments(bundle);
            LogUtil.i(this.INTERNALTAG, String.format(Locale.getDefault(), "Assigned new tag to fragment. Fragment: %s, Tag: %s", fragment.getClass().getSimpleName(), uuid));
        }
        return uuid;
    }

    @Nullable
    private String getTag(Fragment fragment) {
        Bundle bundle = fragment.getArguments();
        if (bundle != null) {
            return bundle.getString(BUNDLE_TAG_FRAGMENT_TAG);
        }
        return null;
    }

    private boolean getVisibility(Fragment fragment) {
        String tag = this.getTag(fragment);
        return tag == null || this.mVisibilityMap.get(tag) == null || this.mVisibilityMap.get(tag) != false;
    }

    private void setVisibility(Fragment fragment, boolean visibility) {
        String tag = this.getTag(fragment);
        if (tag == null) {
            return;
        }
        this.mVisibilityMap.put(tag, visibility);
    }

    @SuppressLint(value={"CommitTransaction"})
    private <T extends Fragment> List<FragmentTransaction> getFlushTransactions(int containerId, int overrideAnimation) {
        ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
        if (containerInfo != null && containerInfo.fragmentTags.size() > 0) {
            ArrayList<T> pending = new ArrayList<T>();
            for (int i = 0; i < containerInfo.fragmentTags.size(); ++i) {
                T fragment = this.getFragmentByTag(containerInfo.fragmentTags.get(i));
                if (fragment == null) continue;
                pending.add(fragment);
            }
            FragmentTransaction aniTransaction = null;
            FragmentTransaction nonaniTransaction = null;
            for (int i = 0; i < pending.size(); ++i) {
                Fragment fragment = (Fragment)pending.get(i);
                if (i == pending.size() - 1) {
                    if (aniTransaction == null) {
                        aniTransaction = this.getFragmentManager().beginTransaction();
                        if (((IRootFragment)fragment).getEnterAnimation() != -1 && ((IRootFragment)fragment).getExitAnimation() != -1 || overrideAnimation != -1) {
                            aniTransaction.setCustomAnimations(((IRootFragment)fragment).getEnterAnimation(), overrideAnimation == -1 ? ((IRootFragment)fragment).getExitAnimation() : overrideAnimation);
                        }
                    }
                    aniTransaction.remove(fragment);
                    continue;
                }
                if (nonaniTransaction == null) {
                    nonaniTransaction = this.getFragmentManager().beginTransaction();
                    nonaniTransaction.setCustomAnimations(R.animator.animator_fragment_no_ani, R.animator.animator_fragment_no_ani);
                }
                nonaniTransaction.remove(fragment);
            }
            ArrayList<FragmentTransaction> fragmentTransactions = new ArrayList<FragmentTransaction>();
            if (nonaniTransaction != null) {
                fragmentTransactions.add(nonaniTransaction);
            }
            if (aniTransaction != null) {
                fragmentTransactions.add(aniTransaction);
            }
            return fragmentTransactions;
        }
        return null;
    }

    private <T extends Fragment> void notifyTopmost(int containerId) {
        if (!AnotherFragment.getDefault().isNotifyTopmost()) {
            return;
        }
        ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
        if (containerInfo != null && containerInfo.fragmentTags.size() >= 0) {
            boolean foundVisible = false;
            for (int i = 0; i < containerInfo.fragmentTags.size(); ++i) {
                T fragment = this.getFragmentByTag(containerInfo.fragmentTags.get(i));
                if (fragment == null) {
                    LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "Unexpected behaviour: getFragmentByTag return null. Index: %d, Container: %d", i, containerId));
                    continue;
                }
                if (!foundVisible && !fragment.isHidden()) {
                    foundVisible = true;
                    ((IRootFragment)fragment).onTopmostChanged(true);
                    continue;
                }
                ((IRootFragment)fragment).onTopmostChanged(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeAppendTransaction(int containerId, IRootFragment fragment, String tag) {
        Object object = this.mLock;
        synchronized (object) {
            ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
            if (containerInfo == null) {
                containerInfo = new ContainerInfo();
            }
            containerInfo.fragmentTags.add(tag);
            this.mStacks.put(containerId, (Object)containerInfo);
            this.mFragmentInstances.put(tag, fragment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeReplaceTransaction(int containerId, IRootFragment fragment, String tag) {
        Object object = this.mLock;
        synchronized (object) {
            ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
            if (containerInfo != null) {
                for (String current : containerInfo.fragmentTags) {
                    this.mFragmentInstances.remove(current);
                }
            }
            containerInfo = new ContainerInfo();
            containerInfo.fragmentTags.add(tag);
            this.mStacks.put(containerId, (Object)containerInfo);
            this.mFragmentInstances.put(tag, fragment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeRemoveTransaction(int containerId, String tag) {
        Object object = this.mLock;
        synchronized (object) {
            ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
            if (containerInfo == null) {
                containerInfo = new ContainerInfo();
            }
            containerInfo.fragmentTags.remove(tag);
            this.mStacks.put(containerId, (Object)containerInfo);
            this.mFragmentInstances.remove(tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeFlushTransaction(int containerId) {
        Object object = this.mLock;
        synchronized (object) {
            ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
            if (containerInfo != null) {
                for (String current : containerInfo.fragmentTags) {
                    this.mFragmentInstances.remove(current);
                }
            }
            containerInfo = new ContainerInfo();
            this.mStacks.put(containerId, (Object)containerInfo);
        }
    }

    public int getCount(int containerId) {
        ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
        return containerInfo == null ? 0 : containerInfo.fragmentTags.size();
    }

    public boolean isEmpty(int containerId) {
        ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
        return containerInfo == null || containerInfo.fragmentTags.size() == 0;
    }

    public <T extends Fragment> boolean isExist(int containerId, T fragment) {
        ContainerInfo containerInfo;
        String tag = this.getTag(fragment);
        return tag != null && (containerInfo = (ContainerInfo)this.mStacks.get(containerId)) != null && containerInfo.fragmentTags.contains(tag);
    }

    @Nullable
    public <T extends Fragment> T getTopFragment(int containerId) {
        return this.getTopNFragment(containerId, 0);
    }

    @Nullable
    public <T extends Fragment> T getTopNFragment(int containerId, int n) {
        String internalTag = this.getTopNFragmentTag(containerId, n);
        if (internalTag == null) {
            return null;
        }
        return (T)((Fragment)this.mFragmentInstances.get(internalTag));
    }

    @Nullable
    public <T extends Fragment> T findFragmentByTag(String tag) {
        String internalTag = this.mTagMap.get(tag);
        if (internalTag == null) {
            return null;
        }
        return (T)((Fragment)this.mFragmentInstances.get(internalTag));
    }

    public void flush(int containerId) {
        this.flush(containerId, -1);
    }

    public void flush(int containerId, int overrideAnimation) {
        List<FragmentTransaction> fragmentTransactions = this.getFlushTransactions(containerId, overrideAnimation);
        if (fragmentTransactions != null && fragmentTransactions.size() > 0) {
            try {
                for (FragmentTransaction fragmentTransaction : fragmentTransactions) {
                    fragmentTransaction.commit();
                }
                this.completeFlushTransaction(containerId);
                this.mActivity.onContainerChange(containerId);
            }
            catch (IllegalStateException e) {
                if (AnotherFragment.getDefault().isThrowStateLost()) {
                    throw e;
                }
                LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "IllegalStateException detected, it may due to state lost. Exception: %s", e.toString()));
            }
        }
    }

    public boolean back(int containerId) {
        return this.back(containerId, false, -1);
    }

    public boolean back(int containerId, boolean allowEmpty) {
        return this.back(containerId, allowEmpty, -1);
    }

    public <T extends Fragment> boolean back(int containerId, boolean allowEmpty, @AnimatorRes int overrideAnimation) {
        int count = this.getCount(containerId);
        if (count > (allowEmpty ? 0 : 1)) {
            String tag = this.getTopFragmentTag(containerId);
            if (tag != null) {
                T fragment = this.getFragmentByTag(tag);
                if (fragment != null && ((IRootFragment)fragment).canBack()) {
                    if (((IRootFragment)fragment).onBackPressed()) {
                        return true;
                    }
                    FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
                    if (((IRootFragment)fragment).getEnterAnimation() != -1 && ((IRootFragment)fragment).getExitAnimation() != -1 || overrideAnimation != -1) {
                        fragmentTransaction.setCustomAnimations(((IRootFragment)fragment).getEnterAnimation(), overrideAnimation == -1 ? ((IRootFragment)fragment).getExitAnimation() : overrideAnimation);
                    }
                    fragmentTransaction.remove(fragment);
                    try {
                        fragmentTransaction.commit();
                        this.completeRemoveTransaction(containerId, tag);
                        this.notifyTopmost(containerId);
                        if (count == 1) {
                            this.mActivity.onContainerEmpty(containerId);
                        }
                        this.mActivity.onContainerChange(containerId);
                        return true;
                    }
                    catch (IllegalStateException e) {
                        if (AnotherFragment.getDefault().isThrowStateLost()) {
                            throw e;
                        }
                        LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "IllegalStateException detected, it may due to state lost. Exception: %s", e.toString()));
                    }
                }
            } else {
                LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "Unexpected behaviour: getTopFragmentTag return null. Container: %d", containerId));
            }
        } else {
            LogUtil.i(this.INTERNALTAG, String.format(Locale.getDefault(), "Unable to back any more. Container: %d", containerId));
        }
        return false;
    }

    public <T extends Fragment> void add(int containerId, T fragment) {
        this.add(containerId, fragment, null);
    }

    public <T extends Fragment> void add(int containerId, T fragment, String tag) {
        this.add(containerId, fragment, false, tag);
    }

    public <T extends Fragment> void add(int containerId, T fragment, boolean hide) {
        this.add(containerId, fragment, hide, null);
    }

    public <T extends Fragment> void add(int containerId, T fragment, boolean hide, String tag) {
        String internalTag = this.assignTag(fragment);
        if (tag != null) {
            this.mTagMap.put(tag, internalTag);
        }
        FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
        if (((IRootFragment)fragment).getEnterAnimation() != -1 && ((IRootFragment)fragment).getExitAnimation() != -1) {
            fragmentTransaction.setCustomAnimations(((IRootFragment)fragment).getEnterAnimation(), ((IRootFragment)fragment).getExitAnimation());
        }
        fragmentTransaction.add(containerId, fragment, internalTag);
        if (hide) {
            fragmentTransaction.hide(fragment);
        }
        try {
            fragmentTransaction.commit();
            this.completeAppendTransaction(containerId, (IRootFragment)fragment, internalTag);
            if (hide) {
                this.notifyTopmost(containerId);
            }
            this.setVisibility(fragment, !hide);
            this.mActivity.onContainerChange(containerId);
        }
        catch (IllegalStateException e) {
            if (AnotherFragment.getDefault().isThrowStateLost()) {
                throw e;
            }
            LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "IllegalStateException detected, it may due to state lost. Exception: %s", e.toString()));
        }
    }

    public <T extends Fragment> void replace(int containerId, T fragment) {
        this.replace(containerId, fragment, null);
    }

    public <T extends Fragment> void replace(int containerId, T fragment, String tag) {
        String internalTag = this.assignTag(fragment);
        if (tag != null) {
            this.mTagMap.put(tag, internalTag);
        }
        List<FragmentTransaction> fragmentTransactions = this.getFlushTransactions(containerId, -1);
        FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
        if (((IRootFragment)fragment).getEnterAnimation() != -1 && ((IRootFragment)fragment).getExitAnimation() != -1) {
            fragmentTransaction.setCustomAnimations(((IRootFragment)fragment).getEnterAnimation(), ((IRootFragment)fragment).getExitAnimation());
        }
        fragmentTransaction.add(containerId, fragment, internalTag);
        try {
            fragmentTransaction.commit();
            if (fragmentTransactions != null) {
                for (FragmentTransaction removeTransaction : fragmentTransactions) {
                    removeTransaction.commit();
                }
            }
            this.completeReplaceTransaction(containerId, (IRootFragment)fragment, internalTag);
            this.notifyTopmost(containerId);
            this.mActivity.onContainerChange(containerId);
        }
        catch (IllegalStateException e) {
            if (AnotherFragment.getDefault().isThrowStateLost()) {
                throw e;
            }
            LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "IllegalStateException detected, it may due to state lost. Exception: %s", e.toString()));
        }
    }

    public <T extends Fragment> void show(T fragment) {
        String tag = this.getTag(fragment);
        if (tag == null) {
            return;
        }
        Integer containerId = null;
        for (int i = 0; i < this.mStacks.size(); ++i) {
            int key = this.mStacks.keyAt(i);
            ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(key);
            if (!containerInfo.fragmentTags.contains(tag)) continue;
            containerId = key;
            break;
        }
        if (containerId == null) {
            return;
        }
        FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
        fragmentTransaction.show(fragment);
        try {
            fragmentTransaction.commit();
            this.setVisibility(fragment, true);
            this.notifyTopmost(containerId);
        }
        catch (IllegalStateException e) {
            if (AnotherFragment.getDefault().isThrowStateLost()) {
                throw e;
            }
            LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "IllegalStateException detected, it may due to state lost. Exception: %s", e.toString()));
        }
    }

    public <T extends Fragment> void hide(T fragment) {
        String tag = this.getTag(fragment);
        if (tag == null) {
            return;
        }
        Integer containerId = null;
        for (int i = 0; i < this.mStacks.size(); ++i) {
            int key = this.mStacks.keyAt(i);
            ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(key);
            if (!containerInfo.fragmentTags.contains(tag)) continue;
            containerId = key;
            break;
        }
        if (containerId == null) {
            return;
        }
        FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
        fragmentTransaction.hide(fragment);
        try {
            fragmentTransaction.commit();
            this.setVisibility(fragment, false);
            this.notifyTopmost(containerId);
        }
        catch (IllegalStateException e) {
            if (AnotherFragment.getDefault().isThrowStateLost()) {
                throw e;
            }
            LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "IllegalStateException detected, it may due to state lost. Exception: %s", e.toString()));
        }
    }

    public <T extends Fragment> boolean remove(int containerId, T fragment) {
        return this.remove(containerId, fragment, -1);
    }

    public <T extends Fragment> boolean remove(int containerId, T fragment, int overrideAnimation) {
        String internalTag = this.getTag(fragment);
        if (internalTag != null) {
            ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
            if (containerInfo != null && containerInfo.fragmentTags.contains(internalTag)) {
                FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
                if (((IRootFragment)fragment).getEnterAnimation() != -1 && ((IRootFragment)fragment).getExitAnimation() != -1 || overrideAnimation != -1) {
                    fragmentTransaction.setCustomAnimations(((IRootFragment)fragment).getEnterAnimation(), overrideAnimation == -1 ? ((IRootFragment)fragment).getExitAnimation() : overrideAnimation);
                }
                fragmentTransaction.remove(fragment);
                try {
                    fragmentTransaction.commit();
                    this.completeRemoveTransaction(containerId, internalTag);
                    this.notifyTopmost(containerId);
                    this.mActivity.onContainerChange(containerId);
                    return true;
                }
                catch (IllegalStateException e) {
                    if (AnotherFragment.getDefault().isThrowStateLost()) {
                        throw e;
                    }
                    LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "IllegalStateException detected, it may due to state lost. Exception: %s", e.toString()));
                }
            } else {
                LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "Remove fragment container not match. Fragment: %s, Container: %d", fragment.getClass().getSimpleName(), containerId));
            }
        } else {
            LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "Remove fragment getTag return null. Fragment: %s", fragment.getClass().getSimpleName()));
        }
        return false;
    }
}

