/*
 * Decompiled with CFR 0.152.
 */
package hk.ids.gws.android.afragment.ui.fragmentmanage;

import android.annotation.SuppressLint;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.os.Bundle;
import android.support.annotation.AnimatorRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import hk.ids.gws.android.afragment.R;
import hk.ids.gws.android.afragment.helper.AnotherFragment;
import hk.ids.gws.android.afragment.ui.activity.IRootActivity;
import hk.ids.gws.android.afragment.ui.fragment.RootFragment;
import hk.ids.gws.android.afragment.ui.fragmentmanage.ContainerInfo;
import hk.ids.gws.android.afragment.utils.LogUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class FragmentStore {
    protected final String INTERNALTAG = "AnotherFragment:" + this.getClass().getSimpleName();
    private static final String BUNDLE_TAG_FRAGMENT_TAG = "afragment:fragment.tag";
    private static final String BUNDLE_TAG_FRAGMENT_VISIBILITY = "afragment:fragment.visibility";
    private static final String BUNDLE_TAG_TAGMAP = "afragment:tagmap";
    private static final String BUNDLE_TAG_VISIBILITYMAP = "afragment:visibilitymap";
    private static final String BUNDLE_TAG_STACKS = "afragment:stacks";
    private final Object mLock = new Object();
    private IRootActivity mActivity;
    private HashMap<String, String> mTagMap = new HashMap();
    private HashMap<String, Boolean> mVisibilityMap = new HashMap();
    private SparseArray<ContainerInfo> mStacks = new SparseArray();
    private HashMap<String, RootFragment> mFragmentInstances = new HashMap();

    public FragmentStore(@NonNull IRootActivity activity, @Nullable Bundle savedInstanceState) {
        this.mActivity = activity;
        if (savedInstanceState != null) {
            Serializable tagMapSerializable = savedInstanceState.getSerializable(BUNDLE_TAG_TAGMAP);
            Serializable visibilityMapSerializable = savedInstanceState.getSerializable(BUNDLE_TAG_VISIBILITYMAP);
            SparseArray sparseArray = savedInstanceState.getSparseParcelableArray(BUNDLE_TAG_STACKS);
            if (tagMapSerializable != null) {
                this.mTagMap = (HashMap)tagMapSerializable;
                LogUtil.i(this.INTERNALTAG, "FragmentStore create from saved state, mTagMap restored");
            }
            if (visibilityMapSerializable != null) {
                this.mVisibilityMap = (HashMap)visibilityMapSerializable;
                LogUtil.i(this.INTERNALTAG, "FragmentStore create from saved state, mVisibilityMap restored");
            }
            if (sparseArray != null) {
                this.mStacks = sparseArray;
                LogUtil.i(this.INTERNALTAG, "FragmentStore create from saved state, mStacks restored");
            }
            ArrayList<String> tags = new ArrayList<String>();
            for (int i = 0; i < this.mStacks.size(); ++i) {
                ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(this.mStacks.keyAt(i));
                tags.addAll(containerInfo.fragmentTags);
            }
            for (String tag : tags) {
                Fragment fragment = this.getFragmentManager().findFragmentByTag(tag);
                if (fragment == null || !(fragment instanceof RootFragment)) continue;
                this.mFragmentInstances.put(tag, (RootFragment)fragment);
                if (!this.getVisibility((RootFragment)fragment)) {
                    this.hide((RootFragment)fragment);
                }
                LogUtil.i(this.INTERNALTAG, String.format("FragmentStore restored an instance. Tag: %s, Fragment: %s", tag, fragment.getClass().getSimpleName()));
            }
        }
    }

    public Bundle getInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putSerializable(BUNDLE_TAG_TAGMAP, this.mTagMap);
        bundle.putSerializable(BUNDLE_TAG_VISIBILITYMAP, this.mVisibilityMap);
        bundle.putSparseParcelableArray(BUNDLE_TAG_STACKS, this.mStacks);
        return bundle;
    }

    private FragmentManager getFragmentManager() {
        return this.mActivity.getFragmentManager();
    }

    @Nullable
    private String getTopFragmentTag(int containerId) {
        return this.getTopNFragmentTag(containerId, 0);
    }

    @Nullable
    private String getTopNFragmentTag(int containerId, int n) {
        ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
        if (containerInfo == null || containerInfo.fragmentTags.size() <= n) {
            return null;
        }
        return containerInfo.fragmentTags.get(containerInfo.fragmentTags.size() - n - 1);
    }

    @Nullable
    private RootFragment getFragmentByTag(String internalTag) {
        return this.mFragmentInstances.get(internalTag);
    }

    @NonNull
    private String assignTag(RootFragment fragment) {
        String uuid = this.getTag(fragment);
        if (uuid == null) {
            uuid = UUID.randomUUID().toString();
            Bundle bundle = fragment.getArguments();
            if (bundle == null) {
                bundle = new Bundle();
            }
            bundle.putString(BUNDLE_TAG_FRAGMENT_TAG, uuid);
            fragment.setArguments(bundle);
            LogUtil.i(this.INTERNALTAG, String.format(Locale.getDefault(), "Assigned new tag to fragment. Fragment: %s, Tag: %s", ((Object)((Object)fragment)).getClass().getSimpleName(), uuid));
        }
        return uuid;
    }

    @Nullable
    private String getTag(RootFragment fragment) {
        Bundle bundle = fragment.getArguments();
        if (bundle != null) {
            return bundle.getString(BUNDLE_TAG_FRAGMENT_TAG);
        }
        return null;
    }

    private boolean getVisibility(RootFragment fragment) {
        String tag = this.getTag(fragment);
        return tag == null || this.mVisibilityMap.get(tag) == null || this.mVisibilityMap.get(tag) != false;
    }

    private void setVisibility(RootFragment fragment, boolean visibility) {
        String tag = this.getTag(fragment);
        if (tag == null) {
            return;
        }
        this.mVisibilityMap.put(tag, visibility);
    }

    @SuppressLint(value={"CommitTransaction"})
    private List<FragmentTransaction> getFlushTransactions(int containerId, int overrideAnimation) {
        ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
        if (containerInfo != null && containerInfo.fragmentTags.size() > 0) {
            ArrayList<RootFragment> pending = new ArrayList<RootFragment>();
            for (int i = 0; i < containerInfo.fragmentTags.size(); ++i) {
                RootFragment fragment = this.getFragmentByTag(containerInfo.fragmentTags.get(i));
                if (fragment == null) continue;
                pending.add(fragment);
            }
            FragmentTransaction aniTransaction = null;
            FragmentTransaction nonaniTransaction = null;
            for (int i = 0; i < pending.size(); ++i) {
                RootFragment fragment = (RootFragment)((Object)pending.get(i));
                if (i == pending.size() - 1) {
                    if (aniTransaction == null) {
                        aniTransaction = this.getFragmentManager().beginTransaction();
                        if (fragment.getEnterAnimation() != -1 && fragment.getExitAnimation() != -1 || overrideAnimation != -1) {
                            aniTransaction.setCustomAnimations(fragment.getEnterAnimation(), overrideAnimation == -1 ? fragment.getExitAnimation() : overrideAnimation);
                        }
                    }
                    aniTransaction.remove((Fragment)fragment);
                    continue;
                }
                if (nonaniTransaction == null) {
                    nonaniTransaction = this.getFragmentManager().beginTransaction();
                    nonaniTransaction.setCustomAnimations(R.animator.animator_fragment_no_ani, R.animator.animator_fragment_no_ani);
                }
                nonaniTransaction.remove((Fragment)fragment);
            }
            ArrayList<FragmentTransaction> fragmentTransactions = new ArrayList<FragmentTransaction>();
            if (nonaniTransaction != null) {
                fragmentTransactions.add(nonaniTransaction);
            }
            if (aniTransaction != null) {
                fragmentTransactions.add(aniTransaction);
            }
            return fragmentTransactions;
        }
        return null;
    }

    private void notifyTopmost(int containerId) {
        if (!AnotherFragment.getDefault().isNotifyTopmost()) {
            return;
        }
        ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
        if (containerInfo != null && containerInfo.fragmentTags.size() >= 0) {
            boolean foundVisible = false;
            for (int i = 0; i < containerInfo.fragmentTags.size(); ++i) {
                RootFragment fragment = this.getFragmentByTag(containerInfo.fragmentTags.get(i));
                if (fragment == null) {
                    LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "Unexpected behaviour: getFragmentByTag return null. Index: %d, Container: %d", i, containerId));
                    continue;
                }
                if (!foundVisible && !fragment.isHidden()) {
                    foundVisible = true;
                    fragment.onTopmostChanged(true);
                    continue;
                }
                fragment.onTopmostChanged(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeAppendTransaction(int containerId, RootFragment fragment, String tag) {
        Object object = this.mLock;
        synchronized (object) {
            ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
            if (containerInfo == null) {
                containerInfo = new ContainerInfo();
            }
            containerInfo.fragmentTags.add(tag);
            this.mStacks.put(containerId, (Object)containerInfo);
            this.mFragmentInstances.put(tag, fragment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeReplaceTransaction(int containerId, RootFragment fragment, String tag) {
        Object object = this.mLock;
        synchronized (object) {
            ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
            if (containerInfo != null) {
                for (String current : containerInfo.fragmentTags) {
                    this.mFragmentInstances.remove(current);
                }
            }
            containerInfo = new ContainerInfo();
            containerInfo.fragmentTags.add(tag);
            this.mStacks.put(containerId, (Object)containerInfo);
            this.mFragmentInstances.put(tag, fragment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeRemoveTransaction(int containerId, String tag) {
        Object object = this.mLock;
        synchronized (object) {
            ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
            if (containerInfo == null) {
                containerInfo = new ContainerInfo();
            }
            containerInfo.fragmentTags.remove(tag);
            this.mStacks.put(containerId, (Object)containerInfo);
            this.mFragmentInstances.remove(tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeFlushTransaction(int containerId) {
        Object object = this.mLock;
        synchronized (object) {
            ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
            if (containerInfo != null) {
                for (String current : containerInfo.fragmentTags) {
                    this.mFragmentInstances.remove(current);
                }
            }
            containerInfo = new ContainerInfo();
            this.mStacks.put(containerId, (Object)containerInfo);
        }
    }

    public int getCount(int containerId) {
        ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
        return containerInfo == null ? 0 : containerInfo.fragmentTags.size();
    }

    public boolean isEmpty(int containerId) {
        ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
        return containerInfo == null || containerInfo.fragmentTags.size() == 0;
    }

    public boolean isExist(int containerId, RootFragment fragment) {
        ContainerInfo containerInfo;
        String tag = this.getTag(fragment);
        return tag != null && (containerInfo = (ContainerInfo)this.mStacks.get(containerId)) != null && containerInfo.fragmentTags.contains(tag);
    }

    @Nullable
    public RootFragment getTopFragment(int containerId) {
        return this.getTopNFragment(containerId, 0);
    }

    @Nullable
    public RootFragment getTopNFragment(int containerId, int n) {
        String internalTag = this.getTopNFragmentTag(containerId, n);
        if (internalTag == null) {
            return null;
        }
        return this.mFragmentInstances.get(internalTag);
    }

    @Nullable
    public RootFragment findFragmentByTag(String tag) {
        String internalTag = this.mTagMap.get(tag);
        if (internalTag == null) {
            return null;
        }
        return this.mFragmentInstances.get(internalTag);
    }

    public void flush(int containerId) {
        this.flush(containerId, -1);
    }

    public void flush(int containerId, int overrideAnimation) {
        List<FragmentTransaction> fragmentTransactions = this.getFlushTransactions(containerId, overrideAnimation);
        if (fragmentTransactions != null && fragmentTransactions.size() > 0) {
            try {
                for (FragmentTransaction fragmentTransaction : fragmentTransactions) {
                    fragmentTransaction.commit();
                }
                this.completeFlushTransaction(containerId);
                this.mActivity.onContainerChange(containerId);
            }
            catch (IllegalStateException e) {
                if (AnotherFragment.getDefault().isThrowStateLost()) {
                    throw e;
                }
                LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "IllegalStateException detected, it may due to state lost. Exception: %s", e.toString()));
            }
        }
    }

    public boolean back(int containerId) {
        return this.back(containerId, false, -1);
    }

    public boolean back(int containerId, boolean allowEmpty) {
        return this.back(containerId, allowEmpty, -1);
    }

    public boolean back(int containerId, boolean allowEmpty, @AnimatorRes int overrideAnimation) {
        int count = this.getCount(containerId);
        if (count > (allowEmpty ? 0 : 1)) {
            String tag = this.getTopFragmentTag(containerId);
            if (tag != null) {
                RootFragment fragment = this.getFragmentByTag(tag);
                if (fragment != null && fragment.canBack()) {
                    if (fragment.onBackPressed()) {
                        return true;
                    }
                    FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
                    if (fragment.getEnterAnimation() != -1 && fragment.getExitAnimation() != -1 || overrideAnimation != -1) {
                        fragmentTransaction.setCustomAnimations(fragment.getEnterAnimation(), overrideAnimation == -1 ? fragment.getExitAnimation() : overrideAnimation);
                    }
                    fragmentTransaction.remove((Fragment)fragment);
                    try {
                        fragmentTransaction.commit();
                        this.completeRemoveTransaction(containerId, tag);
                        this.notifyTopmost(containerId);
                        if (count == 1) {
                            this.mActivity.onContainerEmpty(containerId);
                        }
                        this.mActivity.onContainerChange(containerId);
                        return true;
                    }
                    catch (IllegalStateException e) {
                        if (AnotherFragment.getDefault().isThrowStateLost()) {
                            throw e;
                        }
                        LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "IllegalStateException detected, it may due to state lost. Exception: %s", e.toString()));
                    }
                }
            } else {
                LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "Unexpected behaviour: getTopFragmentTag return null. Container: %d", containerId));
            }
        } else {
            LogUtil.i(this.INTERNALTAG, String.format(Locale.getDefault(), "Unable to back any more. Container: %d", containerId));
        }
        return false;
    }

    public void add(int containerId, RootFragment fragment) {
        this.add(containerId, fragment, null);
    }

    public void add(int containerId, RootFragment fragment, String tag) {
        this.add(containerId, fragment, false, tag);
    }

    public void add(int containerId, RootFragment fragment, boolean hide) {
        this.add(containerId, fragment, hide, null);
    }

    public void add(int containerId, RootFragment fragment, boolean hide, String tag) {
        String internalTag = this.assignTag(fragment);
        if (tag != null) {
            this.mTagMap.put(tag, internalTag);
        }
        FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
        if (fragment.getEnterAnimation() != -1 && fragment.getExitAnimation() != -1) {
            fragmentTransaction.setCustomAnimations(fragment.getEnterAnimation(), fragment.getExitAnimation());
        }
        fragmentTransaction.add(containerId, (Fragment)fragment, internalTag);
        if (hide) {
            fragmentTransaction.hide((Fragment)fragment);
        }
        try {
            fragmentTransaction.commit();
            this.completeAppendTransaction(containerId, fragment, internalTag);
            if (hide) {
                this.notifyTopmost(containerId);
            }
            this.mActivity.onContainerChange(containerId);
        }
        catch (IllegalStateException e) {
            if (AnotherFragment.getDefault().isThrowStateLost()) {
                throw e;
            }
            LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "IllegalStateException detected, it may due to state lost. Exception: %s", e.toString()));
        }
    }

    public void replace(int containerId, RootFragment fragment) {
        this.replace(containerId, fragment, null);
    }

    public void replace(int containerId, RootFragment fragment, String tag) {
        String internalTag = this.assignTag(fragment);
        if (tag != null) {
            this.mTagMap.put(tag, internalTag);
        }
        List<FragmentTransaction> fragmentTransactions = this.getFlushTransactions(containerId, -1);
        FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
        if (fragment.getEnterAnimation() != -1 && fragment.getExitAnimation() != -1) {
            fragmentTransaction.setCustomAnimations(fragment.getEnterAnimation(), fragment.getExitAnimation());
        }
        fragmentTransaction.add(containerId, (Fragment)fragment, internalTag);
        try {
            fragmentTransaction.commit();
            if (fragmentTransactions != null) {
                for (FragmentTransaction removeTransaction : fragmentTransactions) {
                    removeTransaction.commit();
                }
            }
            this.completeReplaceTransaction(containerId, fragment, internalTag);
            this.notifyTopmost(containerId);
            this.mActivity.onContainerChange(containerId);
        }
        catch (IllegalStateException e) {
            if (AnotherFragment.getDefault().isThrowStateLost()) {
                throw e;
            }
            LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "IllegalStateException detected, it may due to state lost. Exception: %s", e.toString()));
        }
    }

    public void show(RootFragment fragment) {
        String tag = this.getTag(fragment);
        if (tag == null) {
            return;
        }
        Integer containerId = null;
        for (int i = 0; i < this.mStacks.size(); ++i) {
            int key = this.mStacks.keyAt(i);
            ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(key);
            if (!containerInfo.fragmentTags.contains(tag)) continue;
            containerId = key;
            break;
        }
        if (containerId == null) {
            return;
        }
        FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
        fragmentTransaction.show((Fragment)fragment);
        try {
            fragmentTransaction.commit();
            this.setVisibility(fragment, true);
            this.notifyTopmost(containerId);
        }
        catch (IllegalStateException e) {
            if (AnotherFragment.getDefault().isThrowStateLost()) {
                throw e;
            }
            LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "IllegalStateException detected, it may due to state lost. Exception: %s", e.toString()));
        }
    }

    public void hide(RootFragment fragment) {
        String tag = this.getTag(fragment);
        if (tag == null) {
            return;
        }
        Integer containerId = null;
        for (int i = 0; i < this.mStacks.size(); ++i) {
            int key = this.mStacks.keyAt(i);
            ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(key);
            if (!containerInfo.fragmentTags.contains(tag)) continue;
            containerId = key;
            break;
        }
        if (containerId == null) {
            return;
        }
        FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
        fragmentTransaction.hide((Fragment)fragment);
        try {
            fragmentTransaction.commit();
            this.setVisibility(fragment, false);
            this.notifyTopmost(containerId);
        }
        catch (IllegalStateException e) {
            if (AnotherFragment.getDefault().isThrowStateLost()) {
                throw e;
            }
            LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "IllegalStateException detected, it may due to state lost. Exception: %s", e.toString()));
        }
    }

    public boolean remove(int containerId, RootFragment fragment) {
        return this.remove(containerId, fragment, -1);
    }

    public boolean remove(int containerId, RootFragment fragment, int overrideAnimation) {
        String internalTag = this.getTag(fragment);
        if (internalTag != null) {
            ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
            if (containerInfo != null && containerInfo.fragmentTags.contains(internalTag)) {
                FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
                if (fragment.getEnterAnimation() != -1 && fragment.getExitAnimation() != -1 || overrideAnimation != -1) {
                    fragmentTransaction.setCustomAnimations(fragment.getEnterAnimation(), overrideAnimation == -1 ? fragment.getExitAnimation() : overrideAnimation);
                }
                fragmentTransaction.remove((Fragment)fragment);
                try {
                    fragmentTransaction.commit();
                    this.completeRemoveTransaction(containerId, internalTag);
                    this.notifyTopmost(containerId);
                    this.mActivity.onContainerChange(containerId);
                    return true;
                }
                catch (IllegalStateException e) {
                    if (AnotherFragment.getDefault().isThrowStateLost()) {
                        throw e;
                    }
                    LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "IllegalStateException detected, it may due to state lost. Exception: %s", e.toString()));
                }
            } else {
                LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "Remove fragment container not match. Fragment: %s, Container: %d", ((Object)((Object)fragment)).getClass().getSimpleName(), containerId));
            }
        } else {
            LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "Remove fragment getTag return null. Fragment: %s", ((Object)((Object)fragment)).getClass().getSimpleName()));
        }
        return false;
    }
}

