/*
 * Decompiled with CFR 0.152.
 */
package hk.ids.gws.android.afragment.ui.fragment;

import android.app.Activity;
import android.app.Fragment;
import android.os.Bundle;
import android.support.annotation.AnimatorRes;
import android.support.annotation.CallSuper;
import android.support.annotation.Nullable;
import hk.ids.gws.android.afragment.ui.activity.RootActivity;
import hk.ids.gws.android.afragment.ui.fragmentmanage.FragmentStore;

public abstract class RootFragment
extends Fragment {
    private final String BundleStateEnterAnimation = "afragment:fragment.enteranimation";
    private final String BundleStateExitAnimation = "afragment:fragment.exitanimation";
    private int mEnterAnimation = -1;
    private int mExitAnimation = -1;
    private boolean mTopMost = false;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.mEnterAnimation = savedInstanceState.getInt("afragment:fragment.enteranimation");
            this.mExitAnimation = savedInstanceState.getInt("afragment:fragment.exitanimation");
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putInt("afragment:fragment.enteranimation", this.mEnterAnimation);
        outState.putInt("afragment:fragment.exitanimation", this.mExitAnimation);
        super.onSaveInstanceState(outState);
    }

    public final void setAnimations(@AnimatorRes int enterAnimation, @AnimatorRes int exitAnimation) {
        this.mEnterAnimation = enterAnimation;
        this.mExitAnimation = exitAnimation;
    }

    @AnimatorRes
    public final int getEnterAnimation() {
        return this.mEnterAnimation;
    }

    @AnimatorRes
    public final int getExitAnimation() {
        return this.mExitAnimation;
    }

    public boolean canBack() {
        return true;
    }

    public boolean onBackPressed() {
        return false;
    }

    @CallSuper
    public void onTopmostChanged(boolean topMost) {
        this.mTopMost = topMost;
    }

    public boolean isTopMost() {
        return this.mTopMost;
    }

    @Nullable
    public final RootActivity getRootActivity() {
        Activity activity = this.getActivity();
        if (activity != null && activity instanceof RootActivity) {
            return (RootActivity)activity;
        }
        return null;
    }

    @Nullable
    public final FragmentStore getFragmentStore() {
        if (this.getRootActivity() == null) {
            return null;
        }
        return this.getRootActivity().getFragmentStore();
    }
}

