package hk.ids.gws.android.afragment.ui.activity;

import android.app.Activity;
import android.app.FragmentManager;
import android.os.Bundle;

import java.util.Locale;

import hk.ids.gws.android.afragment.ui.fragmentmanage.FragmentStore;
import hk.ids.gws.android.afragment.utils.LogUtil;

@SuppressWarnings("unused")
public abstract class RootActivity extends Activity {
    protected final String INTERNALTAG = "AnotherFragment:" + getClass().getSimpleName();


    private FragmentStore mFragmentStore;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        // Create or restore FragmentStore instance
        mFragmentStore = new FragmentStore(this, savedInstanceState);
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        if (mFragmentStore != null) {
            outState.putAll(mFragmentStore.getInstanceState());
        }

        super.onSaveInstanceState(outState);
    }

    @Override
    public final void onBackPressed() {
        if (onBackStarted()) {
            return;
        }

        int[] containers = getFragmentContainerInOrder();
        if (containers != null) {
            for (int container : containers) {
                boolean allowEmpty = isFragmentContainerAllowEmpty(container);
                boolean result = mFragmentStore.back(container, allowEmpty);

                LogUtil.i(INTERNALTAG, String.format(Locale.getDefault(), "onBackPressed(), fragment inside container [%d] return %s", container, result ? "true" : "false"));

                if (result) return;
            }
        }
        if (onBackEnded()) {
            LogUtil.i(INTERNALTAG, "onBackPressed(), child activity return true, event consumed");

            return;
        }

        super.onBackPressed();
    }


    /**
     * Let super known the fragment container id in order,
     * when back pressed, the event will pass to each fragment
     * inside container in ascending order.
     */
    protected abstract int[] getFragmentContainerInOrder();

    /**
     * Let super know if the container can back to empty
     */
    protected abstract boolean isFragmentContainerAllowEmpty(int containerId);

    /**
     * Called when given container become empty
     * Deprecated, please use onContainerChange(int) instead
     */
    @Deprecated
    public void onContainerEmpty(int containerId) {}

    /**
     * Called when fragment(s) in given container has changed
     */
    public void onContainerChange(int containerId) {}

    /**
     * Called when activity has passed all onBackPressed event
     * to all container and finally return false
     * @return true if event consumed, false if not handled
     */
    protected boolean onBackEnded() {
        return false;
    }

    /**
     * Called when activity before passed onBackPressed event
     * to any container
     * @return true if event consumed, false if not handled
     */
    protected boolean onBackStarted() {
        return false;
    }

    /**
     * Please do not implement your own fragment logic,
     * it may affect the library and have unintended effects.
     *
     * To manage fragments, use getFragmentStore() instead.
     */
    @Deprecated
    @Override
    public FragmentManager getFragmentManager() {
        return super.getFragmentManager();
    }


    public final FragmentStore getFragmentStore() {
        return mFragmentStore;
    }
}
