package hk.ids.gws.android.afragment.ui.fragment;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.os.Bundle;
import android.support.annotation.AnimatorRes;
import android.support.annotation.Nullable;

import hk.ids.gws.android.afragment.ui.activity.RootActivity;
import hk.ids.gws.android.afragment.ui.fragmentmanage.FragmentStore;

public abstract class RootFragment extends Fragment {
    private final String BundleStateEnterAnimation = "afragment:fragment.enteranimation";
    private final String BundleStateExitAnimation = "afragment:fragment.exitanimation";

    private int mEnterAnimation = -1;
    private int mExitAnimation = -1;


    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        if (savedInstanceState != null) {
            mEnterAnimation = savedInstanceState.getInt(BundleStateEnterAnimation);
            mExitAnimation = savedInstanceState.getInt(BundleStateExitAnimation);
        }
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        outState.putInt(BundleStateEnterAnimation, mEnterAnimation);
        outState.putInt(BundleStateExitAnimation, mExitAnimation);

        super.onSaveInstanceState(outState);
    }


    public final void setAnimations(@AnimatorRes int enterAnimation, @AnimatorRes int exitAnimation) {
        mEnterAnimation = enterAnimation;
        mExitAnimation = exitAnimation;
    }

    @AnimatorRes
    public final int getEnterAnimation() {
        return mEnterAnimation;
    }

    @AnimatorRes
    public final int getExitAnimation() {
        return mExitAnimation;
    }


    /**
     * Called when the parent has detected the user's press of the back
     * key, and the fragment should currently handle it.
     *
     * @return true if event consumed, false if not handled
     */
    public boolean onBackPressed() {
        return false;
    }

    /**
     * Called when the fragment is on top most or no longer top most,
     * it may not get called if setting is disabled
     */
    public void onTopmostChanged(boolean isTopmost) {}


    /**
     * Return the RootActivity this fragment is currently associated with.
     */
    @Nullable
    public final RootActivity getRootActivity() {
        Activity activity = getActivity();
        if (activity != null && activity instanceof RootActivity) return ((RootActivity) activity);

        return null;
    }

    @Nullable
    public final FragmentStore getFragmentStore() {
        if (getRootActivity() == null) return null;
        return getRootActivity().getFragmentStore();
    }
}
