/*
 * Decompiled with CFR 0.152.
 */
package hk.ids.gws.android.afragment.ui.fragmentmanage;

import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.os.Bundle;
import android.support.annotation.AnimatorRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import hk.ids.gws.android.afragment.helper.AnotherFragment;
import hk.ids.gws.android.afragment.ui.activity.RootActivity;
import hk.ids.gws.android.afragment.ui.fragment.RootFragment;
import hk.ids.gws.android.afragment.ui.fragmentmanage.ContainerInfo;
import hk.ids.gws.android.afragment.utils.LogUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;

public class FragmentStore {
    protected final String INTERNALTAG = "AnotherFragment:" + this.getClass().getSimpleName();
    private static final String BUNDLE_TAG_FRAGMENT_TAG = "afragment:fragment.tag";
    private static final String BUNDLE_TAG_TAGMAP = "afragment:tagmap";
    private static final String BUNDLE_TAG_STACKS = "afragment:stacks";
    private RootActivity mActivity;
    private HashMap<String, String> mTagMap = new HashMap();
    private SparseArray<ContainerInfo> mStacks = new SparseArray();

    public FragmentStore(@NonNull RootActivity activity, @Nullable Bundle savedInstanceState) {
        this.mActivity = activity;
        if (savedInstanceState != null) {
            Serializable serializable = savedInstanceState.getSerializable(BUNDLE_TAG_TAGMAP);
            SparseArray sparseArray = savedInstanceState.getSparseParcelableArray(BUNDLE_TAG_STACKS);
            if (serializable != null) {
                this.mTagMap = (HashMap)serializable;
                LogUtil.i(this.INTERNALTAG, "FragmentStore create from saved state, mTagMap restored");
            }
            if (sparseArray != null) {
                this.mStacks = sparseArray;
                LogUtil.i(this.INTERNALTAG, "FragmentStore create from saved state, mStacks restored");
            }
        }
    }

    public Bundle getInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putSerializable(BUNDLE_TAG_TAGMAP, this.mTagMap);
        bundle.putSparseParcelableArray(BUNDLE_TAG_STACKS, this.mStacks);
        return bundle;
    }

    private FragmentManager getFragmentManager() {
        return this.mActivity.getFragmentManager();
    }

    @Nullable
    private String getTopFragmentTag(int containerId) {
        return this.getTopNFragmentTag(containerId, 0);
    }

    @Nullable
    private String getTopNFragmentTag(int containerId, int n) {
        ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
        if (containerInfo == null || containerInfo.fragmentTags.size() <= n) {
            return null;
        }
        return containerInfo.fragmentTags.get(containerInfo.fragmentTags.size() - n - 1);
    }

    @Nullable
    private RootFragment getFragmentByTag(String internalTag) {
        Fragment fragment = this.getFragmentManager().findFragmentByTag(internalTag);
        if (fragment == null || !(fragment instanceof RootFragment)) {
            return null;
        }
        return (RootFragment)fragment;
    }

    @NonNull
    private String assignTag(RootFragment fragment) {
        String uuid = this.getTag(fragment);
        if (uuid == null) {
            uuid = UUID.randomUUID().toString();
            Bundle bundle = fragment.getArguments();
            if (bundle == null) {
                bundle = new Bundle();
            }
            bundle.putString(BUNDLE_TAG_FRAGMENT_TAG, uuid);
            fragment.setArguments(bundle);
            LogUtil.i(this.INTERNALTAG, String.format(Locale.getDefault(), "Assigned new tag to fragment. Fragment: %s, Tag: %s", ((Object)((Object)fragment)).getClass().getSimpleName(), uuid));
        }
        return uuid;
    }

    @Nullable
    private String getTag(RootFragment fragment) {
        Bundle bundle = fragment.getArguments();
        if (bundle != null) {
            return bundle.getString(BUNDLE_TAG_FRAGMENT_TAG);
        }
        return null;
    }

    private void notifyTopmost(int containerId) {
        if (!AnotherFragment.getDefault().isNotifyTopmost()) {
            return;
        }
        ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
        if (containerInfo != null && containerInfo.fragmentTags.size() >= 0) {
            for (int i = 0; i < containerInfo.fragmentTags.size(); ++i) {
                RootFragment fragment = this.getFragmentByTag(containerInfo.fragmentTags.get(i));
                if (fragment == null) {
                    LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "Unexpected behaviour: getFragmentByTag return null. Index: %d, Container: %d", i, containerId));
                    continue;
                }
                if (i == containerInfo.fragmentTags.size() - 1) {
                    fragment.onTopmostChanged(true);
                    continue;
                }
                fragment.onTopmostChanged(false);
            }
        }
    }

    private void completeAppendTransaction(int containerId, String tag) {
        ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
        if (containerInfo == null) {
            containerInfo = new ContainerInfo();
        }
        containerInfo.fragmentTags.add(tag);
        this.mStacks.put(containerId, (Object)containerInfo);
    }

    private void completeRemoveTransaction(int containerId, String tag) {
        ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
        if (containerInfo == null) {
            containerInfo = new ContainerInfo();
        }
        containerInfo.fragmentTags.remove(tag);
        this.mStacks.put(containerId, (Object)containerInfo);
    }

    public int getCount(int containerId) {
        ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
        return containerInfo == null ? 0 : containerInfo.fragmentTags.size();
    }

    public boolean isEmpty(int containerId) {
        ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
        return containerInfo == null || containerInfo.fragmentTags.size() == 0;
    }

    public boolean isExist(int containerId, RootFragment fragment) {
        ContainerInfo containerInfo;
        String tag = this.getTag(fragment);
        return tag != null && (containerInfo = (ContainerInfo)this.mStacks.get(containerId)) != null && containerInfo.fragmentTags.contains(tag);
    }

    @Nullable
    public RootFragment getTopFragment(int containerId) {
        return this.getTopNFragment(containerId, 0);
    }

    @Nullable
    public RootFragment getTopNFragment(int containerId, int n) {
        String tag = this.getTopNFragmentTag(containerId, n);
        if (tag == null) {
            return null;
        }
        Fragment fragment = this.getFragmentManager().findFragmentByTag(tag);
        if (fragment == null || !(fragment instanceof RootFragment)) {
            return null;
        }
        return (RootFragment)fragment;
    }

    @Nullable
    public RootFragment findFragmentByTag(String tag) {
        String storeTag = this.mTagMap.get(tag);
        if (storeTag == null) {
            return null;
        }
        Fragment fragment = this.getFragmentManager().findFragmentByTag(storeTag);
        if (fragment == null || !(fragment instanceof RootFragment)) {
            return null;
        }
        return (RootFragment)fragment;
    }

    public void flush(int containerId) {
        this.flush(containerId, -1);
    }

    public void flush(int containerId, int overrideAnimation) {
        ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
        if (containerInfo != null && containerInfo.fragmentTags.size() > 0) {
            int i;
            ArrayList<RootFragment> pending = new ArrayList<RootFragment>();
            for (i = 0; i < containerInfo.fragmentTags.size(); ++i) {
                RootFragment fragment = this.getFragmentByTag(containerInfo.fragmentTags.get(i));
                if (fragment == null) continue;
                pending.add(fragment);
            }
            for (i = 0; i < pending.size(); ++i) {
                if (i == pending.size() - 1) {
                    this.remove(containerId, (RootFragment)((Object)pending.get(i)), overrideAnimation);
                    continue;
                }
                this.remove(containerId, (RootFragment)((Object)pending.get(i)), 0);
            }
        }
    }

    public boolean back(int containerId) {
        return this.back(containerId, false, -1);
    }

    public boolean back(int containerId, boolean allowEmpty) {
        return this.back(containerId, allowEmpty, -1);
    }

    public boolean back(int containerId, boolean allowEmpty, @AnimatorRes int overrideAnimation) {
        int count = this.getCount(containerId);
        if (count > (allowEmpty ? 0 : 1)) {
            String tag = this.getTopFragmentTag(containerId);
            if (tag != null) {
                RootFragment fragment = this.getFragmentByTag(tag);
                if (fragment != null && !fragment.onBackPressed()) {
                    FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
                    if (fragment.getEnterAnimation() != -1 && fragment.getExitAnimation() != -1 || overrideAnimation != -1) {
                        fragmentTransaction.setCustomAnimations(fragment.getEnterAnimation(), overrideAnimation == -1 ? fragment.getExitAnimation() : overrideAnimation);
                    }
                    fragmentTransaction.remove((Fragment)fragment);
                    try {
                        fragmentTransaction.commit();
                        this.getFragmentManager().executePendingTransactions();
                        this.completeRemoveTransaction(containerId, tag);
                        this.notifyTopmost(containerId);
                        if (count == 1) {
                            this.mActivity.onContainerEmpty(containerId);
                        }
                        return true;
                    }
                    catch (IllegalStateException e) {
                        if (AnotherFragment.getDefault().isThrowStateLost()) {
                            throw e;
                        }
                        LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "IllegalStateException detected, it may due to state lost. Exception: %s", e.toString()));
                    }
                }
            } else {
                LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "Unexpected behaviour: getTopFragmentTag return null. Container: %d", containerId));
            }
        } else {
            LogUtil.i(this.INTERNALTAG, String.format(Locale.getDefault(), "Unable to back any more. Container: %d", containerId));
        }
        return false;
    }

    public void add(int containerId, RootFragment fragment) {
        this.add(containerId, fragment, null);
    }

    public void add(int containerId, RootFragment fragment, String tag) {
        String internalTag = this.assignTag(fragment);
        if (tag != null) {
            this.mTagMap.put(tag, internalTag);
        }
        FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
        fragmentTransaction.add(containerId, (Fragment)fragment, internalTag);
        if (fragment.getEnterAnimation() != -1 && fragment.getExitAnimation() != -1) {
            fragmentTransaction.setCustomAnimations(fragment.getEnterAnimation(), fragment.getExitAnimation());
        }
        try {
            fragmentTransaction.commit();
            this.getFragmentManager().executePendingTransactions();
            this.completeAppendTransaction(containerId, internalTag);
            this.notifyTopmost(containerId);
        }
        catch (IllegalStateException e) {
            if (AnotherFragment.getDefault().isThrowStateLost()) {
                throw e;
            }
            LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "IllegalStateException detected, it may due to state lost. Exception: %s", e.toString()));
        }
    }

    public void replace(int containerId, RootFragment fragment) {
        this.replace(containerId, fragment, null);
    }

    public void replace(int containerId, RootFragment fragment, String tag) {
        String internalTag = this.assignTag(fragment);
        if (tag != null) {
            this.mTagMap.put(tag, internalTag);
        }
        FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
        fragmentTransaction.replace(containerId, (Fragment)fragment, internalTag);
        if (fragment.getEnterAnimation() != -1 && fragment.getExitAnimation() != -1) {
            fragmentTransaction.setCustomAnimations(fragment.getEnterAnimation(), fragment.getExitAnimation());
        }
        try {
            fragmentTransaction.commit();
            this.getFragmentManager().executePendingTransactions();
            this.completeAppendTransaction(containerId, internalTag);
            this.notifyTopmost(containerId);
        }
        catch (IllegalStateException e) {
            if (AnotherFragment.getDefault().isThrowStateLost()) {
                throw e;
            }
            LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "IllegalStateException detected, it may due to state lost. Exception: %s", e.toString()));
        }
    }

    public void show(RootFragment fragment) {
        FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
        fragmentTransaction.show((Fragment)fragment);
        try {
            fragmentTransaction.commit();
            this.getFragmentManager().executePendingTransactions();
        }
        catch (IllegalStateException e) {
            if (AnotherFragment.getDefault().isThrowStateLost()) {
                throw e;
            }
            LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "IllegalStateException detected, it may due to state lost. Exception: %s", e.toString()));
        }
    }

    public void hide(RootFragment fragment) {
        FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
        fragmentTransaction.hide((Fragment)fragment);
        try {
            fragmentTransaction.commit();
            this.getFragmentManager().executePendingTransactions();
        }
        catch (IllegalStateException e) {
            if (AnotherFragment.getDefault().isThrowStateLost()) {
                throw e;
            }
            LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "IllegalStateException detected, it may due to state lost. Exception: %s", e.toString()));
        }
    }

    public boolean remove(int containerId, RootFragment fragment) {
        return this.remove(containerId, fragment, -1);
    }

    public boolean remove(int containerId, RootFragment fragment, int overrideAnimation) {
        String internalTag = this.getTag(fragment);
        if (internalTag != null) {
            ContainerInfo containerInfo = (ContainerInfo)this.mStacks.get(containerId);
            if (containerInfo != null && containerInfo.fragmentTags.contains(internalTag)) {
                FragmentTransaction fragmentTransaction = this.getFragmentManager().beginTransaction();
                if (fragment.getEnterAnimation() != -1 && fragment.getExitAnimation() != -1 || overrideAnimation != -1) {
                    fragmentTransaction.setCustomAnimations(fragment.getEnterAnimation(), overrideAnimation == -1 ? fragment.getExitAnimation() : overrideAnimation);
                }
                fragmentTransaction.remove((Fragment)fragment);
                try {
                    fragmentTransaction.commit();
                    this.getFragmentManager().executePendingTransactions();
                    this.completeRemoveTransaction(containerId, internalTag);
                    this.notifyTopmost(containerId);
                    return true;
                }
                catch (IllegalStateException e) {
                    if (AnotherFragment.getDefault().isThrowStateLost()) {
                        throw e;
                    }
                    LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "IllegalStateException detected, it may due to state lost. Exception: %s", e.toString()));
                }
            } else {
                LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "Remove fragment container not match. Fragment: %s, Container: %d", ((Object)((Object)fragment)).getClass().getSimpleName(), containerId));
            }
        } else {
            LogUtil.e(this.INTERNALTAG, String.format(Locale.getDefault(), "Remove fragment getTag return null. Fragment: %s", ((Object)((Object)fragment)).getClass().getSimpleName()));
        }
        return false;
    }
}

