/*
 * Decompiled with CFR 0.152.
 */
package halo.android.permission.common;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.PermissionChecker;
import java.lang.reflect.Method;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0016\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lhalo/android/permission/common/Util;", "", "()V", "M", "", "isPermissionGranted", "", "ctx", "Landroid/content/Context;", "permission", "", "isPermissionRevoked", "isPermissionTargetVersion", "shouldShowRequestPermissionRationale", "fragment", "Landroid/app/Fragment;", "Landroid/support/v4/app/Fragment;", "permission_release"})
public final class Util {
    public static final int M = 23;
    public static final Util INSTANCE;

    public final boolean isPermissionTargetVersion(@NotNull Context ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        PackageInfo packInfo = ctx.getPackageManager().getPackageInfo(ctx.getPackageName(), 0);
        return packInfo.applicationInfo.targetSdkVersion >= 23;
    }

    public final boolean isPermissionGranted(@NotNull Context ctx, @NotNull String permission) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.isPermissionTargetVersion(ctx)) {
                return ContextCompat.checkSelfPermission((Context)ctx, (String)permission) == 0;
            }
            return PermissionChecker.checkSelfPermission((Context)ctx, (String)permission) == 0;
        }
        return true;
    }

    public final boolean shouldShowRequestPermissionRationale(@NotNull Context ctx, @NotNull String permission) throws IllegalArgumentException {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        if (ctx instanceof Activity) {
            return ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)ctx), (String)permission);
        }
        PackageManager packageManager = ctx.getPackageManager();
        Class<?> pkManagerClass = packageManager.getClass();
        try {
            Method method = pkManagerClass.getMethod("shouldShowRequestPermissionRationale", String.class);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            Object object = method.invoke((Object)packageManager, permission);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
            }
            return (Boolean)object;
        }
        catch (Exception e) {
            return false;
        }
    }

    public final boolean shouldShowRequestPermissionRationale(@NotNull Fragment fragment, @NotNull String permission) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        if (Build.VERSION.SDK_INT >= 23) {
            return fragment.shouldShowRequestPermissionRationale(permission);
        }
        return false;
    }

    public final boolean shouldShowRequestPermissionRationale(@NotNull android.support.v4.app.Fragment fragment, @NotNull String permission) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        if (Build.VERSION.SDK_INT >= 23) {
            return fragment.shouldShowRequestPermissionRationale(permission);
        }
        return false;
    }

    @Deprecated(message="\u4e0d\u77e5\u9053\u5177\u4f53\u4f7f\u7528\u573a\u666f")
    public final boolean isPermissionRevoked(@NotNull Context ctx, @NotNull String permission) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        if (Build.VERSION.SDK_INT >= 23) {
            Context context = ctx.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"ctx.applicationContext");
            return context.getPackageManager().isPermissionRevokedByPolicy(permission, ctx.getPackageName());
        }
        return false;
    }

    private Util() {
    }

    static {
        Util util;
        INSTANCE = util = new Util();
    }
}

