/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.use;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Font;
import guru.nidi.graphviz.attribute.ForNode;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.Shape;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.Node;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class FontTools {
    private FontTools() {
    }

    public static List<String> availableFontNames() {
        return Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
    }

    public static void availableFontNamesGraph(File output) throws IOException {
        MutableGraph g = Factory.mutGraph();
        for (String f : FontTools.availableFontNames()) {
            g.add((LinkSource)Factory.node(f).with(Font.name(f)));
        }
        Graphviz.fromGraph(g).render(Format.PNG).toFile(output);
    }

    public static void createFontTest(String name, double adjust, File output) throws IOException {
        Node width = Factory.node("If text is too narrow, increase fontAdjust. If it's too wide, decrease it.");
        Node center = Factory.node(Label.html("A very long node label that should be centered inside the border<br/>If text is too much left, increase fontAdjust.<br/>If it's too much right, decrease it."));
        Graphviz.fromGraph(Factory.graph().nodeAttr().with((Attributes<ForNode>)Font.name(name), Shape.RECTANGLE).with(width.link(center))).fontAdjust(adjust).render(Format.PNG).toFile(output);
    }

    public static void main(String[] args) throws IOException {
        System.out.println("Available fonts: " + FontTools.availableFontNames());
        String fontShow = "font-show.png";
        System.out.println("Creating image with all fonts 'font-show.png'.");
        FontTools.availableFontNamesGraph(new File("font-show.png"));
        if (args.length < 2) {
            System.out.println("Usage: FontTools <font name> <font adjust>");
            System.exit(0);
        }
        try {
            double adjust = Double.parseDouble(args[1]);
            String fontTest = "font-test.png";
            System.out.println("Creating test image 'font-test.png' with font=" + args[0] + " and font adjust=" + adjust);
            FontTools.createFontTest(args[0], adjust, new File("font-test.png"));
        }
        catch (NumberFormatException e) {
            System.out.println("Illegal number " + args[1]);
        }
    }
}

