/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.ForGraph;
import guru.nidi.graphviz.attribute.ForLink;
import guru.nidi.graphviz.attribute.ForNode;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.model.ImmutableNode;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableAttributed;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableNode;
import guru.nidi.graphviz.model.SimpleMutableAttributed;
import guru.nidi.graphviz.model.ThrowingFunction;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import javax.annotation.Nullable;

public final class CreationContext {
    private static final ThreadLocal<Stack<CreationContext>> CONTEXT = ThreadLocal.withInitial(Stack::new);
    @Nullable
    private final MutableGraph graph;
    private final Map<String, ImmutableNode> immutableNodes = new HashMap<String, ImmutableNode>();
    private final Map<String, MutableNode> mutableNodes = new HashMap<String, MutableNode>();
    private final MutableAttributed<CreationContext, ForNode> nodeAttributes = new SimpleMutableAttributed<CreationContext, ForNode>(this);
    private final MutableAttributed<CreationContext, ForLink> linkAttributes = new SimpleMutableAttributed<CreationContext, ForLink>(this);
    private final MutableAttributed<CreationContext, ForGraph> graphAttributes = new SimpleMutableAttributed<CreationContext, ForGraph>(this);

    private CreationContext() {
        this(null);
    }

    private CreationContext(@Nullable MutableGraph graph) {
        this.graph = graph;
    }

    public static <T> T use(ThrowingFunction<CreationContext, T> actions) {
        return CreationContext.use(null, actions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T use(@Nullable MutableGraph graph, ThrowingFunction<CreationContext, T> actions) {
        CreationContext ctx = CreationContext.begin(graph);
        try {
            T t = actions.applyNotThrowing(ctx);
            return t;
        }
        finally {
            CreationContext.end();
        }
    }

    public static Optional<CreationContext> current() {
        Stack<CreationContext> cs = CONTEXT.get();
        return cs.empty() ? Optional.empty() : Optional.of(cs.peek());
    }

    public static CreationContext get() {
        Stack<CreationContext> cs = CONTEXT.get();
        if (cs.empty()) {
            throw new IllegalStateException("Not in a CreationContext");
        }
        return cs.peek();
    }

    static CreationContext begin() {
        return CreationContext.begin(null);
    }

    static CreationContext begin(@Nullable MutableGraph graph) {
        CreationContext ctx = new CreationContext(graph);
        CONTEXT.get().push(ctx);
        return ctx;
    }

    static void end() {
        Stack<CreationContext> cs = CONTEXT.get();
        if (!cs.empty()) {
            CreationContext ctx = cs.pop();
            if (ctx.graph != null) {
                ctx.graph.graphAttrs().add((Attributes<ForGraph>)ctx.graphAttributes);
            }
        }
    }

    public MutableAttributed<CreationContext, ForNode> nodeAttrs() {
        return this.nodeAttributes;
    }

    public MutableAttributed<CreationContext, ForLink> linkAttrs() {
        return this.linkAttributes;
    }

    public MutableAttributed<CreationContext, ForGraph> graphAttrs() {
        return this.graphAttributes;
    }

    static ImmutableNode createNode(Label name) {
        return CreationContext.current().map(ctx -> ctx.newNode(name)).orElseGet(() -> new ImmutableNode(name));
    }

    private ImmutableNode newNode(Label name) {
        return this.immutableNodes.computeIfAbsent(name.value(), l -> new ImmutableNode(name)).with(this.nodeAttributes);
    }

    static MutableGraph createMutGraph() {
        return CreationContext.current().map(CreationContext::newMutGraph).orElseGet(MutableGraph::new);
    }

    private MutableGraph newMutGraph() {
        MutableGraph mg = new MutableGraph();
        if (this.graph != null) {
            this.graph.add((LinkSource)mg);
        }
        return mg;
    }

    static MutableNode createMutNode(Label name) {
        return CreationContext.current().map(ctx -> ctx.newMutNode(name)).orElseGet(() -> new MutableNode(name));
    }

    private MutableNode newMutNode(Label name) {
        return this.mutableNodes.computeIfAbsent(name.value(), l -> this.addMutNode(new MutableNode(name)).add(this.nodeAttributes));
    }

    private MutableNode addMutNode(MutableNode node) {
        if (this.graph != null) {
            this.graph.add((LinkSource)node);
        }
        return node;
    }

    static Link createLink(@Nullable LinkSource from, LinkTarget to) {
        Link link = new Link(from, to, Attributes.attrs());
        return CreationContext.current().map(ctx -> link.with(ctx.linkAttributes)).orElse(link);
    }
}

