/*
 * Decompiled with CFR 0.152.
 */
package com.gun0912.tedpermission;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import java.util.ArrayList;

public abstract class TedPermissionBase {
    public static final int REQ_CODE_REQUEST_SETTING = 2000;
    private static final String PREFS_NAME_PERMISSION = "PREFS_NAME_PERMISSION";
    private static final String PREFS_IS_FIRST_REQUEST = "IS_FIRST_REQUEST";

    public static boolean isGranted(Context context, String ... permissions) {
        for (String permission : permissions) {
            if (!TedPermissionBase.isDenied(context, permission)) continue;
            return false;
        }
        return true;
    }

    public static boolean isDenied(Context context, @NonNull String permission) {
        return !TedPermissionBase.isGranted(context, permission);
    }

    private static boolean isGranted(Context context, @NonNull String permission) {
        return ContextCompat.checkSelfPermission((Context)context, (String)permission) == 0;
    }

    public static ArrayList<String> getDeniedPermissions(Context context, String ... permissions) {
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        for (String permission : permissions) {
            if (!TedPermissionBase.isDenied(context, permission)) continue;
            deniedPermissions.add(permission);
        }
        return deniedPermissions;
    }

    public static boolean canRequestPermission(Activity activity, String ... permissions) {
        if (TedPermissionBase.isFirstRequest((Context)activity, permissions)) {
            return true;
        }
        for (String permission : permissions) {
            boolean showRationale = ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission);
            if (!TedPermissionBase.isDenied((Context)activity, permission) || showRationale) continue;
            return false;
        }
        return true;
    }

    private static boolean isFirstRequest(Context context, @NonNull String[] permissions) {
        for (String permission : permissions) {
            if (TedPermissionBase.isFirstRequest(context, permission)) continue;
            return false;
        }
        return true;
    }

    private static boolean isFirstRequest(Context context, String permission) {
        return TedPermissionBase.getSharedPreferences(context).getBoolean(TedPermissionBase.getPrefsNamePermission(permission), true);
    }

    private static String getPrefsNamePermission(String permission) {
        return "IS_FIRST_REQUEST_" + permission;
    }

    private static SharedPreferences getSharedPreferences(Context context) {
        return context.getSharedPreferences(PREFS_NAME_PERMISSION, 0);
    }

    public static void startSettingActivityForResult(Activity activity) {
        TedPermissionBase.startSettingActivityForResult(activity, 2000);
    }

    public static void startSettingActivityForResult(Activity activity, int requestCode) {
        activity.startActivityForResult(TedPermissionBase.getSettingIntent((Context)activity), requestCode);
    }

    private static Intent getSettingIntent(Context context) {
        return new Intent("android.settings.APPLICATION_DETAILS_SETTINGS").setData(Uri.parse((String)("package:" + context.getPackageName())));
    }

    public static void startSettingActivityForResult(Fragment fragment) {
        TedPermissionBase.startSettingActivityForResult(fragment, 2000);
    }

    public static void startSettingActivityForResult(Fragment fragment, int requestCode) {
        fragment.startActivityForResult(TedPermissionBase.getSettingIntent((Context)fragment.getActivity()), requestCode);
    }

    static void setFirstRequest(Context context, @NonNull String[] permissions) {
        for (String permission : permissions) {
            TedPermissionBase.setFirstRequest(context, permission);
        }
    }

    private static void setFirstRequest(Context context, String permission) {
        TedPermissionBase.getSharedPreferences(context).edit().putBoolean(TedPermissionBase.getPrefsNamePermission(permission), false).apply();
    }
}

