/*
 * Decompiled with CFR 0.152.
 */
package com.gun0912.tedpermission;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.StringRes;
import com.gun0912.tedpermission.PermissionListener;
import com.gun0912.tedpermission.R;
import com.gun0912.tedpermission.TedPermissionActivity;
import com.gun0912.tedpermission.TedPermissionBase;
import com.gun0912.tedpermission.util.ObjectUtils;

public abstract class PermissionBuilder<T extends PermissionBuilder> {
    private static final String PREFS_NAME_PERMISSION = "PREFS_NAME_PERMISSION";
    private static final String PREFS_IS_FIRST_REQUEST = "PREFS_IS_FIRST_REQUEST";
    private PermissionListener listener;
    private String[] permissions;
    private CharSequence rationaleTitle;
    private CharSequence rationaleMessage;
    private CharSequence denyTitle;
    private CharSequence denyMessage;
    private CharSequence settingButtonText;
    private boolean hasSettingBtn = true;
    private CharSequence deniedCloseButtonText;
    private CharSequence rationaleConfirmText;
    private Context context;

    public PermissionBuilder(Context context) {
        this.context = context;
        this.deniedCloseButtonText = context.getString(R.string.tedpermission_close);
        this.rationaleConfirmText = context.getString(R.string.tedpermission_confirm);
    }

    protected void checkPermissions() {
        if (this.listener == null) {
            throw new IllegalArgumentException("You must setPermissionListener() on TedPermission");
        }
        if (ObjectUtils.isEmpty(this.permissions)) {
            throw new IllegalArgumentException("You must setPermissions() on TedPermission");
        }
        if (Build.VERSION.SDK_INT < 23) {
            this.listener.onPermissionGranted();
            return;
        }
        Intent intent = new Intent(this.context, TedPermissionActivity.class);
        intent.putExtra("permissions", this.permissions);
        intent.putExtra("rationale_title", this.rationaleTitle);
        intent.putExtra("rationale_message", this.rationaleMessage);
        intent.putExtra("deny_title", this.denyTitle);
        intent.putExtra("deny_message", this.denyMessage);
        intent.putExtra("package_name", this.context.getPackageName());
        intent.putExtra("setting_button", this.hasSettingBtn);
        intent.putExtra("denied_dialog_close_text", this.deniedCloseButtonText);
        intent.putExtra("rationale_confirm_text", this.rationaleConfirmText);
        intent.putExtra("setting_button_text", this.settingButtonText);
        intent.addFlags(0x10000000);
        intent.addFlags(262144);
        TedPermissionActivity.startActivity(this.context, intent, this.listener);
        TedPermissionBase.setFirstRequest(this.context, this.permissions);
    }

    public T setPermissionListener(PermissionListener listener) {
        this.listener = listener;
        return (T)this;
    }

    public T setPermissions(String ... permissions) {
        this.permissions = permissions;
        return (T)this;
    }

    public T setRationaleMessage(@StringRes int stringRes) {
        return this.setRationaleMessage(this.getText(stringRes));
    }

    private CharSequence getText(@StringRes int stringRes) {
        if (stringRes <= 0) {
            throw new IllegalArgumentException("Invalid String resource id");
        }
        return this.context.getText(stringRes);
    }

    public T setRationaleMessage(CharSequence rationaleMessage) {
        this.rationaleMessage = rationaleMessage;
        return (T)this;
    }

    public T setRationaleTitle(@StringRes int stringRes) {
        return this.setRationaleTitle(this.getText(stringRes));
    }

    public T setRationaleTitle(CharSequence rationaleMessage) {
        this.rationaleTitle = rationaleMessage;
        return (T)this;
    }

    public T setDeniedMessage(@StringRes int stringRes) {
        return this.setDeniedMessage(this.getText(stringRes));
    }

    public T setDeniedMessage(CharSequence denyMessage) {
        this.denyMessage = denyMessage;
        return (T)this;
    }

    public T setDeniedTitle(@StringRes int stringRes) {
        return this.setDeniedTitle(this.getText(stringRes));
    }

    public T setDeniedTitle(CharSequence denyTitle) {
        this.denyTitle = denyTitle;
        return (T)this;
    }

    public T setGotoSettingButton(boolean hasSettingBtn) {
        this.hasSettingBtn = hasSettingBtn;
        return (T)this;
    }

    public T setGotoSettingButtonText(@StringRes int stringRes) {
        return this.setGotoSettingButtonText(this.getText(stringRes));
    }

    public T setGotoSettingButtonText(CharSequence rationaleConfirmText) {
        this.settingButtonText = rationaleConfirmText;
        return (T)this;
    }

    public T setRationaleConfirmText(@StringRes int stringRes) {
        return this.setRationaleConfirmText(this.getText(stringRes));
    }

    public T setRationaleConfirmText(CharSequence rationaleConfirmText) {
        this.rationaleConfirmText = rationaleConfirmText;
        return (T)this;
    }

    public T setDeniedCloseButtonText(CharSequence deniedCloseButtonText) {
        this.deniedCloseButtonText = deniedCloseButtonText;
        return (T)this;
    }

    public T setDeniedCloseButtonText(@StringRes int stringRes) {
        return this.setDeniedCloseButtonText(this.getText(stringRes));
    }
}

