/*
 * Decompiled with CFR 0.152.
 */
package gun0912.tedimagepicker.util;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import androidx.core.content.FileProvider;
import gun0912.tedimagepicker.builder.type.MediaType;
import gun0912.tedimagepicker.util.MediaUtil$Companion$WhenMappings;
import io.reactivex.Completable;
import io.reactivex.CompletableEmitter;
import io.reactivex.CompletableOnSubscribe;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lgun0912/tedimagepicker/util/MediaUtil;", "", "()V", "Companion", "tedimagepicker_release"})
public final class MediaUtil {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0000\u00a2\u0006\u0002\b\rJ6\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0006\u00a8\u0006\u0013"}, d2={"Lgun0912/tedimagepicker/util/MediaUtil$Companion;", "", "()V", "getMediaIntentUri", "Lkotlin/Pair;", "Landroid/content/Intent;", "Landroid/net/Uri;", "context", "Landroid/content/Context;", "mediaType", "Lgun0912/tedimagepicker/builder/type/MediaType;", "savedDirectoryName", "", "getMediaIntentUri$tedimagepicker_release", "getMediaUri", "cameraIntent", "scanMedia", "Lio/reactivex/Completable;", "uri", "tedimagepicker_release"})
    public static final class Companion {
        @NotNull
        public final Pair<Intent, Uri> getMediaIntentUri$tedimagepicker_release(@NotNull Context context, @NotNull MediaType mediaType, @Nullable String savedDirectoryName) {
            Intent intent;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)((Object)mediaType), (String)"mediaType");
            switch (MediaUtil$Companion$WhenMappings.$EnumSwitchMapping$0[mediaType.ordinal()]) {
                case 1: {
                    intent = new Intent("android.media.action.IMAGE_CAPTURE");
                    break;
                }
                case 2: {
                    intent = new Intent("android.media.action.VIDEO_CAPTURE");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Intent cameraIntent = intent;
            if (cameraIntent.resolveActivity(context.getPackageManager()) == null) {
                throw (Throwable)new PackageManager.NameNotFoundException("Can not start Camera");
            }
            return this.getMediaUri(context, cameraIntent, mediaType, savedDirectoryName);
        }

        private final Pair<Intent, Uri> getMediaUri(Context context, Intent cameraIntent, MediaType mediaType, String savedDirectoryName) {
            Pair pair;
            String timeStamp = new SimpleDateFormat("yyyyMMddHHmmss", Locale.getDefault()).format(new Date());
            String fileName = (Object)((Object)mediaType) + '_' + timeStamp;
            if (Build.VERSION.SDK_INT >= 29) {
                String directoryName = savedDirectoryName != null ? mediaType.getSavedDirectoryName() + '/' + savedDirectoryName : mediaType.getSavedDirectoryName();
                ContentValues contentValues = new ContentValues();
                boolean bl = false;
                boolean bl2 = false;
                ContentValues $this$apply = contentValues;
                boolean bl3 = false;
                $this$apply.put("_display_name", fileName + mediaType.getFileSuffix());
                $this$apply.put("mime_type", mediaType.getMimeType());
                $this$apply.put("relative_path", directoryName);
                ContentValues contentValues2 = contentValues;
                Uri uri = context.getContentResolver().insert(mediaType.getExternalContentUri(), contentValues2);
                if (uri == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"context.contentResolver.\u2026tentUri, contentValues)!!");
                Uri mediaUri = uri;
                cameraIntent.putExtra("output", (Parcelable)mediaUri);
                pair = TuplesKt.to((Object)cameraIntent, (Object)mediaUri);
            } else {
                String string2 = savedDirectoryName;
                if (string2 == null) {
                    string2 = mediaType.getSavedDirectoryName();
                }
                String directoryName = string2;
                File directory = Environment.getExternalStoragePublicDirectory((String)directoryName);
                if (!directory.exists()) {
                    directory.mkdir();
                }
                File file = File.createTempFile(fileName, mediaType.getFileSuffix(), directory);
                StringBuilder stringBuilder = new StringBuilder();
                Context context2 = context.getApplicationContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
                Uri mediaUri = FileProvider.getUriForFile((Context)context, (String)stringBuilder.append(context2.getPackageName()).append(".provider").toString(), (File)file);
                List list = context.getPackageManager().queryIntentActivities(cameraIntent, 65536);
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"context.packageManager\n \u2026nager.MATCH_DEFAULT_ONLY)");
                List resolvedIntentActivities = list;
                for (ResolveInfo resolvedIntentInfo : resolvedIntentActivities) {
                    String packageName = resolvedIntentInfo.activityInfo.packageName;
                    context.grantUriPermission(packageName, mediaUri, 3);
                }
                cameraIntent.putExtra("output", (Parcelable)mediaUri);
                pair = TuplesKt.to((Object)cameraIntent, (Object)Uri.fromFile((File)file));
            }
            return pair;
        }

        @NotNull
        public final Completable scanMedia(@NotNull Context context, @NotNull Uri uri) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
            Completable completable = Completable.create((CompletableOnSubscribe)new CompletableOnSubscribe(context, uri){
                final /* synthetic */ Context $context;
                final /* synthetic */ Uri $uri;

                public final void subscribe(@NotNull CompletableEmitter emitter) {
                    Intrinsics.checkParameterIsNotNull((Object)emitter, (String)"emitter");
                    MediaScannerConnection.scanFile((Context)this.$context, (String[])new String[]{this.$uri.getPath()}, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(emitter){
                        final /* synthetic */ CompletableEmitter $emitter;

                        public final void onScanCompleted(String $noName_0, Uri $noName_1) {
                            this.$emitter.onComplete();
                        }
                        {
                            this.$emitter = completableEmitter;
                        }
                    });
                }
                {
                    this.$context = context;
                    this.$uri = uri;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"Completable.create { emi\u2026omplete() }\n            }");
            return completable;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

