/*
 * Decompiled with CFR 0.152.
 */
package gun0912.tedimagepicker.util;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import androidx.core.content.FileProvider;
import gun0912.tedimagepicker.builder.type.MediaType;
import gun0912.tedimagepicker.util.MediaUtil$Companion$WhenMappings;
import io.reactivex.Completable;
import io.reactivex.CompletableEmitter;
import io.reactivex.CompletableOnSubscribe;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lgun0912/tedimagepicker/util/MediaUtil;", "", "()V", "Companion", "tedimagepicker_release"})
public final class MediaUtil {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J)\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\n\u00a8\u0006\u0011"}, d2={"Lgun0912/tedimagepicker/util/MediaUtil$Companion;", "", "()V", "getMediaFile", "Ljava/io/File;", "mediaType", "Lgun0912/tedimagepicker/builder/type/MediaType;", "getMediaIntentUri", "Lkotlin/Pair;", "Landroid/content/Intent;", "Landroid/net/Uri;", "context", "Landroid/content/Context;", "getMediaIntentUri$tedimagepicker_release", "scanMedia", "Lio/reactivex/Completable;", "uri", "tedimagepicker_release"})
    public static final class Companion {
        @NotNull
        public final Pair<Intent, Uri> getMediaIntentUri$tedimagepicker_release(@NotNull Context context, @NotNull MediaType mediaType) {
            Intent intent;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)((Object)mediaType), (String)"mediaType");
            switch (MediaUtil$Companion$WhenMappings.$EnumSwitchMapping$0[mediaType.ordinal()]) {
                case 1: {
                    intent = new Intent("android.media.action.IMAGE_CAPTURE");
                    break;
                }
                case 2: {
                    intent = new Intent("android.media.action.VIDEO_CAPTURE");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Intent cameraIntent = intent;
            File mediaFile = this.getMediaFile(mediaType);
            if (cameraIntent.resolveActivity(context.getPackageManager()) == null) {
                throw (Throwable)new PackageManager.NameNotFoundException("Can not start Camera");
            }
            StringBuilder stringBuilder = new StringBuilder();
            Context context2 = context.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
            Uri photoURI = FileProvider.getUriForFile((Context)context, (String)stringBuilder.append(context2.getPackageName()).append(".provider").toString(), (File)mediaFile);
            List resolvedIntentActivities = context.getPackageManager().queryIntentActivities(cameraIntent, 65536);
            for (ResolveInfo resolvedIntentInfo : resolvedIntentActivities) {
                String packageName = resolvedIntentInfo.activityInfo.packageName;
                context.grantUriPermission(packageName, photoURI, 3);
            }
            cameraIntent.putExtra("output", (Parcelable)photoURI);
            return new Pair((Object)cameraIntent, (Object)Uri.fromFile((File)mediaFile));
        }

        private final File getMediaFile(MediaType mediaType) {
            String string2;
            String string3;
            String timeStamp = new SimpleDateFormat("yyyyMMddHHmmss", Locale.getDefault()).format(new Date());
            String fileName = (Object)((Object)mediaType) + '_' + timeStamp;
            switch (MediaUtil$Companion$WhenMappings.$EnumSwitchMapping$1[mediaType.ordinal()]) {
                case 1: {
                    string3 = Environment.DIRECTORY_PICTURES;
                    break;
                }
                case 2: {
                    string3 = Environment.DIRECTORY_MOVIES;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String directoryType = string3;
            File directory = Environment.getExternalStoragePublicDirectory((String)directoryType);
            if (!directory.exists()) {
                directory.mkdir();
            }
            switch (MediaUtil$Companion$WhenMappings.$EnumSwitchMapping$2[mediaType.ordinal()]) {
                case 1: {
                    string2 = ".jpg";
                    break;
                }
                case 2: {
                    string2 = ".mp4";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            String fileSuffix = string2;
            File file = File.createTempFile(fileName, fileSuffix, directory);
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"File.createTempFile(file\u2026e, fileSuffix, directory)");
            return file;
        }

        @NotNull
        public final Completable scanMedia(@NotNull Context context, @NotNull Uri uri) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
            Completable completable = Completable.create((CompletableOnSubscribe)new CompletableOnSubscribe(context, uri){
                final /* synthetic */ Context $context;
                final /* synthetic */ Uri $uri;

                public final void subscribe(@NotNull CompletableEmitter emitter) {
                    Intrinsics.checkParameterIsNotNull((Object)emitter, (String)"emitter");
                    MediaScannerConnection.scanFile((Context)this.$context, (String[])new String[]{this.$uri.getPath()}, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(emitter){
                        final /* synthetic */ CompletableEmitter $emitter;

                        public final void onScanCompleted(String $noName_0, Uri $noName_1) {
                            this.$emitter.onComplete();
                        }
                        {
                            this.$emitter = completableEmitter;
                        }
                    });
                }
                {
                    this.$context = context;
                    this.$uri = uri;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"Completable.create { emi\u2026omplete() }\n            }");
            return completable;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

