/*
 * Decompiled with CFR 0.152.
 */
package gun0912.tedbottompicker;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Drawable;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.design.widget.BottomSheetBehavior;
import android.support.design.widget.BottomSheetDialogFragment;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.FileProvider;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.gun0912.tedonactivityresult.TedOnActivityResult;
import com.gun0912.tedonactivityresult.listener.OnActivityResultListener;
import gun0912.tedbottompicker.GridSpacingItemDecoration;
import gun0912.tedbottompicker.R;
import gun0912.tedbottompicker.adapter.GalleryAdapter;
import gun0912.tedbottompicker.util.RealPathUtil;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class TedBottomSheetDialogFragment
extends BottomSheetDialogFragment {
    private static final String EXTRA_CAMERA_IMAGE_URI = "camera_image_uri";
    private static final String EXTRA_CAMERA_SELECTED_IMAGE_URI = "camera_selected_image_uri";
    public BaseBuilder builder;
    private GalleryAdapter imageGalleryAdapter;
    private View view_title_container;
    private TextView tv_title;
    private Button btn_done;
    private FrameLayout selected_photos_container_frame;
    private LinearLayout selected_photos_container;
    private TextView selected_photos_empty;
    private List<Uri> selectedUriList;
    private List<Uri> tempUriList;
    private Uri cameraImageUri;
    private RecyclerView rc_gallery;
    private BottomSheetBehavior.BottomSheetCallback mBottomSheetBehaviorCallback = new BottomSheetBehavior.BottomSheetCallback(){

        public void onStateChanged(@NonNull View bottomSheet, int newState) {
            if (newState == 5) {
                TedBottomSheetDialogFragment.this.dismissAllowingStateLoss();
            }
        }

        public void onSlide(@NonNull View bottomSheet, float slideOffset) {
        }
    };

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setupSavedInstanceState(savedInstanceState);
    }

    private void setupSavedInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            this.cameraImageUri = this.builder.selectedUri;
            this.tempUriList = this.builder.selectedUriList;
        } else {
            this.cameraImageUri = (Uri)savedInstanceState.getParcelable(EXTRA_CAMERA_IMAGE_URI);
            this.tempUriList = savedInstanceState.getParcelableArrayList(EXTRA_CAMERA_SELECTED_IMAGE_URI);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putParcelable(EXTRA_CAMERA_IMAGE_URI, (Parcelable)this.cameraImageUri);
        outState.putParcelableArrayList(EXTRA_CAMERA_SELECTED_IMAGE_URI, new ArrayList<Uri>(this.selectedUriList));
        super.onSaveInstanceState(outState);
    }

    public void show(FragmentManager fragmentManager) {
        FragmentTransaction ft = fragmentManager.beginTransaction();
        ft.add((Fragment)this, this.getTag());
        ft.commitAllowingStateLoss();
    }

    public void setupDialog(Dialog dialog, int style) {
        super.setupDialog(dialog, style);
        View contentView = View.inflate((Context)this.getContext(), (int)R.layout.tedbottompicker_content_view, null);
        dialog.setContentView(contentView);
        CoordinatorLayout.LayoutParams layoutParams = (CoordinatorLayout.LayoutParams)((View)contentView.getParent()).getLayoutParams();
        CoordinatorLayout.Behavior behavior = layoutParams.getBehavior();
        if (behavior instanceof BottomSheetBehavior) {
            ((BottomSheetBehavior)behavior).setBottomSheetCallback(this.mBottomSheetBehaviorCallback);
            if (this.builder != null && this.builder.peekHeight > 0) {
                ((BottomSheetBehavior)behavior).setPeekHeight(this.builder.peekHeight);
            }
        }
        this.initView(contentView);
        this.setTitle();
        this.setRecyclerView();
        this.setSelectionView();
        this.selectedUriList = new ArrayList<Uri>();
        if (this.builder.onImageSelectedListener != null && this.cameraImageUri != null) {
            this.addUri(this.cameraImageUri);
        } else if (this.builder.onMultiImageSelectedListener != null && this.tempUriList != null) {
            for (Uri uri : this.tempUriList) {
                this.addUri(uri);
            }
        }
        this.setDoneButton();
        this.checkMultiMode();
    }

    private void setSelectionView() {
        if (this.builder.emptySelectionText != null) {
            this.selected_photos_empty.setText((CharSequence)this.builder.emptySelectionText);
        }
    }

    private void setDoneButton() {
        if (this.builder.completeButtonText != null) {
            this.btn_done.setText((CharSequence)this.builder.completeButtonText);
        }
        this.btn_done.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TedBottomSheetDialogFragment.this.onMultiSelectComplete();
            }
        });
    }

    private void onMultiSelectComplete() {
        if (this.selectedUriList.size() < this.builder.selectMinCount) {
            String message = this.builder.selectMinCountErrorText != null ? this.builder.selectMinCountErrorText : String.format(this.getResources().getString(R.string.select_min_count), this.builder.selectMinCount);
            Toast.makeText((Context)this.getActivity(), (CharSequence)message, (int)0).show();
            return;
        }
        this.builder.onMultiImageSelectedListener.onImagesSelected(this.selectedUriList);
        this.dismissAllowingStateLoss();
    }

    private void checkMultiMode() {
        if (!this.isMultiSelect()) {
            this.btn_done.setVisibility(8);
            this.selected_photos_container_frame.setVisibility(8);
        }
    }

    private void initView(View contentView) {
        this.view_title_container = contentView.findViewById(R.id.view_title_container);
        this.rc_gallery = (RecyclerView)contentView.findViewById(R.id.rc_gallery);
        this.tv_title = (TextView)contentView.findViewById(R.id.tv_title);
        this.btn_done = (Button)contentView.findViewById(R.id.btn_done);
        this.selected_photos_container_frame = (FrameLayout)contentView.findViewById(R.id.selected_photos_container_frame);
        this.selected_photos_container = (LinearLayout)contentView.findViewById(R.id.selected_photos_container);
        this.selected_photos_empty = (TextView)contentView.findViewById(R.id.selected_photos_empty);
    }

    private void setRecyclerView() {
        GridLayoutManager gridLayoutManager = new GridLayoutManager((Context)this.getActivity(), 3);
        this.rc_gallery.setLayoutManager((RecyclerView.LayoutManager)gridLayoutManager);
        this.rc_gallery.addItemDecoration((RecyclerView.ItemDecoration)new GridSpacingItemDecoration(gridLayoutManager.getSpanCount(), this.builder.spacing, this.builder.includeEdgeSpacing));
        this.updateAdapter();
    }

    private void updateAdapter() {
        this.imageGalleryAdapter = new GalleryAdapter((Context)this.getActivity(), this.builder);
        this.rc_gallery.setAdapter((RecyclerView.Adapter)this.imageGalleryAdapter);
        this.imageGalleryAdapter.setOnItemClickListener(new GalleryAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(View view, int position) {
                GalleryAdapter.PickerTile pickerTile = TedBottomSheetDialogFragment.this.imageGalleryAdapter.getItem(position);
                switch (pickerTile.getTileType()) {
                    case 2: {
                        TedBottomSheetDialogFragment.this.startCameraIntent();
                        break;
                    }
                    case 3: {
                        TedBottomSheetDialogFragment.this.startGalleryIntent();
                        break;
                    }
                    case 1: {
                        if (pickerTile.getImageUri() == null) break;
                        TedBottomSheetDialogFragment.this.complete(pickerTile.getImageUri());
                        break;
                    }
                    default: {
                        TedBottomSheetDialogFragment.this.errorMessage();
                    }
                }
            }
        });
    }

    private void complete(Uri uri) {
        if (this.isMultiSelect()) {
            if (this.selectedUriList.contains(uri)) {
                this.removeImage(uri);
            } else {
                this.addUri(uri);
            }
        } else {
            this.builder.onImageSelectedListener.onImageSelected(uri);
            this.dismissAllowingStateLoss();
        }
    }

    private void addUri(final Uri uri) {
        if (this.selectedUriList.size() == this.builder.selectMaxCount) {
            String message = this.builder.selectMaxCountErrorText != null ? this.builder.selectMaxCountErrorText : String.format(this.getResources().getString(R.string.select_max_count), this.builder.selectMaxCount);
            Toast.makeText((Context)this.getActivity(), (CharSequence)message, (int)0).show();
            return;
        }
        this.selectedUriList.add(uri);
        View rootView = LayoutInflater.from((Context)this.getActivity()).inflate(R.layout.tedbottompicker_selected_item, null);
        ImageView thumbnail = (ImageView)rootView.findViewById(R.id.selected_photo);
        ImageView iv_close = (ImageView)rootView.findViewById(R.id.iv_close);
        rootView.setTag((Object)uri);
        this.selected_photos_container.addView(rootView, 0);
        int px = (int)this.getResources().getDimension(R.dimen.tedbottompicker_selected_image_height);
        thumbnail.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(px, px));
        if (this.builder.imageProvider == null) {
            Glide.with((FragmentActivity)this.getActivity()).load(uri).thumbnail(0.1f).apply(((RequestOptions)((RequestOptions)new RequestOptions().centerCrop()).placeholder(R.drawable.ic_gallery)).error(R.drawable.img_error)).into(thumbnail);
        } else {
            this.builder.imageProvider.onProvideImage(thumbnail, uri);
        }
        if (this.builder.deSelectIconDrawable != null) {
            iv_close.setImageDrawable(this.builder.deSelectIconDrawable);
        }
        iv_close.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TedBottomSheetDialogFragment.this.removeImage(uri);
            }
        });
        this.updateSelectedView();
        this.imageGalleryAdapter.setSelectedUriList(this.selectedUriList, uri);
    }

    private void removeImage(Uri uri) {
        this.selectedUriList.remove(uri);
        for (int i = 0; i < this.selected_photos_container.getChildCount(); ++i) {
            View childView = this.selected_photos_container.getChildAt(i);
            if (!childView.getTag().equals(uri)) continue;
            this.selected_photos_container.removeViewAt(i);
            break;
        }
        this.updateSelectedView();
        this.imageGalleryAdapter.setSelectedUriList(this.selectedUriList, uri);
    }

    private void updateSelectedView() {
        if (this.selectedUriList == null || this.selectedUriList.size() == 0) {
            this.selected_photos_empty.setVisibility(0);
            this.selected_photos_container.setVisibility(8);
        } else {
            this.selected_photos_empty.setVisibility(8);
            this.selected_photos_container.setVisibility(0);
        }
    }

    private void startCameraIntent() {
        File mediaFile;
        Intent cameraInent;
        if (this.builder.mediaType == 1) {
            cameraInent = new Intent("android.media.action.IMAGE_CAPTURE");
            mediaFile = this.getImageFile();
        } else {
            cameraInent = new Intent("android.media.action.VIDEO_CAPTURE");
            mediaFile = this.getVideoFile();
        }
        if (cameraInent.resolveActivity(this.getActivity().getPackageManager()) == null) {
            this.errorMessage("This Application do not have Camera Application");
            return;
        }
        Uri photoURI = FileProvider.getUriForFile((Context)this.getContext(), (String)(this.getContext().getApplicationContext().getPackageName() + ".provider"), (File)mediaFile);
        List resolvedIntentActivities = this.getContext().getPackageManager().queryIntentActivities(cameraInent, 65536);
        for (ResolveInfo resolvedIntentInfo : resolvedIntentActivities) {
            String packageName = resolvedIntentInfo.activityInfo.packageName;
            this.getContext().grantUriPermission(packageName, photoURI, 3);
        }
        cameraInent.putExtra("output", (Parcelable)photoURI);
        TedOnActivityResult.with((Context)this.getActivity()).setIntent(cameraInent).setListener(new OnActivityResultListener(){

            public void onActivityResult(int resultCode, Intent data) {
                if (resultCode == -1) {
                    TedBottomSheetDialogFragment.this.onActivityResultCamera(TedBottomSheetDialogFragment.this.cameraImageUri);
                }
            }
        }).startActivityForResult();
    }

    private File getImageFile() {
        File imageFile = null;
        try {
            String timeStamp = new SimpleDateFormat("yyyyMMddHHmmss", Locale.getDefault()).format(new Date());
            String imageFileName = "JPEG_" + timeStamp + "_";
            File storageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
            if (!storageDir.exists()) {
                storageDir.mkdirs();
            }
            imageFile = File.createTempFile(imageFileName, ".jpg", storageDir);
            this.cameraImageUri = Uri.fromFile((File)imageFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.errorMessage("Could not create imageFile for camera");
        }
        return imageFile;
    }

    private File getVideoFile() {
        File videoFile = null;
        try {
            String timeStamp = new SimpleDateFormat("yyyyMMddHHmmss", Locale.getDefault()).format(new Date());
            String imageFileName = "VIDEO_" + timeStamp + "_";
            File storageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_MOVIES);
            if (!storageDir.exists()) {
                storageDir.mkdirs();
            }
            videoFile = File.createTempFile(imageFileName, ".mp4", storageDir);
            this.cameraImageUri = Uri.fromFile((File)videoFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.errorMessage("Could not create imageFile for camera");
        }
        return videoFile;
    }

    private void errorMessage(String message) {
        String errorMessage;
        String string2 = errorMessage = message == null ? "Something wrong." : message;
        if (this.builder.onErrorListener == null) {
            Toast.makeText((Context)this.getActivity(), (CharSequence)errorMessage, (int)0).show();
        } else {
            this.builder.onErrorListener.onError(errorMessage);
        }
    }

    private void startGalleryIntent() {
        Intent galleryIntent;
        if (this.builder.mediaType == 1) {
            galleryIntent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
            galleryIntent.setType("image/*");
        } else {
            galleryIntent = new Intent("android.intent.action.PICK", MediaStore.Video.Media.EXTERNAL_CONTENT_URI);
            galleryIntent.setType("video/*");
        }
        if (galleryIntent.resolveActivity(this.getActivity().getPackageManager()) == null) {
            this.errorMessage("This Application do not have Gallery Application");
            return;
        }
        TedOnActivityResult.with((Context)this.getActivity()).setIntent(galleryIntent).setListener(new OnActivityResultListener(){

            public void onActivityResult(int resultCode, Intent data) {
                if (resultCode == -1) {
                    TedBottomSheetDialogFragment.this.onActivityResultGallery(data);
                }
            }
        }).startActivityForResult();
    }

    private void errorMessage() {
        this.errorMessage(null);
    }

    private void setTitle() {
        if (!this.builder.showTitle) {
            this.tv_title.setVisibility(8);
            if (!this.isMultiSelect()) {
                this.view_title_container.setVisibility(8);
            }
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.builder.title)) {
            this.tv_title.setText((CharSequence)this.builder.title);
        }
        if (this.builder.titleBackgroundResId > 0) {
            this.tv_title.setBackgroundResource(this.builder.titleBackgroundResId);
        }
    }

    private boolean isMultiSelect() {
        return this.builder.onMultiImageSelectedListener != null;
    }

    private void onActivityResultCamera(final Uri cameraImageUri) {
        MediaScannerConnection.scanFile((Context)this.getContext(), (String[])new String[]{cameraImageUri.getPath()}, (String[])new String[]{"image/jpeg"}, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.MediaScannerConnectionClient(){

            public void onMediaScannerConnected() {
            }

            public void onScanCompleted(String s, Uri uri) {
                TedBottomSheetDialogFragment.this.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        TedBottomSheetDialogFragment.this.updateAdapter();
                        TedBottomSheetDialogFragment.this.complete(cameraImageUri);
                    }
                });
            }
        });
    }

    private void onActivityResultGallery(Intent data) {
        Uri selectedImageUri;
        Uri temp = data.getData();
        if (temp == null) {
            this.errorMessage();
        }
        String realPath = RealPathUtil.getRealPath((Context)this.getActivity(), temp);
        try {
            selectedImageUri = Uri.fromFile((File)new File(realPath));
        }
        catch (Exception ex) {
            selectedImageUri = Uri.parse((String)realPath);
        }
        this.complete(selectedImageUri);
    }

    public static abstract class BaseBuilder<T extends BaseBuilder> {
        public int previewMaxCount = 25;
        public Drawable cameraTileDrawable;
        public Drawable galleryTileDrawable;
        public Drawable selectedForegroundDrawable;
        public ImageProvider imageProvider;
        public boolean showCamera = true;
        public boolean showGallery = true;
        public int cameraTileBackgroundResId = R.color.tedbottompicker_camera;
        public int galleryTileBackgroundResId = R.color.tedbottompicker_gallery;
        public int mediaType = 1;
        protected FragmentActivity fragmentActivity;
        OnImageSelectedListener onImageSelectedListener;
        OnMultiImageSelectedListener onMultiImageSelectedListener;
        OnErrorListener onErrorListener;
        private String title;
        private boolean showTitle = true;
        private List<Uri> selectedUriList;
        private Uri selectedUri;
        private Drawable deSelectIconDrawable;
        private int spacing = 1;
        private boolean includeEdgeSpacing = false;
        private int peekHeight = -1;
        private int titleBackgroundResId;
        private int selectMaxCount = Integer.MAX_VALUE;
        private int selectMinCount = 0;
        private String completeButtonText;
        private String emptySelectionText;
        private String selectMaxCountErrorText;
        private String selectMinCountErrorText;

        public BaseBuilder(@NonNull FragmentActivity fragmentActivity) {
            this.fragmentActivity = fragmentActivity;
            this.setCameraTile(R.drawable.ic_camera);
            this.setGalleryTile(R.drawable.ic_gallery);
            this.setSpacingResId(R.dimen.tedbottompicker_grid_layout_margin);
        }

        public T setCameraTile(@DrawableRes int cameraTileResId) {
            this.setCameraTile(ContextCompat.getDrawable((Context)this.fragmentActivity, (int)cameraTileResId));
            return (T)this;
        }

        public BaseBuilder<T> setGalleryTile(@DrawableRes int galleryTileResId) {
            this.setGalleryTile(ContextCompat.getDrawable((Context)this.fragmentActivity, (int)galleryTileResId));
            return this;
        }

        public T setSpacingResId(@DimenRes int dimenResId) {
            this.spacing = this.fragmentActivity.getResources().getDimensionPixelSize(dimenResId);
            return (T)this;
        }

        public T setCameraTile(Drawable cameraTileDrawable) {
            this.cameraTileDrawable = cameraTileDrawable;
            return (T)this;
        }

        public T setGalleryTile(Drawable galleryTileDrawable) {
            this.galleryTileDrawable = galleryTileDrawable;
            return (T)this;
        }

        public T setDeSelectIcon(@DrawableRes int deSelectIconResId) {
            this.setDeSelectIcon(ContextCompat.getDrawable((Context)this.fragmentActivity, (int)deSelectIconResId));
            return (T)this;
        }

        public T setDeSelectIcon(Drawable deSelectIconDrawable) {
            this.deSelectIconDrawable = deSelectIconDrawable;
            return (T)this;
        }

        public T setSelectedForeground(@DrawableRes int selectedForegroundResId) {
            this.setSelectedForeground(ContextCompat.getDrawable((Context)this.fragmentActivity, (int)selectedForegroundResId));
            return (T)this;
        }

        public T setSelectedForeground(Drawable selectedForegroundDrawable) {
            this.selectedForegroundDrawable = selectedForegroundDrawable;
            return (T)this;
        }

        public T setPreviewMaxCount(int previewMaxCount) {
            this.previewMaxCount = previewMaxCount;
            return (T)this;
        }

        public T setSelectMaxCount(int selectMaxCount) {
            this.selectMaxCount = selectMaxCount;
            return (T)this;
        }

        public T setSelectMinCount(int selectMinCount) {
            this.selectMinCount = selectMinCount;
            return (T)this;
        }

        public T setOnImageSelectedListener(OnImageSelectedListener onImageSelectedListener) {
            this.onImageSelectedListener = onImageSelectedListener;
            return (T)this;
        }

        public T setOnMultiImageSelectedListener(OnMultiImageSelectedListener onMultiImageSelectedListener) {
            this.onMultiImageSelectedListener = onMultiImageSelectedListener;
            return (T)this;
        }

        public T setOnErrorListener(OnErrorListener onErrorListener) {
            this.onErrorListener = onErrorListener;
            return (T)this;
        }

        public T showCameraTile(boolean showCamera) {
            this.showCamera = showCamera;
            return (T)this;
        }

        public T showGalleryTile(boolean showGallery) {
            this.showGallery = showGallery;
            return (T)this;
        }

        public T setSpacing(int spacing) {
            this.spacing = spacing;
            return (T)this;
        }

        public T setIncludeEdgeSpacing(boolean includeEdgeSpacing) {
            this.includeEdgeSpacing = includeEdgeSpacing;
            return (T)this;
        }

        public T setPeekHeight(int peekHeight) {
            this.peekHeight = peekHeight;
            return (T)this;
        }

        public T setPeekHeightResId(@DimenRes int dimenResId) {
            this.peekHeight = this.fragmentActivity.getResources().getDimensionPixelSize(dimenResId);
            return (T)this;
        }

        public T setCameraTileBackgroundResId(@ColorRes int colorResId) {
            this.cameraTileBackgroundResId = colorResId;
            return (T)this;
        }

        public T setGalleryTileBackgroundResId(@ColorRes int colorResId) {
            this.galleryTileBackgroundResId = colorResId;
            return (T)this;
        }

        public T setTitle(String title) {
            this.title = title;
            return (T)this;
        }

        public T setTitle(@StringRes int stringResId) {
            this.title = this.fragmentActivity.getResources().getString(stringResId);
            return (T)this;
        }

        public T showTitle(boolean showTitle) {
            this.showTitle = showTitle;
            return (T)this;
        }

        public T setCompleteButtonText(String completeButtonText) {
            this.completeButtonText = completeButtonText;
            return (T)this;
        }

        public T setCompleteButtonText(@StringRes int completeButtonResId) {
            this.completeButtonText = this.fragmentActivity.getResources().getString(completeButtonResId);
            return (T)this;
        }

        public T setEmptySelectionText(String emptySelectionText) {
            this.emptySelectionText = emptySelectionText;
            return (T)this;
        }

        public T setEmptySelectionText(@StringRes int emptySelectionResId) {
            this.emptySelectionText = this.fragmentActivity.getResources().getString(emptySelectionResId);
            return (T)this;
        }

        public T setSelectMaxCountErrorText(String selectMaxCountErrorText) {
            this.selectMaxCountErrorText = selectMaxCountErrorText;
            return (T)this;
        }

        public T setSelectMaxCountErrorText(@StringRes int selectMaxCountErrorResId) {
            this.selectMaxCountErrorText = this.fragmentActivity.getResources().getString(selectMaxCountErrorResId);
            return (T)this;
        }

        public T setSelectMinCountErrorText(String selectMinCountErrorText) {
            this.selectMinCountErrorText = selectMinCountErrorText;
            return (T)this;
        }

        public T setSelectMinCountErrorText(@StringRes int selectMinCountErrorResId) {
            this.selectMinCountErrorText = this.fragmentActivity.getResources().getString(selectMinCountErrorResId);
            return (T)this;
        }

        public T setTitleBackgroundResId(@ColorRes int colorResId) {
            this.titleBackgroundResId = colorResId;
            return (T)this;
        }

        public T setImageProvider(ImageProvider imageProvider) {
            this.imageProvider = imageProvider;
            return (T)this;
        }

        public T setSelectedUriList(List<Uri> selectedUriList) {
            this.selectedUriList = selectedUriList;
            return (T)this;
        }

        public T setSelectedUri(Uri selectedUri) {
            this.selectedUri = selectedUri;
            return (T)this;
        }

        public T showVideoMedia() {
            this.mediaType = 2;
            return (T)this;
        }

        public TedBottomSheetDialogFragment create() {
            if (Build.VERSION.SDK_INT >= 16 && ContextCompat.checkSelfPermission((Context)this.fragmentActivity, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                throw new RuntimeException("Missing required WRITE_EXTERNAL_STORAGE permission. Did you remember to request it first?");
            }
            if (this.onImageSelectedListener == null && this.onMultiImageSelectedListener == null) {
                throw new RuntimeException("You have to use setOnImageSelectedListener() or setOnMultiImageSelectedListener() for receive selected Uri");
            }
            TedBottomSheetDialogFragment customBottomSheetDialogFragment = new TedBottomSheetDialogFragment();
            customBottomSheetDialogFragment.builder = this;
            return customBottomSheetDialogFragment;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface MediaType {
            public static final int IMAGE = 1;
            public static final int VIDEO = 2;
        }
    }

    public static interface ImageProvider {
        public void onProvideImage(ImageView var1, Uri var2);
    }

    public static interface OnErrorListener {
        public void onError(String var1);
    }

    public static interface OnImageSelectedListener {
        public void onImageSelected(Uri var1);
    }

    public static interface OnMultiImageSelectedListener {
        public void onImagesSelected(List<Uri> var1);
    }
}

