/*
 * Decompiled with CFR 0.152.
 */
package gun0912.tedbottompicker.adapter;

import android.content.Context;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import gun0912.tedbottompicker.R;
import gun0912.tedbottompicker.TedBottomSheetDialogFragment;
import gun0912.tedbottompicker.view.TedSquareFrameLayout;
import gun0912.tedbottompicker.view.TedSquareImageView;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class GalleryAdapter
extends RecyclerView.Adapter<GalleryViewHolder> {
    private ArrayList<PickerTile> pickerTiles;
    private Context context;
    private TedBottomSheetDialogFragment.BaseBuilder builder;
    private OnItemClickListener onItemClickListener;
    private List<Uri> selectedUriList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GalleryAdapter(Context context, TedBottomSheetDialogFragment.BaseBuilder builder) {
        this.context = context;
        this.builder = builder;
        this.pickerTiles = new ArrayList();
        this.selectedUriList = new ArrayList<Uri>();
        if (builder.showCamera) {
            this.pickerTiles.add(new PickerTile(2));
        }
        if (builder.showGallery) {
            this.pickerTiles.add(new PickerTile(3));
        }
        Cursor cursor = null;
        try {
            String orderBy;
            String[] columns;
            Uri uri;
            if (builder.mediaType == 1) {
                uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                columns = new String[]{"_data"};
                orderBy = "date_added DESC";
            } else {
                uri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                columns = new String[]{"_data"};
                orderBy = "date_added DESC";
            }
            cursor = context.getApplicationContext().getContentResolver().query(uri, columns, null, null, orderBy);
            if (cursor != null) {
                for (int count = 0; cursor.moveToNext() && count < builder.previewMaxCount; ++count) {
                    String dataIndex = builder.mediaType == 1 ? "_data" : "_data";
                    String imageLocation = cursor.getString(cursor.getColumnIndex(dataIndex));
                    File imageFile = new File(imageLocation);
                    this.pickerTiles.add(new PickerTile(Uri.fromFile((File)imageFile)));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
    }

    public void setSelectedUriList(List<Uri> selectedUriList, @NonNull Uri uri) {
        this.selectedUriList = selectedUriList;
        int position = -1;
        for (int i = 0; i < this.pickerTiles.size(); ++i) {
            PickerTile pickerTile = this.pickerTiles.get(i);
            if (!pickerTile.isImageTile() || !uri.equals((Object)pickerTile.getImageUri())) continue;
            position = i;
            break;
        }
        if (position > 0) {
            this.notifyItemChanged(position);
        }
    }

    @NonNull
    public GalleryViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = View.inflate((Context)this.context, (int)R.layout.tedbottompicker_grid_item, null);
        return new GalleryViewHolder(view);
    }

    public void onBindViewHolder(final @NonNull GalleryViewHolder holder, int position) {
        PickerTile pickerTile = this.getItem(position);
        boolean isSelected = false;
        if (pickerTile.isCameraTile()) {
            holder.iv_thumbnail.setBackgroundResource(this.builder.cameraTileBackgroundResId);
            holder.iv_thumbnail.setImageDrawable(this.builder.cameraTileDrawable);
        } else if (pickerTile.isGalleryTile()) {
            holder.iv_thumbnail.setBackgroundResource(this.builder.galleryTileBackgroundResId);
            holder.iv_thumbnail.setImageDrawable(this.builder.galleryTileDrawable);
        } else {
            Uri uri = pickerTile.getImageUri();
            if (this.builder.imageProvider == null) {
                Glide.with((Context)this.context).load(uri).thumbnail(0.1f).apply(new RequestOptions().centerCrop().placeholder(R.drawable.ic_gallery).error(R.drawable.img_error)).into((ImageView)holder.iv_thumbnail);
            } else {
                this.builder.imageProvider.onProvideImage(holder.iv_thumbnail, uri);
            }
            isSelected = this.selectedUriList.contains(uri);
        }
        if (holder.root != null) {
            Drawable foregroundDrawable = this.builder.selectedForegroundDrawable != null ? this.builder.selectedForegroundDrawable : ContextCompat.getDrawable((Context)this.context, (int)R.drawable.gallery_photo_selected);
            holder.root.setForeground((Drawable)(isSelected ? foregroundDrawable : null));
        }
        if (this.onItemClickListener != null) {
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    GalleryAdapter.this.onItemClickListener.onItemClick(holder.itemView, holder.getAdapterPosition());
                }
            });
        }
    }

    public PickerTile getItem(int position) {
        return this.pickerTiles.get(position);
    }

    public int getItemCount() {
        return this.pickerTiles.size();
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    class GalleryViewHolder
    extends RecyclerView.ViewHolder {
        TedSquareFrameLayout root;
        TedSquareImageView iv_thumbnail;

        private GalleryViewHolder(View view) {
            super(view);
            this.root = (TedSquareFrameLayout)view.findViewById(R.id.root);
            this.iv_thumbnail = (TedSquareImageView)view.findViewById(R.id.iv_thumbnail);
        }
    }

    public static class PickerTile {
        public static final int IMAGE = 1;
        public static final int CAMERA = 2;
        public static final int GALLERY = 3;
        private final Uri imageUri;
        private final int tileType;

        private PickerTile(int tileType) {
            this(null, tileType);
        }

        private PickerTile(@Nullable Uri imageUri, int tileType) {
            this.imageUri = imageUri;
            this.tileType = tileType;
        }

        PickerTile(@NonNull Uri imageUri) {
            this(imageUri, 1);
        }

        @Nullable
        public Uri getImageUri() {
            return this.imageUri;
        }

        public int getTileType() {
            return this.tileType;
        }

        public String toString() {
            if (this.isImageTile()) {
                return "ImageTile: " + this.imageUri;
            }
            if (this.isCameraTile()) {
                return "CameraTile";
            }
            if (this.isGalleryTile()) {
                return "PickerTile";
            }
            return "Invalid item";
        }

        private boolean isImageTile() {
            return this.tileType == 1;
        }

        private boolean isCameraTile() {
            return this.tileType == 2;
        }

        private boolean isGalleryTile() {
            return this.tileType == 3;
        }
    }

    public static interface OnItemClickListener {
        public void onItemClick(View var1, int var2);
    }
}

