/*
 * Decompiled with CFR 0.152.
 */
package gun0912.tedbottompicker;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.design.widget.BottomSheetBehavior;
import android.support.design.widget.BottomSheetDialogFragment;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import gun0912.tedbottompicker.GridSpacingItemDecoration;
import gun0912.tedbottompicker.R;
import gun0912.tedbottompicker.adapter.ImageGalleryAdapter;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class TedBottomPicker
extends BottomSheetDialogFragment {
    public static final String TAG = "ted";
    static final int REQ_CODE_CAMERA = 1;
    static final int REQ_CODE_GALLERY = 2;
    ImageGalleryAdapter imageGalleryAdapter;
    Builder builder;
    TextView tv_title;
    private RecyclerView rc_gallery;
    private BottomSheetBehavior.BottomSheetCallback mBottomSheetBehaviorCallback = new BottomSheetBehavior.BottomSheetCallback(){

        public void onStateChanged(@NonNull View bottomSheet, int newState) {
            if (newState == 5) {
                TedBottomPicker.this.dismiss();
            }
        }

        public void onSlide(@NonNull View bottomSheet, float slideOffset) {
        }
    };
    private Uri cameraImageUri;

    public void show(FragmentManager fragmentManager) {
        FragmentTransaction ft = fragmentManager.beginTransaction();
        ft.add((Fragment)this, this.getTag());
        ft.commitAllowingStateLoss();
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        return super.onCreateDialog(savedInstanceState);
    }

    public void onViewCreated(View contentView, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(contentView, savedInstanceState);
    }

    public void setupDialog(Dialog dialog, int style) {
        super.setupDialog(dialog, style);
        View contentView = View.inflate((Context)this.getContext(), (int)R.layout.bottom_sheet_dialog_content_view, null);
        dialog.setContentView(contentView);
        CoordinatorLayout.LayoutParams layoutParams = (CoordinatorLayout.LayoutParams)((View)contentView.getParent()).getLayoutParams();
        CoordinatorLayout.Behavior behavior = layoutParams.getBehavior();
        if (behavior != null && behavior instanceof BottomSheetBehavior) {
            ((BottomSheetBehavior)behavior).setBottomSheetCallback(this.mBottomSheetBehaviorCallback);
            if (this.builder.peekHeight > 0) {
                ((BottomSheetBehavior)behavior).setPeekHeight(this.builder.peekHeight);
            }
        }
        this.rc_gallery = (RecyclerView)contentView.findViewById(R.id.rc_gallery);
        this.setRecyclerView();
        this.tv_title = (TextView)contentView.findViewById(R.id.tv_title);
        this.setTitle();
    }

    private void setRecyclerView() {
        GridLayoutManager gridLayoutManager = new GridLayoutManager((Context)this.getActivity(), 3);
        this.rc_gallery.setLayoutManager((RecyclerView.LayoutManager)gridLayoutManager);
        this.rc_gallery.addItemDecoration((RecyclerView.ItemDecoration)new GridSpacingItemDecoration(gridLayoutManager.getSpanCount(), this.builder.spacing, false));
        this.imageGalleryAdapter = new ImageGalleryAdapter((Context)this.getActivity(), this.builder);
        this.rc_gallery.setAdapter((RecyclerView.Adapter)this.imageGalleryAdapter);
        this.imageGalleryAdapter.setOnItemClickListener(new ImageGalleryAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(View view, int position) {
                ImageGalleryAdapter.PickerTile pickerTile = TedBottomPicker.this.imageGalleryAdapter.getItem(position);
                switch (pickerTile.getTileType()) {
                    case 2: {
                        TedBottomPicker.this.startCameraIntent();
                        break;
                    }
                    case 3: {
                        TedBottomPicker.this.startGalleryIntent();
                        break;
                    }
                    case 1: {
                        TedBottomPicker.this.complete(pickerTile.getImageUri());
                        break;
                    }
                    default: {
                        TedBottomPicker.this.errorMessage();
                    }
                }
            }
        });
    }

    private void setTitle() {
        if (!this.builder.showTitle) {
            this.tv_title.setVisibility(8);
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.builder.title)) {
            this.tv_title.setText((CharSequence)this.builder.title);
        }
        if (this.builder.titleBackgroundResId > 0) {
            this.tv_title.setBackgroundResource(this.builder.titleBackgroundResId);
        }
    }

    private void complete(Uri uri) {
        this.builder.onImageSelectedListener.onImageSelected(uri);
        this.dismiss();
    }

    private void startCameraIntent() {
        Intent cameraInent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (cameraInent.resolveActivity(this.getActivity().getPackageManager()) == null) {
            this.errorMessage("This Application do not have Camera Application");
            return;
        }
        File imageFile = this.getImageFile();
        cameraInent.putExtra("output", (Parcelable)Uri.fromFile((File)imageFile));
        this.startActivityForResult(cameraInent, 1);
    }

    private void startGalleryIntent() {
        Intent galleryIntent = new Intent("android.intent.action.PICK", MediaStore.Images.Media.EXTERNAL_CONTENT_URI);
        if (galleryIntent.resolveActivity(this.getActivity().getPackageManager()) == null) {
            this.errorMessage("This Application do not have Gallery Application");
            return;
        }
        this.startActivityForResult(galleryIntent, 2);
    }

    private File getImageFile() {
        File imageFile = null;
        try {
            String timeStamp = new SimpleDateFormat("yyyyMMddHHmmss", Locale.getDefault()).format(new Date());
            String imageFileName = "JPEG_" + timeStamp + "_";
            File storageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
            imageFile = File.createTempFile(imageFileName, ".jpg", storageDir);
            this.cameraImageUri = Uri.fromFile((File)imageFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.errorMessage("Could not create imageFile for camera");
        }
        return imageFile;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            Uri selectedImageUri = null;
            if (requestCode == 2 && data != null) {
                selectedImageUri = data.getData();
                if (selectedImageUri == null) {
                    this.errorMessage();
                }
            } else if (requestCode == 1) {
                selectedImageUri = this.cameraImageUri;
                MediaScannerConnection.scanFile((Context)this.getContext(), (String[])new String[]{selectedImageUri.getPath()}, (String[])new String[]{"image/jpeg"}, null);
            }
            if (selectedImageUri != null) {
                this.complete(selectedImageUri);
            } else {
                this.errorMessage();
            }
        }
    }

    private void errorMessage() {
        this.errorMessage(null);
    }

    private void errorMessage(String message) {
        String errorMessage;
        String string = errorMessage = message == null ? "Something wrong." : message;
        if (this.builder.onErrorListener == null) {
            Toast.makeText((Context)this.getActivity(), (CharSequence)errorMessage, (int)0).show();
        } else {
            this.builder.onErrorListener.onError(errorMessage);
        }
    }

    public static class Builder {
        public Context context;
        public int maxCount = 25;
        public Drawable cameraTileDrawable;
        public Drawable galleryTileDrawable;
        public int spacing = 1;
        public OnImageSelectedListener onImageSelectedListener;
        public OnErrorListener onErrorListener;
        public ImageProvider imageProvider;
        public boolean showCamera = true;
        public boolean showGallery = true;
        public int peekHeight = -1;
        public int cameraTileBackgroundResId = R.color.camera;
        public int galleryTileBackgroundResId = R.color.gallery;
        public String title;
        public boolean showTitle = true;
        public int titleBackgroundResId;

        public Builder(@NonNull Context context) {
            this.context = context;
            this.setCameraTile(R.drawable.ic_camera);
            this.setGalleryTile(R.drawable.ic_gallery);
            this.setSpacingResId(R.dimen.grid_layout_margin);
        }

        public Builder setMaxCount(int maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        public Builder setOnImageSelectedListener(OnImageSelectedListener onImageSelectedListener) {
            this.onImageSelectedListener = onImageSelectedListener;
            return this;
        }

        public Builder setOnErrorListener(OnErrorListener onErrorListener) {
            this.onErrorListener = onErrorListener;
            return this;
        }

        public Builder showCameraTile(boolean showCamera) {
            this.showCamera = showCamera;
            return this;
        }

        public Builder setCameraTile(@DrawableRes int cameraTileResId) {
            this.setCameraTile(ContextCompat.getDrawable((Context)this.context, (int)cameraTileResId));
            return this;
        }

        public Builder setCameraTile(Drawable cameraTileDrawable) {
            this.cameraTileDrawable = cameraTileDrawable;
            return this;
        }

        public Builder showGalleryTile(boolean showGallery) {
            this.showGallery = showGallery;
            return this;
        }

        public Builder setGalleryTile(@DrawableRes int galleryTileResId) {
            this.setGalleryTile(ContextCompat.getDrawable((Context)this.context, (int)galleryTileResId));
            return this;
        }

        public Builder setGalleryTile(Drawable galleryTileDrawable) {
            this.galleryTileDrawable = galleryTileDrawable;
            return this;
        }

        public Builder setSpacing(int spacing) {
            this.spacing = spacing;
            return this;
        }

        public Builder setSpacingResId(@DimenRes int dimenResId) {
            this.spacing = this.context.getResources().getDimensionPixelSize(dimenResId);
            return this;
        }

        public Builder setPeekHeight(int peekHeight) {
            this.peekHeight = peekHeight;
            return this;
        }

        public Builder setPeekHeightResId(@DimenRes int dimenResId) {
            this.peekHeight = this.context.getResources().getDimensionPixelSize(dimenResId);
            return this;
        }

        public Builder setCameraTileBackgroundResId(@ColorRes int colorResId) {
            this.cameraTileBackgroundResId = colorResId;
            return this;
        }

        public Builder setGalleryTileBackgroundResId(@ColorRes int colorResId) {
            this.galleryTileBackgroundResId = colorResId;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setTitle(@StringRes int stringResId) {
            this.title = this.context.getResources().getString(stringResId);
            return this;
        }

        public Builder showTitle(boolean showTitle) {
            this.showTitle = showTitle;
            return this;
        }

        public Builder setTitleBackgroundResId(@ColorRes int colorResId) {
            this.titleBackgroundResId = colorResId;
            return this;
        }

        public Builder setImageProvider(ImageProvider imageProvider) {
            this.imageProvider = imageProvider;
            return this;
        }

        public TedBottomPicker create() {
            if (Build.VERSION.SDK_INT >= 16 && ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                throw new RuntimeException("Missing required WRITE_EXTERNAL_STORAGE permission. Did you remember to request it first?");
            }
            if (this.onImageSelectedListener == null) {
                throw new RuntimeException("You have to setOnImageSelectedListener() for receive selected Uri");
            }
            TedBottomPicker customBottomSheetDialogFragment = new TedBottomPicker();
            customBottomSheetDialogFragment.builder = this;
            return customBottomSheetDialogFragment;
        }
    }

    public static interface ImageProvider {
        public void onProvideImage(ImageView var1, Uri var2);
    }

    public static interface OnErrorListener {
        public void onError(String var1);
    }

    public static interface OnImageSelectedListener {
        public void onImageSelected(Uri var1);
    }
}

