/*
 * Decompiled with CFR 0.152.
 */
package gun0912.tedadhelper.nativead;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.facebook.ads.Ad;
import com.facebook.ads.AdChoicesView;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.MediaView;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.NativeExpressAdView;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeAppInstallAdView;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeContentAdView;
import com.tnkfactory.ad.NativeAdItem;
import com.tnkfactory.ad.NativeAdListener;
import com.tnkfactory.ad.TnkSession;
import gun0912.tedadhelper.R;
import gun0912.tedadhelper.TedAdHelper;
import gun0912.tedadhelper.nativead.OnNativeAdListener;
import gun0912.tedadhelper.util.ConvertUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TedNativeAd {
    ArrayList<Integer> adPriorityList;
    String app_name;
    String facebook_ad_key;
    String admob_ad_key;
    Context context;
    NativeAppInstallAdView admobAppInstallRootView;
    NativeContentAdView admobContentRootView;
    ViewGroup container_admob_express;
    ProgressBar progressView;
    RelativeLayout viewNativeRoot;
    LinearLayout view_container;
    ImageView ivLogo;
    TextView tvName;
    TextView tvBody;
    MediaView nativeAdMedia;
    ImageView ivImage;
    TextView tvEtc;
    TextView tvCallToAction;
    com.facebook.ads.NativeAd facebookAd;
    OnNativeAdListener onNativeAdListener;
    ViewGroup view_ad_choice;
    TedAdHelper.ImageProvider imageProvider;
    ViewGroup containerView;
    ViewGroup admobBannerContainer;
    int admobNativeAdType;

    public TedNativeAd(ViewGroup containerView, Context context, String app_name, String facebook_ad_key, String admob_ad_key) {
        this(containerView, context, app_name, facebook_ad_key, admob_ad_key, null, 1);
    }

    public TedNativeAd(ViewGroup itemView, Context context, String app_name, String facebook_ad_key, String admob_ad_key, TedAdHelper.ImageProvider imageProvider, int admobNativeAdType) {
        this.containerView = itemView;
        this.context = context;
        this.app_name = app_name;
        this.facebook_ad_key = facebook_ad_key;
        this.admob_ad_key = admob_ad_key;
        this.imageProvider = imageProvider;
        this.admobNativeAdType = admobNativeAdType;
        this.initView();
    }

    private void initView() {
        View nativeView = View.inflate((Context)this.context, (int)R.layout.adview_native_base, null);
        this.viewNativeRoot = (RelativeLayout)nativeView.findViewById(R.id.view_native_root);
        this.admobAppInstallRootView = (NativeAppInstallAdView)nativeView.findViewById(R.id.admobAppInstallRootView);
        this.admobContentRootView = (NativeContentAdView)nativeView.findViewById(R.id.admobContentRootView);
        this.admobBannerContainer = (ViewGroup)nativeView.findViewById(R.id.admob_banner_container);
        this.container_admob_express = (ViewGroup)nativeView.findViewById(R.id.container_admob_express);
        this.progressView = (ProgressBar)nativeView.findViewById(R.id.progressView);
        this.view_container = (LinearLayout)nativeView.findViewById(R.id.view_container);
        this.ivLogo = (ImageView)nativeView.findViewById(R.id.iv_logo);
        this.tvName = (TextView)nativeView.findViewById(R.id.tv_name);
        this.tvBody = (TextView)nativeView.findViewById(R.id.tv_body);
        this.nativeAdMedia = (MediaView)nativeView.findViewById(R.id.native_ad_media);
        this.ivImage = (ImageView)nativeView.findViewById(R.id.iv_image);
        this.tvEtc = (TextView)nativeView.findViewById(R.id.tv_etc);
        this.tvCallToAction = (TextView)nativeView.findViewById(R.id.tv_call_to_action);
        this.view_ad_choice = (ViewGroup)nativeView.findViewById(R.id.view_ad_choice);
        this.containerView.removeAllViews();
        this.containerView.addView(nativeView);
    }

    public TedNativeAd(ViewGroup containerView, Context context, String app_name, String facebook_ad_key, String admob_ad_key, int admobNativeAdType) {
        this(containerView, context, app_name, facebook_ad_key, admob_ad_key, null, admobNativeAdType);
    }

    public void onDestroy() {
        if (this.nativeAdMedia != null) {
            this.nativeAdMedia.destroy();
        }
        if (this.facebookAd != null) {
            this.facebookAd.destroy();
        }
    }

    public void loadFacebookAD(OnNativeAdListener onNativeAdListener) {
        this.loadAD(1, onNativeAdListener);
    }

    public void loadAdmobAD(OnNativeAdListener onNativeAdListener) {
        this.loadAD(2, onNativeAdListener);
    }

    public void loadAD(int adPriority, OnNativeAdListener onNativeAdListener) {
        Integer[] tempAdPriorityList = new Integer[]{adPriority, adPriority == 1 ? Integer.valueOf(2) : Integer.valueOf(1)};
        this.loadAD(tempAdPriorityList, onNativeAdListener);
    }

    public void loadAD(Integer[] tempAdPriorityList, OnNativeAdListener onNativeAdListener) {
        if (tempAdPriorityList == null || tempAdPriorityList.length == 0) {
            if (onNativeAdListener != null) {
                onNativeAdListener.onError("You have to select priority type ADMOB/FACEBOOK/TNK");
            }
            return;
        }
        ArrayList<Integer> resultTempAdPriorityList = new ArrayList<Integer>(Arrays.asList(tempAdPriorityList));
        this.loadAD(resultTempAdPriorityList, onNativeAdListener);
    }

    public void loadAD(ArrayList tempAdPriorityList, OnNativeAdListener onNativeAdListener) {
        block4: {
            this.onNativeAdListener = onNativeAdListener;
            if (tempAdPriorityList == null || tempAdPriorityList.size() == 0) {
                if (onNativeAdListener != null) {
                    onNativeAdListener.onError("You have to select priority type ADMOB/FACEBOOK/TNK");
                }
                return;
            }
            this.adPriorityList = tempAdPriorityList;
            try {
                this.selectAd();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (onNativeAdListener == null) break block4;
                onNativeAdListener.onError(e.toString());
            }
        }
    }

    private void selectAd() {
        this.view_ad_choice.removeAllViews();
        int adPriority = this.adPriorityList.remove(0);
        switch (adPriority) {
            case 1: {
                this.loadFacebookAD();
                break;
            }
            case 2: {
                this.selectAdmobAd();
                break;
            }
            case 3: {
                this.loadTnkAD();
                break;
            }
            default: {
                this.onNativeAdListener.onError("You have to select priority type ADMOB or FACEBOOK");
            }
        }
    }

    private void selectAdmobAd() {
        switch (this.admobNativeAdType) {
            case 1: {
                this.loadAdmobExpressAD();
                break;
            }
            case 2: {
                this.loadAdmobAdvanceAD();
                break;
            }
            case 3: {
                this.loadAdmobBanner();
            }
        }
    }

    private void loadAdmobBanner() {
        this.viewNativeRoot.setVisibility(8);
        this.admobBannerContainer.removeAllViews();
        AdView admobBannerView = new AdView(this.context);
        AdRequest adRequest = new AdRequest.Builder().build();
        admobBannerView.setAdSize(AdSize.MEDIUM_RECTANGLE);
        admobBannerView.setAdUnitId(this.admob_ad_key);
        admobBannerView.setAdListener(new com.google.android.gms.ads.AdListener(){

            public void onAdClosed() {
                super.onAdClosed();
            }

            public void onAdFailedToLoad(int errorCode) {
                super.onAdFailedToLoad(errorCode);
                String errorMessage = TedAdHelper.getMessageFromAdmobErrorCode(errorCode);
                Log.e((String)"TedAdHelper", (String)("[ADMOB NATIVE BANNER AD]errorMessage: " + errorMessage));
                TedNativeAd.this.onLoadAdError(errorMessage);
            }

            public void onAdLeftApplication() {
                super.onAdLeftApplication();
            }

            public void onAdOpened() {
                super.onAdOpened();
                Log.d((String)"TedAdHelper", (String)"[ADMOB NATIVE BANNER AD]Opend");
            }

            public void onAdLoaded() {
                super.onAdLoaded();
                Log.d((String)"TedAdHelper", (String)"[ADMOB NATIVE BANNER AD]Loaded");
            }
        });
        admobBannerView.loadAd(adRequest);
        this.admobBannerContainer.addView((View)admobBannerView);
    }

    private void onLoadAdError(String errorMessage) {
        if (this.adPriorityList.size() > 0) {
            this.selectAd();
        } else {
            this.viewNativeRoot.setVisibility(8);
            if (this.onNativeAdListener != null) {
                this.onNativeAdListener.onError(errorMessage);
            }
        }
    }

    private void loadAdmobExpressAD() {
        this.viewNativeRoot.setVisibility(0);
        this.progressView.setVisibility(0);
        this.view_container.setVisibility(4);
        final NativeExpressAdView admobExpressAdView = new NativeExpressAdView(this.context);
        admobExpressAdView.setVideoOptions(new VideoOptions.Builder().setStartMuted(true).build());
        admobExpressAdView.setAdListener(new com.google.android.gms.ads.AdListener(){

            public void onAdLoaded() {
                Log.d((String)"TedAdHelper", (String)"[ADMOB NATIVE EXPRESS AD]Loaded");
                TedNativeAd.this.view_container.setVisibility(8);
                TedNativeAd.this.progressView.setVisibility(8);
                if (TedNativeAd.this.onNativeAdListener != null) {
                    TedNativeAd.this.onNativeAdListener.onLoaded(2);
                }
            }

            public void onAdFailedToLoad(int errorCode) {
                super.onAdFailedToLoad(errorCode);
                String errorMessage = TedAdHelper.getMessageFromAdmobErrorCode(errorCode);
                Log.e((String)"TedAdHelper", (String)("[ADMOB NATIVE EXPRESS AD]errorMessage: " + errorMessage));
                TedNativeAd.this.onLoadAdError(errorMessage);
            }

            public void onAdOpened() {
                Log.d((String)"TedAdHelper", (String)"[ADMOB NATIVE EXPRESS AD]Opend");
                super.onAdOpened();
                if (TedNativeAd.this.onNativeAdListener != null) {
                    TedNativeAd.this.onNativeAdListener.onAdClicked(2);
                }
            }
        });
        this.container_admob_express.post(new Runnable(){

            @Override
            public void run() {
                int realWidth = ConvertUtil.pxToDp(TedNativeAd.this.context, TedNativeAd.this.container_admob_express.getWidth());
                int realHeight = 320 * realWidth / 360;
                if (admobExpressAdView.getAdUnitId() == null) {
                    admobExpressAdView.setAdUnitId(TedNativeAd.this.admob_ad_key);
                }
                if (admobExpressAdView.getAdSize() == null) {
                    admobExpressAdView.setAdSize(new AdSize(realWidth, realHeight));
                }
                for (int i = 0; i < TedNativeAd.this.container_admob_express.getChildCount(); ++i) {
                    if (!(TedNativeAd.this.container_admob_express.getChildAt(i) instanceof NativeExpressAdView)) continue;
                    NativeExpressAdView temp = (NativeExpressAdView)TedNativeAd.this.container_admob_express.getChildAt(i);
                    temp.destroy();
                }
                TedNativeAd.this.container_admob_express.removeAllViews();
                TedNativeAd.this.container_admob_express.addView((View)admobExpressAdView);
                admobExpressAdView.loadAd(TedAdHelper.getAdRequest());
            }
        });
    }

    private void loadTnkAD() {
        this.viewNativeRoot.setVisibility(0);
        this.progressView.setVisibility(0);
        this.view_container.setVisibility(4);
        TnkSession.prepareNativeAd((Context)this.context, (String)"__tnk_cpc__", (int)2, (NativeAdListener)new NativeAdListener(){

            public void onFailure(int errCode) {
                String errorMessage = TedAdHelper.getMessageFromTnkErrorCode(errCode);
                Log.e((String)"TedAdHelper", (String)("[TNK NATIVE AD]" + errorMessage));
                TedNativeAd.this.onLoadAdError(errorMessage);
            }

            public void onLoad(NativeAdItem adItem) {
                Log.d((String)"TedAdHelper", (String)"[TNK NATIVE AD]onLoad");
                TedNativeAd.this.bindTnkAD(adItem);
                if (TedNativeAd.this.onNativeAdListener != null) {
                    TedNativeAd.this.onNativeAdListener.onLoaded(1);
                }
            }

            public void onClick() {
                Log.d((String)"TedAdHelper", (String)"[TNK NATIVE AD]onClick");
                if (TedNativeAd.this.onNativeAdListener != null) {
                    TedNativeAd.this.onNativeAdListener.onAdClicked(1);
                }
            }

            public void onShow() {
                Log.d((String)"TedAdHelper", (String)"[TNK NATIVE AD]onShow");
            }
        });
    }

    private void loadAdmobAdvanceAD() {
        this.viewNativeRoot.setVisibility(0);
        this.progressView.setVisibility(0);
        this.view_container.setVisibility(4);
        AdLoader.Builder builder = new AdLoader.Builder(this.context, this.admob_ad_key);
        builder.forAppInstallAd(new NativeAppInstallAd.OnAppInstallAdLoadedListener(){

            public void onAppInstallAdLoaded(NativeAppInstallAd nativeAppInstallAd) {
                TedNativeAd.this.bindAdmobAppInstallAD(nativeAppInstallAd);
                Log.d((String)"TedAdHelper", (String)"[ADMOB NATIVE ADVANCED AD]InstallAd Load");
            }
        });
        builder.forContentAd(new NativeContentAd.OnContentAdLoadedListener(){

            public void onContentAdLoaded(NativeContentAd nativeContentAd) {
                Log.d((String)"TedAdHelper", (String)"[ADMOB NATIVE ADVANCED AD]ContentAd Load");
                TedNativeAd.this.bindAdmobContentAD(nativeContentAd);
            }
        });
        VideoOptions videoOptions = new VideoOptions.Builder().setStartMuted(true).build();
        NativeAdOptions adOptions = new NativeAdOptions.Builder().setVideoOptions(videoOptions).build();
        builder.withNativeAdOptions(adOptions);
        AdLoader adLoader = builder.withAdListener(new com.google.android.gms.ads.AdListener(){

            public void onAdFailedToLoad(int errorCode) {
                super.onAdFailedToLoad(errorCode);
                Log.e((String)"TedAdHelper", (String)"[ADMOB NATIVE ADVANCED AD]fail");
                String errorMessage = TedAdHelper.getMessageFromAdmobErrorCode(errorCode);
                TedNativeAd.this.onLoadAdError(errorMessage);
            }
        }).build();
        AdRequest.Builder requestBuilder = new AdRequest.Builder();
        adLoader.loadAd(requestBuilder.build());
    }

    private void loadFacebookAD() {
        if (TedAdHelper.isSkipFacebookAd(this.context)) {
            Log.e((String)"TedAdHelper", (String)"[FACEBOOK NATIVE AD]Error: Facebook app not installed");
            this.onLoadAdError("Facebook app not installed");
            return;
        }
        this.viewNativeRoot.setVisibility(0);
        this.progressView.setVisibility(0);
        this.view_container.setVisibility(4);
        this.facebookAd = new com.facebook.ads.NativeAd(this.context, this.facebook_ad_key);
        this.facebookAd.setAdListener(new AdListener(){

            public void onError(Ad ad, AdError error) {
                Log.e((String)"TedAdHelper", (String)("[FACEBOOK NATIVE AD]Error: " + error.getErrorMessage()));
                TedNativeAd.this.onLoadAdError(error.getErrorMessage());
            }

            public void onAdLoaded(Ad ad) {
                Log.d((String)"TedAdHelper", (String)"[FACEBOOK NATIVE AD]Loaded");
                TedNativeAd.this.bindFacebookAD(ad);
                if (TedNativeAd.this.onNativeAdListener != null) {
                    TedNativeAd.this.onNativeAdListener.onLoaded(1);
                }
            }

            public void onAdClicked(Ad ad) {
                Log.d((String)"TedAdHelper", (String)"[FACEBOOK NATIVE AD]Clicked");
                if (TedNativeAd.this.onNativeAdListener != null) {
                    TedNativeAd.this.onNativeAdListener.onAdClicked(1);
                }
            }

            public void onLoggingImpression(Ad ad) {
            }
        });
        this.facebookAd.loadAd();
    }

    private void bindTnkAD(NativeAdItem adItem) {
        MyNativeAd myNativeAd = new MyNativeAd();
        myNativeAd.setLogoUrl(adItem.getIconUrl());
        myNativeAd.setName(adItem.getTitle());
        myNativeAd.setImageUrl(adItem.getCoverImageUrl());
        myNativeAd.setBody(adItem.getDescription());
        this.bindNativeAd(myNativeAd);
        adItem.attachLayout((ViewGroup)this.viewNativeRoot);
    }

    private void bindFacebookAD(Ad ad) {
        if (this.facebookAd != ad) {
            this.viewNativeRoot.setVisibility(8);
            return;
        }
        MyNativeAd myNativeAd = new MyNativeAd();
        if (this.facebookAd.getAdIcon() != null) {
            myNativeAd.setLogoUrl(this.facebookAd.getAdIcon().getUrl());
        }
        myNativeAd.setName(this.facebookAd.getAdTitle());
        if (this.facebookAd.getAdCoverImage() != null) {
            myNativeAd.setImageUrl(this.facebookAd.getAdCoverImage().getUrl());
            this.nativeAdMedia.setVisibility(8);
        }
        myNativeAd.setBody(this.facebookAd.getAdBody());
        myNativeAd.setCallToAction(this.facebookAd.getAdCallToAction());
        myNativeAd.setEtc(this.facebookAd.getAdSocialContext());
        this.bindNativeAd(myNativeAd);
        this.nativeAdMedia.setNativeAd(this.facebookAd);
        AdChoicesView adChoicesView = new AdChoicesView(this.context, this.facebookAd, true);
        this.view_ad_choice.addView((View)adChoicesView);
        ArrayList<Object> clickableViews = new ArrayList<Object>();
        clickableViews.add(this.ivLogo);
        clickableViews.add(this.tvName);
        clickableViews.add(this.ivImage);
        clickableViews.add(this.tvCallToAction);
        this.facebookAd.unregisterView();
        this.facebookAd.registerViewForInteraction((View)this.viewNativeRoot, clickableViews);
    }

    private void bindNativeAd(MyNativeAd myNativeAd) {
        if (this.context instanceof Activity) {
            Activity activity = (Activity)this.context;
            if (Build.VERSION.SDK_INT >= 17 && activity.isDestroyed()) {
                return;
            }
            if (activity.isFinishing()) {
                return;
            }
        }
        String logoUrl = myNativeAd.getLogoUrl();
        Drawable logoDrawable = myNativeAd.getLogoDrawable();
        if (logoDrawable != null) {
            this.ivLogo.setImageDrawable(logoDrawable);
        } else if (this.imageProvider == null) {
            Glide.with((Context)this.context).load(logoUrl).into(this.ivLogo);
        } else {
            this.imageProvider.onProvideImage(this.ivLogo, logoUrl);
        }
        String name = myNativeAd.getName();
        if (TextUtils.isEmpty((CharSequence)name)) {
            name = this.app_name + " \uad11\uace0";
        }
        this.tvName.setText((CharSequence)name);
        String imageUrl = myNativeAd.getImageUrl();
        Drawable imageDrawable = myNativeAd.getImageDrawable();
        if (imageDrawable != null) {
            this.ivImage.setImageDrawable(imageDrawable);
        } else if (this.imageProvider == null) {
            Glide.with((Context)this.context).load(imageUrl).into(this.ivImage);
        } else {
            this.imageProvider.onProvideImage(this.ivImage, imageUrl);
        }
        String body = myNativeAd.getBody();
        this.tvBody.setText((CharSequence)body);
        String etc = myNativeAd.getEtc();
        if (TextUtils.isEmpty((CharSequence)etc)) {
            this.tvEtc.setVisibility(8);
        } else {
            this.tvEtc.setVisibility(0);
            this.tvEtc.setText((CharSequence)etc);
        }
        String callToAction = myNativeAd.getCallToAction();
        if (TextUtils.isEmpty((CharSequence)callToAction)) {
            this.tvCallToAction.setVisibility(8);
        } else {
            this.tvCallToAction.setVisibility(0);
            this.tvCallToAction.setText((CharSequence)myNativeAd.getCallToAction());
        }
        this.viewNativeRoot.setVisibility(0);
        this.view_container.setVisibility(0);
        this.container_admob_express.setVisibility(8);
        this.progressView.setVisibility(8);
    }

    private void bindAdmobContentAD(NativeContentAd nativeContentAd) {
        List images;
        if (nativeContentAd == null) {
            this.onLoadAdError("nativeContentAd is null");
            return;
        }
        MyNativeAd myNativeAd = new MyNativeAd();
        if (nativeContentAd.getLogo() != null) {
            myNativeAd.setLogoDrawable(nativeContentAd.getLogo().getDrawable());
        }
        if (nativeContentAd.getHeadline() != null) {
            myNativeAd.setName(nativeContentAd.getHeadline().toString());
            this.admobContentRootView.setHeadlineView((View)this.tvName);
        }
        if ((images = nativeContentAd.getImages()) != null && images.size() > 0) {
            myNativeAd.setImageDrawable(((NativeAd.Image)nativeContentAd.getImages().get(0)).getDrawable());
            this.admobContentRootView.setImageView((View)this.ivImage);
        }
        if (nativeContentAd.getBody() != null) {
            myNativeAd.setBody(nativeContentAd.getBody().toString());
            this.admobContentRootView.setBodyView((View)this.tvBody);
        }
        if (nativeContentAd.getCallToAction() != null) {
            myNativeAd.setCallToAction(nativeContentAd.getCallToAction().toString());
            this.admobContentRootView.setCallToActionView((View)this.tvCallToAction);
        }
        if (nativeContentAd.getAdvertiser() != null) {
            myNativeAd.setEtc(nativeContentAd.getAdvertiser().toString());
        }
        this.bindNativeAd(myNativeAd);
        this.admobContentRootView.setNativeAd((NativeAd)nativeContentAd);
    }

    private void bindAdmobAppInstallAD(NativeAppInstallAd nativeAppInstallAd) {
        List images;
        if (nativeAppInstallAd == null) {
            this.onLoadAdError("nativeAppInstallAd is null");
            return;
        }
        MyNativeAd myNativeAd = new MyNativeAd();
        if (nativeAppInstallAd.getIcon() != null) {
            myNativeAd.setLogoDrawable(nativeAppInstallAd.getIcon().getDrawable());
            this.admobAppInstallRootView.setIconView((View)this.ivLogo);
        }
        if (nativeAppInstallAd.getHeadline() != null) {
            myNativeAd.setName(nativeAppInstallAd.getHeadline().toString());
            this.admobAppInstallRootView.setHeadlineView((View)this.tvName);
        }
        if ((images = nativeAppInstallAd.getImages()) != null && images.size() > 0) {
            myNativeAd.setImageDrawable(((NativeAd.Image)nativeAppInstallAd.getImages().get(0)).getDrawable());
            this.admobAppInstallRootView.setImageView((View)this.ivImage);
        }
        if (nativeAppInstallAd.getBody() != null) {
            myNativeAd.setBody(nativeAppInstallAd.getBody().toString());
            this.admobAppInstallRootView.setBodyView((View)this.tvBody);
        }
        if (nativeAppInstallAd.getCallToAction() != null) {
            myNativeAd.setCallToAction(nativeAppInstallAd.getCallToAction().toString());
            this.admobAppInstallRootView.setCallToActionView((View)this.tvCallToAction);
        }
        if (nativeAppInstallAd.getStore() != null) {
            myNativeAd.setEtc(nativeAppInstallAd.getStore().toString());
            this.admobAppInstallRootView.setStoreView((View)this.tvEtc);
        }
        this.bindNativeAd(myNativeAd);
        this.admobAppInstallRootView.setNativeAd((NativeAd)nativeAppInstallAd);
    }

    class MyNativeAd {
        String logoUrl;
        Drawable logoDrawable;
        String name;
        String imageUrl;
        Drawable imageDrawable;
        String body;
        String callToAction;
        String etc;

        MyNativeAd() {
        }

        public String getLogoUrl() {
            return this.logoUrl;
        }

        public void setLogoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getImageUrl() {
            return this.imageUrl;
        }

        public void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        public String getBody() {
            return this.body;
        }

        public void setBody(String body) {
            this.body = body;
        }

        public String getCallToAction() {
            return this.callToAction;
        }

        public void setCallToAction(String callToAction) {
            this.callToAction = callToAction;
        }

        public String getEtc() {
            return this.etc;
        }

        public void setEtc(String etc) {
            this.etc = etc;
        }

        public Drawable getLogoDrawable() {
            return this.logoDrawable;
        }

        public void setLogoDrawable(Drawable logoDrawable) {
            this.logoDrawable = logoDrawable;
        }

        public Drawable getImageDrawable() {
            return this.imageDrawable;
        }

        public void setImageDrawable(Drawable imageDrawable) {
            this.imageDrawable = imageDrawable;
        }
    }
}

